/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;

public class NormMax
extends BaseAccumulation {
    public NormMax() {
    }

    public NormMax(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public NormMax(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public NormMax(INDArray x) {
        super(x);
    }

    public NormMax(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public INDArray noOp() {
        return Transforms.abs(this.x());
    }

    @Override
    public double update(double accum, double x) {
        ++this.numProcessed;
        return FastMath.max((double)FastMath.abs((double)x), (double)accum);
    }

    @Override
    public double update(double accum, double x, double y) {
        return this.update(accum, x);
    }

    @Override
    public float update(float accum, float x) {
        return x >= 0.0f ? (x > accum ? x : accum) : (-x > accum ? -x : accum);
    }

    @Override
    public float update(float accum, float x, float y) {
        return x >= 0.0f ? (x > accum ? x : accum) : (-x > accum ? -x : accum);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x) {
        return accum.absoluteValue().doubleValue() >= FastMath.abs((double)x) ? accum : Nd4j.createComplexNumber(FastMath.abs((double)x), 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, double x, double y) {
        return accum.absoluteValue().doubleValue() >= FastMath.abs((double)x) ? accum : Nd4j.createComplexNumber(FastMath.abs((double)x), 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accum : Nd4j.createComplexNumber(x.absoluteValue(), 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, IComplexNumber y) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accum : Nd4j.createComplexNumber(x.absoluteValue(), 0);
    }

    @Override
    public IComplexNumber update(IComplexNumber accum, IComplexNumber x, double y) {
        return accum.absoluteValue().doubleValue() >= x.absoluteValue().doubleValue() ? accum : Nd4j.createComplexNumber(x.absoluteValue(), 0);
    }

    @Override
    public int opNum() {
        return 7;
    }

    @Override
    public String name() {
        return "normmax";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new NormMax(xAlongDimension, this.y.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new NormMax(this.x.vectorAlongDimension(index, dimension));
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new NormMax(xAlongDimension, this.y.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new NormMax(this.x.tensorAlongDimension(index, dimension));
    }
}

