/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import lombok.NonNull;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class And
extends BaseTransformOp {
    protected double comparable;

    public And() {
    }

    public And(@NonNull INDArray x, @NonNull INDArray y) {
        this(x, y, 0.0);
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
    }

    public And(@NonNull INDArray x, @NonNull INDArray y, Number comparable) {
        this(x, y, x, comparable, x.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
    }

    public And(@NonNull INDArray x, @NonNull INDArray y, INDArray z, Number comparable) {
        this(x, y, z, comparable, x.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
    }

    public And(@NonNull INDArray x, @NonNull INDArray y, long n) {
        this(x, y, x, n);
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
    }

    public And(@NonNull INDArray x, @NonNull INDArray y, INDArray z) {
        this(x, y, z, z.lengthLong());
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
    }

    public And(@NonNull INDArray x, @NonNull INDArray y, INDArray z, long n) {
        this(x, y, z, 0.0, n);
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
    }

    public And(@NonNull INDArray x, @NonNull INDArray y, INDArray z, Number comparable, long n) {
        super(x, y, z, n);
        if (x == null) {
            throw new NullPointerException("x");
        }
        if (y == null) {
            throw new NullPointerException("y");
        }
        this.comparable = comparable.doubleValue();
        this.extraArgs = new Object[]{this.comparable};
    }

    @Override
    public int opNum() {
        return 56;
    }

    @Override
    public String name() {
        return "boolean_and";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return null;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return null;
    }

    @Override
    public float op(float origin, float other) {
        return 0.0f;
    }

    @Override
    public double op(double origin, double other) {
        return 0.0;
    }

    @Override
    public double op(double origin) {
        return 0.0;
    }

    @Override
    public float op(float origin) {
        return 0.0f;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return null;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new And(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new And(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new And(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new And(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

