/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class Floor
extends BaseTransformOp {
    public Floor() {
    }

    public Floor(INDArray x, INDArray z) {
        super(x, z);
    }

    public Floor(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public Floor(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Floor(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 4;
    }

    @Override
    public String name() {
        return "floor";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return ComplexUtil.floor(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return ComplexUtil.floor(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return ComplexUtil.floor(origin);
    }

    @Override
    public float op(float origin, float other) {
        return (float)FastMath.floor((double)origin);
    }

    @Override
    public double op(double origin, double other) {
        return FastMath.floor((double)origin);
    }

    @Override
    public double op(double origin) {
        return FastMath.floor((double)origin);
    }

    @Override
    public float op(float origin) {
        return (float)FastMath.floor((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return ComplexUtil.floor(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Floor(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Floor(xAlongDimension, this.z.vectorAlongDimension(index, dimension), this.x.lengthLong());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new Floor(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new Floor(xAlongDimension, this.z.tensorAlongDimension(index, dimension), this.x.lengthLong());
    }
}

