/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.LeakyReLUDerivative;
import org.nd4j.linalg.factory.Nd4j;

public class LeakyReLU
extends BaseTransformOp {
    public static final double DEFAULT_ALPHA = 0.01;
    private double alpha = 0.01;

    public LeakyReLU() {
    }

    public LeakyReLU(INDArray x, double alpha) {
        super(x);
        this.alpha = alpha;
        this.init(x, this.y, this.z, this.n);
    }

    public LeakyReLU(INDArray x, INDArray z, double alpha) {
        super(x, z);
        this.alpha = alpha;
        this.init(x, this.y, z, this.n);
    }

    public LeakyReLU(INDArray x, INDArray z, long n, double alpha) {
        super(x, z, n);
        this.alpha = alpha;
        this.init(x, this.y, z, n);
    }

    public LeakyReLU(INDArray x, INDArray y, INDArray z, long n, double alpha) {
        super(x, y, z, n);
        this.alpha = alpha;
        this.init(x, y, z, n);
    }

    public LeakyReLU(INDArray x, INDArray z) {
        super(x, z);
    }

    public LeakyReLU(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public LeakyReLU(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public LeakyReLU(INDArray x) {
        super(x);
        this.extraArgs = new Object[]{this.alpha};
    }

    @Override
    public int opNum() {
        return 31;
    }

    @Override
    public String name() {
        return "leakyrelu";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        double rv = origin.realComponent().doubleValue();
        return rv < 0.0 ? Nd4j.createComplexNumber(this.alpha * rv, 0) : origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        double rv = origin.realComponent().doubleValue();
        return rv < 0.0 ? Nd4j.createComplexNumber(this.alpha * rv, 0) : origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        double rv = origin.realComponent().doubleValue();
        return rv < 0.0 ? Nd4j.createComplexNumber(this.alpha * rv, 0) : origin;
    }

    @Override
    public float op(float origin, float other) {
        return origin < 0.0f ? (float)this.alpha * origin : origin;
    }

    @Override
    public double op(double origin, double other) {
        return origin < 0.0 ? this.alpha * origin : origin;
    }

    @Override
    public double op(double origin) {
        return origin < 0.0 ? this.alpha * origin : origin;
    }

    @Override
    public float op(float origin) {
        return origin < 0.0f ? (float)this.alpha * origin : origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        double rv = origin.realComponent().doubleValue();
        return rv < 0.0 ? Nd4j.createComplexNumber(this.alpha * rv, 0) : origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LeakyReLU(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
        }
        return new LeakyReLU(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new LeakyReLU(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
        }
        return new LeakyReLU(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.alpha);
    }

    @Override
    public TransformOp derivative() {
        return new LeakyReLUDerivative(this.x, this.y, this.z, this.n, this.alpha);
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.alpha};
    }
}

