/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class SELUDerivative
extends BaseTransformOp {
    private static final double SELU_ALPHA = 1.6732632423543772;
    private static final double SELU_LAMBDA = 1.0507009873554805;

    public SELUDerivative() {
    }

    public SELUDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public SELUDerivative(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public SELUDerivative(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 68;
    }

    @Override
    public String name() {
        return "seluderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float op(float origin, float other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double op(double origin, double other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double op(double d1) {
        return d1 > 0.0 ? 1.0507009873554805 : 1.7580993408473766 * FastMath.exp((double)d1);
    }

    @Override
    public float op(float d1) {
        return d1 > 0.0f ? 1.050701f : 1.7580993f * (float)FastMath.exp((double)d1);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        return new SELUDerivative(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        return new SELUDerivative(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }
}

