/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.factory.Nd4j;

public class SetRange
extends BaseTransformOp {
    private double min;
    private double max;

    public SetRange() {
    }

    public SetRange(INDArray x) {
        this(x, 0.0, 1.0);
    }

    public SetRange(INDArray x, INDArray z, double min, double max) {
        super(x, z);
        this.min = min;
        this.max = max;
        this.init(x, this.y, z, this.n);
    }

    public SetRange(INDArray x, INDArray z, long n, double min, double max) {
        super(x, z, n);
        this.min = min;
        this.max = max;
        this.init(x, this.y, z, n);
    }

    public SetRange(INDArray x, INDArray y, INDArray z, long n, double min, double max) {
        super(x, y, z, n);
        this.min = min;
        this.max = max;
        this.init(x, y, z, n);
    }

    public SetRange(INDArray x, double min, double max) {
        super(x);
        this.min = min;
        this.max = max;
        this.init(x, this.y, this.z, this.n);
    }

    @Override
    public int opNum() {
        return 9;
    }

    @Override
    public String name() {
        return "setrange";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return this.op(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return this.op(origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return this.op(origin);
    }

    @Override
    public float op(float origin, float other) {
        return this.op(origin);
    }

    @Override
    public double op(double origin, double other) {
        return this.op(origin);
    }

    @Override
    public double op(double origin) {
        if (origin >= this.min && origin <= this.max) {
            return origin;
        }
        if (this.min == 0.0 && this.max == 1.0) {
            double val = 1.0 / (1.0 + FastMath.exp((double)(-origin)));
            return FastMath.floor((double)(val * (this.max - this.min))) + this.min;
        }
        double ret = FastMath.floor((double)(origin * (this.max - this.min))) + this.min;
        return ret;
    }

    @Override
    public float op(float origin) {
        return (float)this.op((double)origin);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return Nd4j.createComplexNumber(this.op(origin.realComponent().doubleValue()), this.op(origin.imaginaryComponent().doubleValue()));
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        this.extraArgs = new Object[]{this.min, this.max};
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SetRange(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.min, this.max);
        }
        return new SetRange(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length(), this.min, this.max);
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SetRange(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.min, this.max);
        }
        return new SetRange(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length(), this.min, this.max);
    }
}

