/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.transforms.SoftSignDerivative;
import org.nd4j.linalg.util.ComplexUtil;

public class SoftSign
extends BaseTransformOp {
    public SoftSign() {
    }

    public SoftSign(INDArray x, INDArray z) {
        super(x, z);
    }

    public SoftSign(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public SoftSign(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public SoftSign(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 20;
    }

    @Override
    public String name() {
        return "softsign";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin.div(ComplexUtil.abs(origin).addi((Number)1.0));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin.div(ComplexUtil.abs(origin).addi((Number)1.0));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.div(ComplexUtil.abs(origin).addi((Number)1.0));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin.div(ComplexUtil.abs(origin).addi((Number)1.0));
    }

    @Override
    public float op(float origin, float other) {
        return (float)SoftSign.softsign(origin);
    }

    @Override
    public double op(double origin, double other) {
        return SoftSign.softsign(origin);
    }

    @Override
    public double op(double origin) {
        return SoftSign.softsign(origin);
    }

    @Override
    public float op(float origin) {
        return (float)SoftSign.softsign(origin);
    }

    @Override
    public TransformOp derivative() {
        return new SoftSignDerivative(this.x, this.y, this.z, this.n);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftSign(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftSign(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftSign(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftSign(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }

    private static double softsign(double x) {
        return x / (1.0 + Math.abs(x));
    }
}

