/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.util.ComplexUtil;

public class SoftSignDerivative
extends BaseTransformOp {
    public SoftSignDerivative() {
    }

    public SoftSignDerivative(INDArray x, INDArray z) {
        super(x, z);
    }

    public SoftSignDerivative(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public SoftSignDerivative(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public SoftSignDerivative(INDArray x) {
        super(x);
    }

    @Override
    public int opNum() {
        return 30;
    }

    @Override
    public String name() {
        return "softsignderivative";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        IComplexNumber oneMinusAbs = ComplexUtil.abs(origin).rsubi((Number)1.0);
        return oneMinusAbs.muli(oneMinusAbs).rdivi((Number)1.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        IComplexNumber oneMinusAbs = ComplexUtil.abs(origin).rsubi((Number)1.0);
        return oneMinusAbs.muli(oneMinusAbs).rdivi((Number)1.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        IComplexNumber oneMinusAbs = ComplexUtil.abs(origin).rsubi((Number)1.0);
        return oneMinusAbs.muli(oneMinusAbs).rdivi((Number)1.0);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        IComplexNumber oneMinusAbs = ComplexUtil.abs(origin).rsubi((Number)1.0);
        return oneMinusAbs.muli(oneMinusAbs).rdivi((Number)1.0);
    }

    @Override
    public float op(float origin, float other) {
        return (float)SoftSignDerivative.ssderiv(origin);
    }

    @Override
    public double op(double origin, double other) {
        return SoftSignDerivative.ssderiv(origin);
    }

    @Override
    public double op(double origin) {
        return SoftSignDerivative.ssderiv(origin);
    }

    @Override
    public float op(float origin) {
        return (float)SoftSignDerivative.ssderiv(origin);
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftSignDerivative(this.x.vectorAlongDimension(index, dimension), this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftSignDerivative(this.x.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new SoftSignDerivative(this.x.tensorAlongDimension(index, dimension), this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new SoftSignDerivative(this.x.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }

    private static double ssderiv(double x) {
        double y = 1.0 + FastMath.abs((double)x);
        return 1.0 / (y * y);
    }
}

