/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.arithmetic;

import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseTransformOp;
import org.nd4j.linalg.api.ops.Op;

public class DivOp
extends BaseTransformOp {
    public DivOp() {
    }

    public DivOp(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public DivOp(INDArray x) {
        super(x);
    }

    public DivOp(INDArray x, INDArray z) {
        super(x, z);
    }

    public DivOp(INDArray x, INDArray z, long n) {
        super(x, z, n);
    }

    public DivOp(INDArray x, INDArray y, INDArray z) {
        super(x, y, z, x.lengthLong());
    }

    @Override
    public int opNum() {
        return 2;
    }

    @Override
    public String name() {
        return "div";
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, double other) {
        return origin.div((Number)other);
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, float other) {
        return origin.div((Number)Float.valueOf(other));
    }

    @Override
    public IComplexNumber op(IComplexNumber origin, IComplexNumber other) {
        return origin.div(other);
    }

    @Override
    public float op(float origin, float other) {
        return origin / other;
    }

    @Override
    public double op(double origin, double other) {
        return origin / other;
    }

    @Override
    public double op(double origin) {
        return origin;
    }

    @Override
    public float op(float origin) {
        return origin;
    }

    @Override
    public IComplexNumber op(IComplexNumber origin) {
        return origin;
    }

    @Override
    public Op opForDimension(int index, int dimension) {
        INDArray xAlongDimension = this.x.vectorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new DivOp(xAlongDimension, this.y.vectorAlongDimension(index, dimension), this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new DivOp(xAlongDimension, this.z.vectorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public Op opForDimension(int index, int ... dimension) {
        INDArray xAlongDimension = this.x.tensorAlongDimension(index, dimension);
        if (this.y() != null) {
            return new DivOp(xAlongDimension, this.y.tensorAlongDimension(index, dimension), this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
        }
        return new DivOp(xAlongDimension, this.z.tensorAlongDimension(index, dimension), xAlongDimension.length());
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        if (y == null) {
            throw new IllegalArgumentException("No components to divide");
        }
    }
}

