/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape.loop.four;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.StridePermutation;
import org.nd4j.linalg.util.ArrayUtil;

public class RawArrayIterationInformation4
implements Serializable {
    private int nDim;
    private int aOffset = -1;
    private int bOffset = -1;
    private int cOffset = -1;
    private int dOffset = -1;
    private int[] aStrides;
    private int[] bStrides;
    private int[] cStrides;
    private int[] dStrides;
    private int[] shape;
    private DataBuffer a;
    private DataBuffer b;
    private DataBuffer c;
    private DataBuffer d;

    public RawArrayIterationInformation4 computeOut() {
        int i;
        int aOffset = this.aOffset;
        int bOffset = this.bOffset;
        int[] aStrides = ArrayUtil.copy((int[])this.aStrides);
        int[] bStrides = ArrayUtil.copy((int[])this.bStrides);
        int[] cStrides = ArrayUtil.copy((int[])this.cStrides);
        int[] dStrides = ArrayUtil.copy((int[])this.dStrides);
        int[] shape = ArrayUtil.copy((int[])this.shape);
        int nDim = this.nDim;
        StridePermutation[] perms = Shape.createSortedStrides(aStrides);
        for (i = 0; i < nDim; ++i) {
            int iPerm = perms[nDim - i - 1].getPermutation();
            shape[i] = this.shape[iPerm];
            aStrides[i] = aStrides[iPerm];
            bStrides[i] = bStrides[iPerm];
            cStrides[i] = cStrides[iPerm];
            dStrides[i] = dStrides[iPerm];
        }
        for (i = 0; i < nDim; ++i) {
            int outStrideA = aStrides[i];
            int outStrideB = bStrides[i];
            int outStrideC = cStrides[i];
            int outStrideD = dStrides[i];
            int shapeI = shape[i];
            if (outStrideA >= 0) continue;
            aOffset += outStrideA * shapeI - 1;
            bOffset += outStrideB * shapeI - 1;
            int n = i;
            aStrides[n] = aStrides[n] - outStrideA;
            int n2 = i;
            bStrides[n2] = bStrides[n2] - outStrideB;
            int n3 = i;
            cStrides[n3] = cStrides[n3] - outStrideC;
            int n4 = i;
            dStrides[n4] = dStrides[n4] - outStrideD;
        }
        i = 0;
        for (int j = 1; j < nDim; ++j) {
            if (shape[i] == 1) {
                shape[i] = shape[j];
                aStrides[i] = aStrides[j];
                bStrides[i] = bStrides[j];
                cStrides[i] = cStrides[j];
                dStrides[i] = dStrides[j];
                continue;
            }
            if (shape[j] == 1) continue;
            if (aStrides[i] * shape[i] == aStrides[j] && bStrides[i] * shape[i] == bStrides[j] && bStrides[i] * shape[i] == cStrides[j] && dStrides[i] * shape[i] == dStrides[j]) {
                int n = i;
                shape[n] = shape[n] * shape[j];
                continue;
            }
            shape[++i] = shape[j];
            aStrides[i] = aStrides[j];
            bStrides[i] = bStrides[j];
            cStrides[i] = cStrides[j];
            dStrides[i] = dStrides[j];
        }
        nDim = i + 1;
        return RawArrayIterationInformation4.builder().aOffset(aOffset).a(this.a).b(this.b).c(this.c).d(this.d).bOffset(bOffset).aStrides(aStrides).bStrides(bStrides).cStrides(cStrides).dStrides(dStrides).shape(shape).nDim(nDim).build();
    }

    public static RawArrayIterationInformation4Builder builder() {
        return new RawArrayIterationInformation4Builder();
    }

    public int getNDim() {
        return this.nDim;
    }

    public int getAOffset() {
        return this.aOffset;
    }

    public int getBOffset() {
        return this.bOffset;
    }

    public int getCOffset() {
        return this.cOffset;
    }

    public int getDOffset() {
        return this.dOffset;
    }

    public int[] getAStrides() {
        return this.aStrides;
    }

    public int[] getBStrides() {
        return this.bStrides;
    }

    public int[] getCStrides() {
        return this.cStrides;
    }

    public int[] getDStrides() {
        return this.dStrides;
    }

    public int[] getShape() {
        return this.shape;
    }

    public DataBuffer getA() {
        return this.a;
    }

    public DataBuffer getB() {
        return this.b;
    }

    public DataBuffer getC() {
        return this.c;
    }

    public DataBuffer getD() {
        return this.d;
    }

    public void setNDim(int nDim) {
        this.nDim = nDim;
    }

    public void setAOffset(int aOffset) {
        this.aOffset = aOffset;
    }

    public void setBOffset(int bOffset) {
        this.bOffset = bOffset;
    }

    public void setCOffset(int cOffset) {
        this.cOffset = cOffset;
    }

    public void setDOffset(int dOffset) {
        this.dOffset = dOffset;
    }

    public void setAStrides(int[] aStrides) {
        this.aStrides = aStrides;
    }

    public void setBStrides(int[] bStrides) {
        this.bStrides = bStrides;
    }

    public void setCStrides(int[] cStrides) {
        this.cStrides = cStrides;
    }

    public void setDStrides(int[] dStrides) {
        this.dStrides = dStrides;
    }

    public void setShape(int[] shape) {
        this.shape = shape;
    }

    public void setA(DataBuffer a) {
        this.a = a;
    }

    public void setB(DataBuffer b) {
        this.b = b;
    }

    public void setC(DataBuffer c) {
        this.c = c;
    }

    public void setD(DataBuffer d) {
        this.d = d;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawArrayIterationInformation4)) {
            return false;
        }
        RawArrayIterationInformation4 other = (RawArrayIterationInformation4)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNDim() != other.getNDim()) {
            return false;
        }
        if (this.getAOffset() != other.getAOffset()) {
            return false;
        }
        if (this.getBOffset() != other.getBOffset()) {
            return false;
        }
        if (this.getCOffset() != other.getCOffset()) {
            return false;
        }
        if (this.getDOffset() != other.getDOffset()) {
            return false;
        }
        if (!Arrays.equals(this.getAStrides(), other.getAStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getBStrides(), other.getBStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getCStrides(), other.getCStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getDStrides(), other.getDStrides())) {
            return false;
        }
        if (!Arrays.equals(this.getShape(), other.getShape())) {
            return false;
        }
        DataBuffer this$a = this.getA();
        DataBuffer other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        DataBuffer this$b = this.getB();
        DataBuffer other$b = other.getB();
        if (this$b == null ? other$b != null : !this$b.equals(other$b)) {
            return false;
        }
        DataBuffer this$c = this.getC();
        DataBuffer other$c = other.getC();
        if (this$c == null ? other$c != null : !this$c.equals(other$c)) {
            return false;
        }
        DataBuffer this$d = this.getD();
        DataBuffer other$d = other.getD();
        return !(this$d == null ? other$d != null : !this$d.equals(other$d));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawArrayIterationInformation4;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNDim();
        result = result * 59 + this.getAOffset();
        result = result * 59 + this.getBOffset();
        result = result * 59 + this.getCOffset();
        result = result * 59 + this.getDOffset();
        result = result * 59 + Arrays.hashCode(this.getAStrides());
        result = result * 59 + Arrays.hashCode(this.getBStrides());
        result = result * 59 + Arrays.hashCode(this.getCStrides());
        result = result * 59 + Arrays.hashCode(this.getDStrides());
        result = result * 59 + Arrays.hashCode(this.getShape());
        DataBuffer $a = this.getA();
        result = result * 59 + ($a == null ? 43 : $a.hashCode());
        DataBuffer $b = this.getB();
        result = result * 59 + ($b == null ? 43 : $b.hashCode());
        DataBuffer $c = this.getC();
        result = result * 59 + ($c == null ? 43 : $c.hashCode());
        DataBuffer $d = this.getD();
        result = result * 59 + ($d == null ? 43 : $d.hashCode());
        return result;
    }

    public String toString() {
        return "RawArrayIterationInformation4(nDim=" + this.getNDim() + ", aOffset=" + this.getAOffset() + ", bOffset=" + this.getBOffset() + ", cOffset=" + this.getCOffset() + ", dOffset=" + this.getDOffset() + ", aStrides=" + Arrays.toString(this.getAStrides()) + ", bStrides=" + Arrays.toString(this.getBStrides()) + ", cStrides=" + Arrays.toString(this.getCStrides()) + ", dStrides=" + Arrays.toString(this.getDStrides()) + ", shape=" + Arrays.toString(this.getShape()) + ", a=" + this.getA() + ", b=" + this.getB() + ", c=" + this.getC() + ", d=" + this.getD() + ")";
    }

    @ConstructorProperties(value={"nDim", "aOffset", "bOffset", "cOffset", "dOffset", "aStrides", "bStrides", "cStrides", "dStrides", "shape", "a", "b", "c", "d"})
    public RawArrayIterationInformation4(int nDim, int aOffset, int bOffset, int cOffset, int dOffset, int[] aStrides, int[] bStrides, int[] cStrides, int[] dStrides, int[] shape, DataBuffer a, DataBuffer b, DataBuffer c, DataBuffer d) {
        this.nDim = nDim;
        this.aOffset = aOffset;
        this.bOffset = bOffset;
        this.cOffset = cOffset;
        this.dOffset = dOffset;
        this.aStrides = aStrides;
        this.bStrides = bStrides;
        this.cStrides = cStrides;
        this.dStrides = dStrides;
        this.shape = shape;
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public RawArrayIterationInformation4() {
    }

    public static class RawArrayIterationInformation4Builder {
        private int nDim;
        private int aOffset;
        private int bOffset;
        private int cOffset;
        private int dOffset;
        private int[] aStrides;
        private int[] bStrides;
        private int[] cStrides;
        private int[] dStrides;
        private int[] shape;
        private DataBuffer a;
        private DataBuffer b;
        private DataBuffer c;
        private DataBuffer d;

        RawArrayIterationInformation4Builder() {
        }

        public RawArrayIterationInformation4Builder nDim(int nDim) {
            this.nDim = nDim;
            return this;
        }

        public RawArrayIterationInformation4Builder aOffset(int aOffset) {
            this.aOffset = aOffset;
            return this;
        }

        public RawArrayIterationInformation4Builder bOffset(int bOffset) {
            this.bOffset = bOffset;
            return this;
        }

        public RawArrayIterationInformation4Builder cOffset(int cOffset) {
            this.cOffset = cOffset;
            return this;
        }

        public RawArrayIterationInformation4Builder dOffset(int dOffset) {
            this.dOffset = dOffset;
            return this;
        }

        public RawArrayIterationInformation4Builder aStrides(int[] aStrides) {
            this.aStrides = aStrides;
            return this;
        }

        public RawArrayIterationInformation4Builder bStrides(int[] bStrides) {
            this.bStrides = bStrides;
            return this;
        }

        public RawArrayIterationInformation4Builder cStrides(int[] cStrides) {
            this.cStrides = cStrides;
            return this;
        }

        public RawArrayIterationInformation4Builder dStrides(int[] dStrides) {
            this.dStrides = dStrides;
            return this;
        }

        public RawArrayIterationInformation4Builder shape(int[] shape) {
            this.shape = shape;
            return this;
        }

        public RawArrayIterationInformation4Builder a(DataBuffer a) {
            this.a = a;
            return this;
        }

        public RawArrayIterationInformation4Builder b(DataBuffer b) {
            this.b = b;
            return this;
        }

        public RawArrayIterationInformation4Builder c(DataBuffer c) {
            this.c = c;
            return this;
        }

        public RawArrayIterationInformation4Builder d(DataBuffer d) {
            this.d = d;
            return this;
        }

        public RawArrayIterationInformation4 build() {
            return new RawArrayIterationInformation4(this.nDim, this.aOffset, this.bOffset, this.cOffset, this.dOffset, this.aStrides, this.bStrides, this.cStrides, this.dStrides, this.shape, this.a, this.b, this.c, this.d);
        }

        public String toString() {
            return "RawArrayIterationInformation4.RawArrayIterationInformation4Builder(nDim=" + this.nDim + ", aOffset=" + this.aOffset + ", bOffset=" + this.bOffset + ", cOffset=" + this.cOffset + ", dOffset=" + this.dOffset + ", aStrides=" + Arrays.toString(this.aStrides) + ", bStrides=" + Arrays.toString(this.bStrides) + ", cStrides=" + Arrays.toString(this.cStrides) + ", dStrides=" + Arrays.toString(this.dStrides) + ", shape=" + Arrays.toString(this.shape) + ", a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", d=" + this.d + ")";
        }
    }
}

