/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastAddOp;
import org.nd4j.linalg.api.ops.impl.broadcast.BroadcastSubOp;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.preprocessor.DataNormalization;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VGG16ImagePreProcessor
implements DataNormalization {
    private static final Logger log = LoggerFactory.getLogger(VGG16ImagePreProcessor.class);
    public static final INDArray VGG_MEAN_OFFSET_BGR = Nd4j.create(new double[]{123.68, 116.779, 103.939});

    @Override
    public void fit(DataSet dataSet) {
    }

    @Override
    public void fit(DataSetIterator iterator) {
    }

    @Override
    public void preProcess(DataSet toPreProcess) {
        INDArray features = toPreProcess.getFeatures();
        this.preProcess(features);
    }

    public void preProcess(INDArray features) {
        Nd4j.getExecutioner().execAndReturn(new BroadcastSubOp(features.dup(), VGG_MEAN_OFFSET_BGR, features, 1));
    }

    @Override
    public void transform(DataSet toPreProcess) {
        this.preProcess(toPreProcess);
    }

    @Override
    public void transform(INDArray features) {
        this.preProcess(features);
    }

    @Override
    public void transform(INDArray features, INDArray featuresMask) {
        this.transform(features);
    }

    @Override
    public void transformLabel(INDArray label) {
    }

    @Override
    public void transformLabel(INDArray labels, INDArray labelsMask) {
        this.transformLabel(labels);
    }

    @Override
    public void revert(DataSet toRevert) {
        this.revertFeatures(toRevert.getFeatures());
    }

    @Override
    public NormalizerType getType() {
        return NormalizerType.IMAGE_VGG16;
    }

    @Override
    public void revertFeatures(INDArray features) {
        Nd4j.getExecutioner().execAndReturn(new BroadcastAddOp(features.dup(), VGG_MEAN_OFFSET_BGR, features, 1));
    }

    @Override
    public void revertFeatures(INDArray features, INDArray featuresMask) {
        this.revertFeatures(features);
    }

    @Override
    public void revertLabels(INDArray labels) {
    }

    @Override
    public void revertLabels(INDArray labels, INDArray labelsMask) {
        this.revertLabels(labels);
    }

    @Override
    public void fitLabel(boolean fitLabels) {
        if (fitLabels) {
            log.warn("Labels fitting not currently supported for ImagePreProcessingScaler. Labels will not be modified");
        }
    }

    @Override
    public boolean isFitLabel() {
        return false;
    }
}

