/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor.serializer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.NonNull;
import org.nd4j.linalg.dataset.api.preprocessor.NormalizerStandardize;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerSerializerStrategy;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;
import org.nd4j.linalg.factory.Nd4j;

public class StandardizeSerializerStrategy
implements NormalizerSerializerStrategy<NormalizerStandardize> {
    @Override
    public void write(@NonNull NormalizerStandardize normalizer, @NonNull OutputStream stream) throws IOException {
        if (normalizer == null) {
            throw new NullPointerException("normalizer");
        }
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        try (DataOutputStream dos = new DataOutputStream(stream);){
            dos.writeBoolean(normalizer.isFitLabel());
            Nd4j.write(normalizer.getMean(), dos);
            Nd4j.write(normalizer.getStd(), dos);
            if (normalizer.isFitLabel()) {
                Nd4j.write(normalizer.getLabelMean(), dos);
                Nd4j.write(normalizer.getLabelStd(), dos);
            }
            dos.flush();
        }
    }

    @Override
    public NormalizerStandardize restore(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        DataInputStream dis = new DataInputStream(stream);
        boolean fitLabels = dis.readBoolean();
        NormalizerStandardize result = new NormalizerStandardize(Nd4j.read(dis), Nd4j.read(dis));
        result.fitLabel(fitLabels);
        if (fitLabels) {
            result.setLabelStats(Nd4j.read(dis), Nd4j.read(dis));
        }
        return result;
    }

    @Override
    public NormalizerType getSupportedType() {
        return NormalizerType.STANDARDIZE;
    }
}

