/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.AdaDeltaUpdater;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.IUpdater;

public class AdaDelta
implements IUpdater {
    public static final double DEFAULT_ADADELTA_RHO = 0.95;
    public static final double DEFAULT_ADADELTA_EPSILON = 1.0E-6;
    private double rho;
    private double epsilon;

    public AdaDelta() {
        this(0.95, 1.0E-6);
    }

    @Override
    public long stateSize(long numParams) {
        return 2L * numParams;
    }

    @Override
    public void applySchedules(int iteration, double newLearningRate) {
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        AdaDeltaUpdater u = new AdaDeltaUpdater(this);
        int[] gradientShape = viewArray.shape();
        gradientShape = Arrays.copyOf(gradientShape, gradientShape.length);
        gradientShape[1] = gradientShape[1] / 2;
        u.setStateViewArray(viewArray, gradientShape, viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public AdaDelta clone() {
        return new AdaDelta(this.rho, this.epsilon);
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getRho() {
        return this.rho;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaDelta)) {
            return false;
        }
        AdaDelta other = (AdaDelta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getRho(), other.getRho()) != 0) {
            return false;
        }
        return Double.compare(this.getEpsilon(), other.getEpsilon()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaDelta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $rho = Double.doubleToLongBits(this.getRho());
        result = result * 59 + (int)($rho >>> 32 ^ $rho);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        return result;
    }

    public String toString() {
        return "AdaDelta(rho=" + this.getRho() + ", epsilon=" + this.getEpsilon() + ")";
    }

    @ConstructorProperties(value={"rho", "epsilon"})
    public AdaDelta(double rho, double epsilon) {
        this.rho = rho;
        this.epsilon = epsilon;
    }

    public static class Builder {
        private double rho = 0.95;
        private double epsilon = 1.0E-6;

        public Builder rho(double rho) {
            this.rho = rho;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public AdaDelta build() {
            return new AdaDelta(this.rho, this.epsilon);
        }

        public String toString() {
            return "AdaDelta.Builder(rho=" + this.rho + ", epsilon=" + this.epsilon + ")";
        }
    }
}

