/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.config;

import java.beans.ConstructorProperties;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.AdaGradUpdater;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.IUpdater;

public class AdaGrad
implements IUpdater {
    public static final double DEFAULT_ADAGRAD_LEARNING_RATE = 0.1;
    public static final double DEFAULT_ADAGRAD_EPSILON = 1.0E-6;
    private double learningRate;
    private double epsilon;

    public AdaGrad() {
        this(0.1, 1.0E-6);
    }

    @Override
    public long stateSize(long numParams) {
        return numParams;
    }

    @Override
    public void applySchedules(int iteration, double newLearningRate) {
        this.learningRate = newLearningRate;
    }

    @Override
    public GradientUpdater instantiate(INDArray viewArray, boolean initializeViewArray) {
        AdaGradUpdater u = new AdaGradUpdater(this);
        u.setStateViewArray(viewArray, viewArray.shape(), viewArray.ordering(), initializeViewArray);
        return u;
    }

    @Override
    public AdaGrad clone() {
        return new AdaGrad(this.learningRate, this.epsilon);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"learningRate", "epsilon"})
    public AdaGrad(double learningRate, double epsilon) {
        this.learningRate = learningRate;
        this.epsilon = epsilon;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaGrad)) {
            return false;
        }
        AdaGrad other = (AdaGrad)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLearningRate(), other.getLearningRate()) != 0) {
            return false;
        }
        return Double.compare(this.getEpsilon(), other.getEpsilon()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdaGrad;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $learningRate = Double.doubleToLongBits(this.getLearningRate());
        result = result * 59 + (int)($learningRate >>> 32 ^ $learningRate);
        long $epsilon = Double.doubleToLongBits(this.getEpsilon());
        result = result * 59 + (int)($epsilon >>> 32 ^ $epsilon);
        return result;
    }

    public String toString() {
        return "AdaGrad(learningRate=" + this.getLearningRate() + ", epsilon=" + this.getEpsilon() + ")";
    }

    public static class Builder {
        private double learningRate = 0.1;
        private double epsilon = 1.0E-6;

        public Builder learningRate(double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder epsilon(double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public AdaGrad build() {
            return new AdaGrad(this.learningRate, this.epsilon);
        }

        public String toString() {
            return "AdaGrad.Builder(learningRate=" + this.learningRate + ", epsilon=" + this.epsilon + ")";
        }
    }
}

