/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.listeners;

import lombok.NonNull;
import org.nd4j.autodiff.listeners.Operation;
import org.nd4j.autodiff.samediff.internal.FrameIter;

public class At {
    private int epoch;
    private int iteration;
    private int trainingThreadNum;
    private long javaThreadNum;
    private FrameIter frameIter;
    private Operation operation;

    public static At defaultAt() {
        return new At(0, 0, 0, 0L, null, Operation.INFERENCE);
    }

    public static At defaultAt(@NonNull Operation op) {
        if (op == null) {
            throw new NullPointerException("op is marked non-null but is null");
        }
        return new At(0, 0, 0, 0L, null, op);
    }

    public int epoch() {
        return this.epoch;
    }

    public int iteration() {
        return this.iteration;
    }

    public int trainingThreadNum() {
        return this.trainingThreadNum;
    }

    public long javaThreadNum() {
        return this.javaThreadNum;
    }

    public Operation operation() {
        return this.operation;
    }

    public At copy() {
        return new At(this.epoch, this.iteration, this.trainingThreadNum, this.javaThreadNum, this.frameIter, this.operation);
    }

    public At copy(Operation operation) {
        return new At(this.epoch, this.iteration, this.trainingThreadNum, this.javaThreadNum, this.frameIter, operation);
    }

    public static AtBuilder builder() {
        return new AtBuilder();
    }

    public At(int epoch, int iteration, int trainingThreadNum, long javaThreadNum, FrameIter frameIter, Operation operation) {
        this.epoch = epoch;
        this.iteration = iteration;
        this.trainingThreadNum = trainingThreadNum;
        this.javaThreadNum = javaThreadNum;
        this.frameIter = frameIter;
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof At)) {
            return false;
        }
        At other = (At)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.epoch != other.epoch) {
            return false;
        }
        if (this.iteration != other.iteration) {
            return false;
        }
        if (this.trainingThreadNum != other.trainingThreadNum) {
            return false;
        }
        if (this.javaThreadNum != other.javaThreadNum) {
            return false;
        }
        FrameIter this$frameIter = this.frameIter;
        FrameIter other$frameIter = other.frameIter;
        if (this$frameIter == null ? other$frameIter != null : !((Object)this$frameIter).equals(other$frameIter)) {
            return false;
        }
        Operation this$operation = this.operation;
        Operation other$operation = other.operation;
        return !(this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof At;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.epoch;
        result = result * 59 + this.iteration;
        result = result * 59 + this.trainingThreadNum;
        long $javaThreadNum = this.javaThreadNum;
        result = result * 59 + (int)($javaThreadNum >>> 32 ^ $javaThreadNum);
        FrameIter $frameIter = this.frameIter;
        result = result * 59 + ($frameIter == null ? 43 : ((Object)$frameIter).hashCode());
        Operation $operation = this.operation;
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        return result;
    }

    public String toString() {
        return "At(epoch=" + this.epoch + ", iteration=" + this.iteration + ", trainingThreadNum=" + this.trainingThreadNum + ", javaThreadNum=" + this.javaThreadNum + ", frameIter=" + this.frameIter + ", operation=" + this.operation + ")";
    }

    public void setEpoch(int epoch) {
        this.epoch = epoch;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public void setTrainingThreadNum(int trainingThreadNum) {
        this.trainingThreadNum = trainingThreadNum;
    }

    public void setJavaThreadNum(long javaThreadNum) {
        this.javaThreadNum = javaThreadNum;
    }

    public void setFrameIter(FrameIter frameIter) {
        this.frameIter = frameIter;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public static class AtBuilder {
        private int epoch;
        private int iteration;
        private int trainingThreadNum;
        private long javaThreadNum;
        private FrameIter frameIter;
        private Operation operation;

        AtBuilder() {
        }

        public AtBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        public AtBuilder iteration(int iteration) {
            this.iteration = iteration;
            return this;
        }

        public AtBuilder trainingThreadNum(int trainingThreadNum) {
            this.trainingThreadNum = trainingThreadNum;
            return this;
        }

        public AtBuilder javaThreadNum(long javaThreadNum) {
            this.javaThreadNum = javaThreadNum;
            return this;
        }

        public AtBuilder frameIter(FrameIter frameIter) {
            this.frameIter = frameIter;
            return this;
        }

        public AtBuilder operation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public At build() {
            return new At(this.epoch, this.iteration, this.trainingThreadNum, this.javaThreadNum, this.frameIter, this.operation);
        }

        public String toString() {
            return "At.AtBuilder(epoch=" + this.epoch + ", iteration=" + this.iteration + ", trainingThreadNum=" + this.trainingThreadNum + ", javaThreadNum=" + this.javaThreadNum + ", frameIter=" + this.frameIter + ", operation=" + this.operation + ")";
        }
    }
}

