/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.internal.DependencyList;
import org.nd4j.autodiff.samediff.internal.IDependencyMap;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.function.Predicate;
import org.nd4j.common.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDependencyTracker<T, D> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDependencyTracker.class);
    private final IDependencyMap<T, D> dependencies;
    private final IDependencyMap<T, Pair<D, D>> orDependencies;
    private final Map<D, Set<T>> reverseDependencies = new LinkedHashMap<D, Set<T>>();
    private final Map<D, Set<T>> reverseOrDependencies = new HashMap<D, Set<T>>();
    private final Set<D> satisfiedDependencies = new LinkedHashSet<D>();
    private final Set<T> allSatisfied;
    private final Queue<T> allSatisfiedQueue = new LinkedList<T>();

    protected AbstractDependencyTracker() {
        this.dependencies = this.newTMap();
        this.orDependencies = this.newTMap();
        this.allSatisfied = this.newTSet();
    }

    protected abstract IDependencyMap<T, ?> newTMap();

    protected abstract Set<T> newTSet();

    protected abstract String toStringT(T var1);

    protected abstract String toStringD(D var1);

    public void clear() {
        this.dependencies.clear();
        this.orDependencies.clear();
        this.reverseDependencies.clear();
        this.reverseOrDependencies.clear();
        this.satisfiedDependencies.clear();
        this.allSatisfied.clear();
        this.allSatisfiedQueue.clear();
    }

    public boolean isEmpty() {
        return this.dependencies.isEmpty() && this.orDependencies.isEmpty() && this.allSatisfiedQueue.isEmpty();
    }

    public boolean isSatisfied(@NonNull D x) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        boolean ret = this.satisfiedDependencies.contains(x);
        return ret;
    }

    public void markSatisfied(@NonNull D x, boolean satisfied) {
        block19: {
            block18: {
                Set<T> set;
                if (x == null) {
                    throw new NullPointerException("x is marked non-null but is null");
                }
                if (!satisfied) break block18;
                boolean alreadySatisfied = this.satisfiedDependencies.contains(x);
                if (alreadySatisfied) break block19;
                this.satisfiedDependencies.add(x);
                Set<T> s = this.reverseDependencies.get(x);
                Set<T> s2 = this.reverseOrDependencies.get(x);
                if (s != null && s2 != null) {
                    set = this.newTSet();
                    set.addAll(s);
                    set.addAll(s2);
                } else if (s != null) {
                    set = s;
                } else if (s2 != null) {
                    set = s2;
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("No values depend on: {}", (Object)this.toStringD(x));
                    }
                    return;
                }
                for (T t : set) {
                    Iterable<Pair<D, D>> itOr;
                    boolean allSatisfied = true;
                    Iterable<D> it = this.dependencies.getDependantsForEach(t);
                    if (it != null) {
                        for (D d : it) {
                            if (this.isSatisfied(d)) continue;
                            allSatisfied = false;
                            break;
                        }
                    }
                    if (allSatisfied && (itOr = this.orDependencies.getDependantsForEach(t)) != null) {
                        for (Pair<D, D> p : itOr) {
                            if (this.isSatisfied(p.getFirst()) || this.isSatisfied(p.getSecond())) continue;
                            allSatisfied = false;
                            break;
                        }
                    }
                    if (!allSatisfied || this.allSatisfied.contains(t)) continue;
                    this.allSatisfied.add(t);
                    this.allSatisfiedQueue.add(t);
                }
                break block19;
            }
            this.satisfiedDependencies.remove(x);
            if (!this.allSatisfied.isEmpty()) {
                Set<T> orReverse;
                Set<T> reverse = this.reverseDependencies.get(x);
                if (reverse != null) {
                    for (T y : reverse) {
                        if (!this.allSatisfied.contains(y)) continue;
                        this.allSatisfied.remove(y);
                        this.allSatisfiedQueue.remove(y);
                    }
                }
                if ((orReverse = this.reverseOrDependencies.get(x)) != null) {
                    for (T y : orReverse) {
                        if (!this.allSatisfied.contains(y) || this.isAllSatisfied(y)) continue;
                        this.allSatisfied.remove(y);
                        this.allSatisfiedQueue.remove(y);
                    }
                }
            }
        }
    }

    public boolean hasDependency(@NonNull T y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (this.dependencies.containsAny(y)) {
            return true;
        }
        return this.orDependencies.containsAny(y);
    }

    public DependencyList<T, D> getDependencies(@NonNull T y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        Iterable<D> s1 = this.dependencies.getDependantsForEach(y);
        Iterable<Pair<D, D>> s2 = this.orDependencies.getDependantsForEach(y);
        return new DependencyList<T, D>(y, s1, s2);
    }

    public void addDependency(@NonNull T y, @NonNull D x) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (!this.reverseDependencies.containsKey(x)) {
            this.reverseDependencies.put(x, this.newTSet());
        }
        this.dependencies.add(y, x);
        this.reverseDependencies.get(x).add(y);
        this.checkAndUpdateIfAllSatisfied(y);
    }

    protected void checkAndUpdateIfAllSatisfied(@NonNull T y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        boolean allSat = this.isAllSatisfied(y);
        if (allSat) {
            if (!this.allSatisfied.contains(y)) {
                this.allSatisfied.add(y);
                this.allSatisfiedQueue.add(y);
            }
        } else if (this.allSatisfied.contains(y)) {
            if (!this.allSatisfiedQueue.contains(y)) {
                Iterable<Pair<D, D>> dlOr;
                StringBuilder sb = new StringBuilder();
                sb.append("Dependent object \"").append(this.toStringT(y)).append("\" was previously processed after all dependencies").append(" were marked satisfied, but is now additional dependencies have been added.\n");
                Iterable<D> dl = this.dependencies.getDependantsForEach(y);
                if (dl != null) {
                    sb.append("Dependencies:\n");
                    for (D d : dl) {
                        sb.append(d).append(" - ").append(this.isSatisfied(d) ? "Satisfied" : "Not satisfied").append("\n");
                    }
                }
                if ((dlOr = this.orDependencies.getDependantsForEach(y)) != null) {
                    sb.append("Or dependencies:\n");
                    for (Pair<D, D> p : dlOr) {
                        sb.append(p).append(" - satisfied=(").append(this.isSatisfied(p.getFirst())).append(",").append(this.isSatisfied(p.getSecond())).append(")");
                    }
                }
                this.allSatisfiedQueue.add(y);
                log.warn(sb.toString());
            }
            this.allSatisfied.remove(y);
            this.allSatisfiedQueue.remove(y);
        }
    }

    protected boolean isAllSatisfied(@NonNull T y) {
        boolean retVal;
        block4: {
            Pair<D, D> p;
            Iterable<Pair<D, D>> set2;
            if (y == null) {
                throw new NullPointerException("y is marked non-null but is null");
            }
            Iterable<D> set1 = this.dependencies.getDependantsForEach(y);
            retVal = true;
            if (set1 != null) {
                D d;
                Iterator<D> iterator = set1.iterator();
                while (iterator.hasNext() && (retVal = this.isSatisfied(d = iterator.next()))) {
                }
            }
            if (!retVal || (set2 = this.orDependencies.getDependantsForEach(y)) == null) break block4;
            Iterator<Pair<D, D>> iterator = set2.iterator();
            while (iterator.hasNext() && (retVal = this.isSatisfied((p = iterator.next()).getFirst()) || this.isSatisfied(p.getSecond()))) {
            }
        }
        return retVal;
    }

    public void removeDependency(@NonNull T y, @NonNull D x) {
        Iterable<Pair> s3;
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        this.dependencies.removeGroupReturn(y, t -> t.equals(x));
        Set<T> s2 = this.reverseDependencies.get(x);
        if (s2 != null) {
            s2.remove(y);
            if (s2.isEmpty()) {
                this.reverseDependencies.remove(x);
            }
        }
        if ((s3 = this.orDependencies.removeGroupReturn(y, t -> x.equals(t.getFirst()) || x.equals(t.getSecond()))) != null) {
            boolean removedReverse = false;
            for (Pair p : s3) {
                if (removedReverse) continue;
                Set<T> set1 = this.reverseOrDependencies.get(p.getFirst());
                Set<T> set2 = this.reverseOrDependencies.get(p.getSecond());
                set1.remove(y);
                set2.remove(y);
                if (set1.isEmpty()) {
                    this.reverseOrDependencies.remove(p.getFirst());
                }
                if (set2.isEmpty()) {
                    this.reverseOrDependencies.remove(p.getSecond());
                }
                removedReverse = true;
            }
        }
    }

    public void addOrDependency(@NonNull T y, @NonNull D x1, @NonNull D x2) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (!this.reverseOrDependencies.containsKey(x1)) {
            this.reverseOrDependencies.put(x1, this.newTSet());
        }
        if (!this.reverseOrDependencies.containsKey(x2)) {
            this.reverseOrDependencies.put(x2, this.newTSet());
        }
        this.orDependencies.add(y, new Pair(x1, x2));
        this.reverseOrDependencies.get(x1).add(y);
        this.reverseOrDependencies.get(x2).add(y);
        this.checkAndUpdateIfAllSatisfied(y);
    }

    public boolean hasNewAllSatisfied() {
        return !this.allSatisfiedQueue.isEmpty();
    }

    public T getNewAllSatisfied() {
        Preconditions.checkState((boolean)this.hasNewAllSatisfied(), (String)"No new/unprocessed dependents that are all satisfied");
        return this.allSatisfiedQueue.remove();
    }

    public List<T> getNewAllSatisfiedList() {
        Preconditions.checkState((boolean)this.hasNewAllSatisfied(), (String)"No new/unprocessed dependents that are all satisfied");
        ArrayList<T> ret = new ArrayList<T>(this.allSatisfiedQueue);
        this.allSatisfiedQueue.clear();
        return ret;
    }

    public T getFirstNewAllSatisfiedMatching(@NonNull Predicate<T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        Preconditions.checkState((boolean)this.hasNewAllSatisfied(), (String)"No new/unprocessed dependents that are all satisfied");
        Object t = this.allSatisfiedQueue.peek();
        if (predicate.test(t)) {
            t = this.allSatisfiedQueue.remove();
            this.allSatisfied.remove(t);
            return t;
        }
        if (this.allSatisfiedQueue.size() > 1) {
            Iterator iter = this.allSatisfiedQueue.iterator();
            while (iter.hasNext()) {
                t = iter.next();
                if (!predicate.test(t)) continue;
                iter.remove();
                this.allSatisfied.remove(t);
                return t;
            }
        }
        return null;
    }

    public IDependencyMap<T, D> getDependencies() {
        return this.dependencies;
    }

    public IDependencyMap<T, Pair<D, D>> getOrDependencies() {
        return this.orDependencies;
    }

    public Map<D, Set<T>> getReverseDependencies() {
        return this.reverseDependencies;
    }

    public Map<D, Set<T>> getReverseOrDependencies() {
        return this.reverseOrDependencies;
    }

    public Set<D> getSatisfiedDependencies() {
        return this.satisfiedDependencies;
    }

    public Set<T> getAllSatisfied() {
        return this.allSatisfied;
    }

    public Queue<T> getAllSatisfiedQueue() {
        return this.allSatisfiedQueue;
    }
}

