/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.optimize.optimizations;

import org.nd4j.autodiff.samediff.ArrayHolder;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.autodiff.samediff.optimize.OptimizationHelper;
import org.nd4j.autodiff.samediff.optimize.Optimizer;
import org.nd4j.autodiff.samediff.optimize.optimizations.BaseOptimizerSet;
import org.nd4j.autodiff.samediff.optimize.optimizations.OptimizationUtils;
import org.nd4j.linalg.api.ops.impl.transforms.same.Identity;

public class IdentityFunctionOptimizations
extends BaseOptimizerSet {

    public static class RemoveIdentityOps
    implements Optimizer {
        @Override
        public boolean checkAndApply(SameDiff sd, OptimizationHelper helper, SameDiffOp op, ArrayHolder constantArrays, ArrayHolder variablesArrays) {
            if (op.getOp() instanceof Identity) {
                String inName = op.getInputsToOp().get(0);
                String outputName = op.getOutputsOfOp().get(0);
                OptimizationUtils.removeOp(sd, op.getName());
                OptimizationUtils.replaceOpInputsWith(sd, outputName, inName);
                OptimizationUtils.removeVariable(sd, outputName);
                return true;
            }
            return false;
        }
    }

    public static class RemoveIdentityPermute
    implements Optimizer {
        @Override
        public boolean checkAndApply(SameDiff sd, OptimizationHelper helper, SameDiffOp op, ArrayHolder constantArrays, ArrayHolder variablesArrays) {
            return false;
        }
    }
}

