/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.optimize.optimizations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.autodiff.samediff.internal.Variable;

public class OptimizationUtils {
    private OptimizationUtils() {
    }

    public static void replaceOpInputsWith(SameDiff sd, @NonNull String replaceInput, @NonNull String newInput) {
        if (replaceInput == null) {
            throw new NullPointerException("replaceInput is marked non-null but is null");
        }
        if (newInput == null) {
            throw new NullPointerException("newInput is marked non-null but is null");
        }
        if (replaceInput.equals(newInput)) {
            return;
        }
        Collection<SameDiffOp> ops = sd.getOps().values();
        for (SameDiffOp o : ops) {
            List<String> l = o.getInputsToOp();
            while (l != null && l.contains(replaceInput)) {
                int idx = l.indexOf(replaceInput);
                l.set(idx, newInput);
            }
        }
        Variable v = (Variable)sd.getVariables().get((Object)replaceInput);
        Variable v2 = (Variable)sd.getVariables().get((Object)newInput);
        v2.setInputsForOp(v.getInputsForOp());
        v.setInputsForOp(new ArrayList<String>());
    }

    public static void removeOp(@NonNull SameDiff sd, @NonNull String opToRemove) {
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        if (opToRemove == null) {
            throw new NullPointerException("opToRemove is marked non-null but is null");
        }
        SameDiffOp op = sd.getOps().remove(opToRemove);
        for (String s : op.getInputsToOp()) {
            Variable v = (Variable)sd.getVariables().get((Object)s);
            v.getInputsForOp().remove(op.getName());
        }
    }

    public static void removeVariable(@NonNull SameDiff sd, @NonNull String varToRemove) {
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        if (varToRemove == null) {
            throw new NullPointerException("varToRemove is marked non-null but is null");
        }
        sd.getVariables().remove((Object)varToRemove);
    }
}

