/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.validation;

import java.util.List;
import org.nd4j.autodiff.listeners.At;
import org.nd4j.autodiff.listeners.BaseListener;
import org.nd4j.autodiff.listeners.Operation;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.internal.SameDiffOp;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.dataset.api.MultiDataSet;

public class ActivationGradientCheckListener
extends BaseListener {
    private String variableName;
    private long[] idx;
    private double eps;

    @Override
    public boolean isActive(Operation operation) {
        return true;
    }

    @Override
    public void opExecution(SameDiff sd, At at, MultiDataSet batch, SameDiffOp op, OpContext opContext, INDArray[] outputs) {
        Preconditions.checkState((this.variableName != null ? 1 : 0) != 0, (String)"No variable name has been set yet. Variable name must be set before using this listener");
        Preconditions.checkState((this.eps != 0.0 ? 1 : 0) != 0, (String)"Epsilon has not been set");
        List<String> outs = op.getOutputsOfOp();
        int i = 0;
        for (String s : outs) {
            if (this.variableName.equals(s)) {
                Preconditions.checkState((this.idx != null || outputs[i].isScalar() ? 1 : 0) != 0, (String)"No index to modify has been set yet. Index must be set before using this listener");
                double orig = outputs[i].getDouble(this.idx);
                outputs[i].putScalar(this.idx, orig + this.eps);
                return;
            }
            ++i;
        }
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public long[] getIdx() {
        return this.idx;
    }

    public void setIdx(long[] idx) {
        this.idx = idx;
    }

    public double getEps() {
        return this.eps;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }
}

