/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.imports.tensorflow;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;
import lombok.NonNull;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.util.ArchiveUtils;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.imports.tensorflow.TFImportStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class TensorFlowImportValidator {
    private static final Logger log = LoggerFactory.getLogger(TensorFlowImportValidator.class);

    public static TFImportStatus checkAllModelsForImport(@NonNull File directory) throws IOException {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return TensorFlowImportValidator.checkModelForImport(directory, false);
    }

    public static TFImportStatus checkAllModelsForImport(@NonNull File directory, boolean includeArchives) throws IOException {
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        ArrayList<String> fileExts = new ArrayList<String>();
        fileExts.add("pb");
        if (includeArchives) {
            fileExts.addAll(Arrays.asList("zip", "tar.gz", "gzip", "tgz", "gz", "7z", "tar.bz2", "tar.gz2", "tar.lz", "tar.lzma", "tg", "tar"));
        }
        return TensorFlowImportValidator.checkAllModelsForImport(directory, fileExts.toArray(new String[fileExts.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static TFImportStatus checkAllModelsForImport(File directory, String[] fileExtensions) throws IOException {
        Preconditions.checkState((boolean)directory.isDirectory(), (String)"Specified directory %s is not actually a directory", (Object)directory);
        files = FileUtils.listFiles((File)directory, (String[])fileExtensions, (boolean)true);
        Preconditions.checkState((boolean)(files.isEmpty() == false), (String)"No model files found in directory %s", (Object)directory);
        status = null;
        block38: for (File f : files) {
            block53: {
                block52: {
                    if (!TensorFlowImportValidator.isArchiveFile(f)) break block52;
                    p = f.getAbsolutePath();
                    TensorFlowImportValidator.log.info("Checking archive file for .pb files: " + p);
                    var8_8 = ext = FilenameUtils.getExtension((String)p).toLowerCase();
                    var9_9 = -1;
                    switch (var8_8.hashCode()) {
                        case 120609: {
                            if (!var8_8.equals("zip")) break;
                            var9_9 = 0;
                            break;
                        }
                        case 114597: {
                            if (!var8_8.equals("tar")) break;
                            var9_9 = 1;
                            break;
                        }
                        case -880960548: {
                            if (!var8_8.equals("tar.gz")) break;
                            var9_9 = 2;
                            break;
                        }
                        case -1539977967: {
                            if (!var8_8.equals("tar.bz2")) break;
                            var9_9 = 3;
                            break;
                        }
                        case 114791: {
                            if (!var8_8.equals("tgz")) break;
                            var9_9 = 4;
                            break;
                        }
                        case 3315: {
                            if (!var8_8.equals("gz")) break;
                            var9_9 = 5;
                            break;
                        }
                        case 98010: {
                            if (!var8_8.equals("bz2")) break;
                            var9_9 = 6;
                            break;
                        }
                        case 3189082: {
                            if (!var8_8.equals("gzip")) break;
                            var9_9 = 7;
                        }
                    }
                    switch (var9_9) {
                        case 0: {
                            try {
                                filesInZip = ArchiveUtils.zipListFiles((File)f);
                            }
                            catch (Throwable t) {
                                TensorFlowImportValidator.log.warn("Unable to read from file, skipping: {}", (Object)f.getAbsolutePath(), (Object)t);
                                continue block38;
                            }
                            for (String s : filesInZip) {
                                if (!s.endsWith(".pb")) continue;
                                zf = new ZipFile(f);
                                try {
                                    is = zf.getInputStream(zf.getEntry(s));
                                    try {
                                        p2 = p + "/" + s;
                                        TensorFlowImportValidator.log.info("Found possible frozen model (.pb) file in zip archive: {}", (Object)p2);
                                        currStatus = TensorFlowImportValidator.checkModelForImport(p2, is, false);
                                        if (currStatus.getCantImportModelPaths() != null && !currStatus.getCantImportModelPaths().isEmpty()) {
                                            TensorFlowImportValidator.log.info("Unable to load - not a frozen model .pb file: {}", (Object)p2);
                                        } else {
                                            TensorFlowImportValidator.log.info("Found frozen model .pb file in archive: {}", (Object)p2);
                                        }
                                        status = status == null ? currStatus : status.merge(currStatus);
                                    }
                                    finally {
                                        if (is == null) continue;
                                        is.close();
                                    }
                                }
                                finally {
                                    zf.close();
                                }
                            }
                            break block53;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (!p.endsWith(".tar.gz") && !p.endsWith(".tgz") && !p.endsWith(".tar") && !p.endsWith(".tar.bz2")) ** GOTO lbl116
                            isTar = p.endsWith(".tar");
                            try {
                                filesInTarGz = isTar != false ? ArchiveUtils.tarListFiles((File)f) : ArchiveUtils.tarGzListFiles((File)f);
                            }
                            catch (Throwable t) {
                                TensorFlowImportValidator.log.warn("Unable to read from file, skipping: {}", (Object)f.getAbsolutePath(), (Object)t);
                                continue block38;
                            }
                            for (String s : filesInTarGz) {
                                if (!s.endsWith(".pb")) continue;
                                if (p.endsWith(".tar")) {
                                    is = new TarArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(f)));
                                } else if (p.endsWith(".tar.gz") || p.endsWith(".tgz")) {
                                    is = new TarArchiveInputStream((InputStream)new GZIPInputStream(new BufferedInputStream(new FileInputStream(f))));
                                } else if (p.endsWith(".tar.bz2")) {
                                    is = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(f))));
                                } else {
                                    throw new RuntimeException("Can't parse file type: " + s);
                                }
                                try {
                                    p2 = p + "/" + s;
                                    TensorFlowImportValidator.log.info("Found possible frozen model (.pb) file in {} archive: {}", (Object)ext, (Object)p2);
                                    found = false;
                                    while ((entry = is.getNextTarEntry()) != null) {
                                        name = entry.getName();
                                        if (!s.equals(name)) continue;
                                        currStatus = TensorFlowImportValidator.checkModelForImport(p2, (InputStream)new CloseShieldInputStream((InputStream)is), false);
                                        if (currStatus.getCantImportModelPaths() != null && !currStatus.getCantImportModelPaths().isEmpty()) {
                                            TensorFlowImportValidator.log.info("Unable to load - not a frozen model .pb file: {}", (Object)p2);
                                        } else {
                                            TensorFlowImportValidator.log.info("Found frozen model .pb file in archive: {}", (Object)p2);
                                        }
                                        status = status == null ? currStatus : status.merge(currStatus);
                                        found = true;
                                    }
                                    Preconditions.checkState((boolean)found, (String)("Could not find expected tar entry in file: " + p2));
                                }
                                finally {
                                    is.close();
                                }
                            }
                            break block53;
                        }
lbl116:
                        // 2 sources

                        case 7: {
                            is = new GZIPInputStream(new BufferedInputStream(new FileInputStream(f)));
                            try {
                                try {
                                    currStatus = TensorFlowImportValidator.checkModelForImport(f.getAbsolutePath(), is, false);
                                    status = status == null ? currStatus : status.merge(currStatus);
                                }
                                catch (Throwable t) {
                                    TensorFlowImportValidator.log.warn("Unable to read from file, skipping: {}", (Object)f.getAbsolutePath(), (Object)t);
                                    is.close();
                                    continue block38;
                                }
                            }
                            catch (Throwable var12_17) {
                                try {
                                    is.close();
                                }
                                catch (Throwable var13_20) {
                                    var12_17.addSuppressed(var13_20);
                                }
                                throw var12_17;
                            }
                            is.close();
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Archive type not yet implemented: " + f.getAbsolutePath());
                        }
                    }
                    break block53;
                }
                TensorFlowImportValidator.log.info("Checking model file: " + f.getAbsolutePath());
                currStatus = TensorFlowImportValidator.checkModelForImport(f);
                status = status == null ? currStatus : status.merge(currStatus);
            }
            System.out.println("DONE FILE: " + f.getAbsolutePath() + " - totalOps = " + (status == null ? 0 : status.getOpNames().size()) + " - supported ops: " + (status == null ? 0 : status.getImportSupportedOpNames().size()) + " - unsupported ops: " + (status == null ? 0 : status.getUnsupportedOpNames().size()));
        }
        return status;
    }

    public static boolean isArchiveFile(File f) {
        return !f.getPath().endsWith(".pb");
    }

    public static TFImportStatus checkModelForImport(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return TensorFlowImportValidator.checkModelForImport(file, false);
    }

    public static TFImportStatus checkModelForImport(@NonNull File file, boolean exceptionOnRead) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileInputStream is = new FileInputStream(file);){
            TFImportStatus tFImportStatus = TensorFlowImportValidator.checkModelForImport(file.getAbsolutePath(), is, exceptionOnRead);
            return tFImportStatus;
        }
    }

    public static TFImportStatus checkModelForImport(String path, InputStream is, boolean exceptionOnRead) throws IOException {
        try {
            int opCount = 0;
            HashSet<String> opNames = new HashSet<String>();
            HashMap<String, Integer> opCounts = new HashMap<String, Integer>();
            try (BufferedInputStream bis = new BufferedInputStream(is);){
                GraphDef graphDef = GraphDef.parseFrom(bis);
                ArrayList<NodeDef> nodes = new ArrayList<NodeDef>(graphDef.getNodeCount());
                for (int i = 0; i < graphDef.getNodeCount(); ++i) {
                    nodes.add(graphDef.getNode(i));
                }
                if (nodes.isEmpty()) {
                    throw new IllegalStateException("Error loading model for import - loaded graph def has no nodes (empty/corrupt file?): " + path);
                }
                for (NodeDef nd : nodes) {
                    if (TFGraphMapper.isVariableNode(nd) || TFGraphMapper.isPlaceHolder(nd)) continue;
                    String op = nd.getOp();
                    opNames.add(op);
                    int soFar = opCounts.containsKey(op) ? (Integer)opCounts.get(op) : 0;
                    opCounts.put(op, soFar + 1);
                    ++opCount;
                }
            }
            HashSet<String> importSupportedOpNames = new HashSet<String>();
            HashSet<String> unsupportedOpNames = new HashSet<String>();
            HashMap<String, Set<String>> unsupportedOpModel = new HashMap<String, Set<String>>();
            for (String s : opNames) {
                if (DifferentialFunctionClassHolder.getInstance().getOpWithTensorflowName(s) != null) {
                    importSupportedOpNames.add(s);
                    continue;
                }
                unsupportedOpNames.add(s);
                if (unsupportedOpModel.containsKey(s)) continue;
                HashSet<String> l = new HashSet<String>();
                l.add(path);
                unsupportedOpModel.put(s, l);
            }
            return new TFImportStatus(Collections.singletonList(path), unsupportedOpNames.size() > 0 ? Collections.singletonList(path) : Collections.emptyList(), Collections.emptyList(), opCount, opNames.size(), opNames, opCounts, importSupportedOpNames, unsupportedOpNames, unsupportedOpModel);
        }
        catch (Throwable t) {
            if (exceptionOnRead) {
                throw new IOException("Error reading model from path " + path + " - not a TensorFlow frozen model in ProtoBuf format?", t);
            }
            log.warn("Failed to import model from: " + path + " - not a TensorFlow frozen model in ProtoBuf format?", t);
            return new TFImportStatus(Collections.emptyList(), Collections.emptyList(), Collections.singletonList(path), 0, 0, Collections.emptySet(), Collections.emptyMap(), Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
        }
    }
}

