/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;

public abstract class BaseLoss
extends DynamicCustomOp {
    protected LossReduce lossReduce;

    public BaseLoss(@NonNull SameDiff sameDiff, @NonNull LossReduce lossReduce, @NonNull SDVariable predictions, SDVariable weights, @NonNull SDVariable labels) {
        super(null, sameDiff, new SDVariable[]{predictions, BaseLoss.getWeights(sameDiff, weights, predictions), labels});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (lossReduce == null) {
            throw new NullPointerException("lossReduce is marked non-null but is null");
        }
        if (predictions == null) {
            throw new NullPointerException("predictions is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        this.lossReduce = lossReduce;
        this.addArgs();
    }

    public BaseLoss(@NonNull LossReduce lossReduce, @NonNull INDArray predictions, INDArray weights, @NonNull INDArray labels) {
        super(new INDArray[]{predictions, BaseLoss.getWeights(weights, predictions), labels}, null);
        if (lossReduce == null) {
            throw new NullPointerException("lossReduce is marked non-null but is null");
        }
        if (predictions == null) {
            throw new NullPointerException("predictions is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        this.lossReduce = lossReduce;
        this.addArgs();
    }

    protected static INDArray getWeights(INDArray weights, INDArray predictions) {
        return weights != null ? weights : Nd4j.scalar(predictions.dataType(), 1.0);
    }

    protected static SDVariable getWeights(SameDiff sd, SDVariable weights, SDVariable predictions) {
        return weights != null ? weights : sd.constant(Nd4j.scalar(predictions.dataType(), 1.0));
    }

    protected BaseLoss() {
    }

    protected void addArgs() {
        this.iArguments.clear();
        this.tArguments.clear();
        this.addIArgument(this.lossReduce.ordinal());
    }

    @Override
    public abstract String opName();

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() >= 2 ? 1 : 0) != 0, (String)"Expected exactly 2 or more input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public LossReduce getLossReduce() {
        return this.lossReduce;
    }

    public void setLossReduce(LossReduce lossReduce) {
        this.lossReduce = lossReduce;
    }
}

