/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;
import org.nd4j.linalg.api.ops.impl.loss.bp.LogPoissonLossBp;

public class LogPoissonLoss
extends BaseLoss {
    private boolean full;

    public LogPoissonLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable predictions, SDVariable weights, SDVariable labels) {
        this(sameDiff, lossReduce, predictions, weights, labels, false);
    }

    public LogPoissonLoss(SameDiff sameDiff, SDVariable labels, SDVariable predictions, SDVariable weights, LossReduce lossReduce, boolean full) {
        this(sameDiff, lossReduce, predictions, weights, labels, full);
    }

    public LogPoissonLoss(SameDiff sameDiff, LossReduce lossReduce, SDVariable predictions, SDVariable weights, SDVariable labels, boolean full) {
        super(sameDiff, lossReduce, predictions, weights, labels);
        this.full = full;
        this.addArgs();
    }

    public LogPoissonLoss(INDArray labels, INDArray predictions, INDArray weights, LossReduce lossReduce, boolean full) {
        super(lossReduce, predictions, weights, labels);
        this.full = full;
        this.addArgs();
    }

    public LogPoissonLoss() {
    }

    @Override
    protected void addArgs() {
        super.addArgs();
        if (this.full) {
            this.iArguments.add(1L);
        }
    }

    @Override
    public void configureFromArguments() {
        if (!this.iArguments.isEmpty()) {
            this.lossReduce = LossReduce.values()[((Long)this.iArguments.get(0)).intValue()];
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("full", this.full);
        ret.put("reductionMode", this.lossReduce.ordinal());
        return ret;
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("reductionMode")) {
            Integer reductionMode = this.getIntValueFromProperty("reductionMode", properties);
            this.lossReduce = LossReduce.values()[reductionMode];
        }
        if (properties.containsKey("full")) {
            Boolean full = this.getBooleanFromProperty("full", properties);
            this.full = full;
        }
    }

    @Override
    public String opName() {
        return "log_poisson_loss";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return new LogPoissonLossBp(this.sameDiff, this.lossReduce, this.arg(0), this.arg(1), this.arg(2), this.full).outputs();
    }
}

