/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.loss;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.loss.LossReduce;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.loss.BaseLoss;

public class WeightedCrossEntropyLoss
extends BaseLoss {
    public WeightedCrossEntropyLoss(@NonNull SameDiff sameDiff, @NonNull LossReduce lossReduce, @NonNull SDVariable predictions, SDVariable weights, @NonNull SDVariable labels) {
        super(sameDiff, lossReduce, predictions, weights, labels);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (lossReduce == null) {
            throw new NullPointerException("lossReduce is marked non-null but is null");
        }
        if (predictions == null) {
            throw new NullPointerException("predictions is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
    }

    public WeightedCrossEntropyLoss(@NonNull LossReduce lossReduce, @NonNull INDArray predictions, INDArray weights, @NonNull INDArray labels) {
        super(lossReduce, predictions, weights, labels);
        if (lossReduce == null) {
            throw new NullPointerException("lossReduce is marked non-null but is null");
        }
        if (predictions == null) {
            throw new NullPointerException("predictions is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
    }

    public WeightedCrossEntropyLoss() {
    }

    public WeightedCrossEntropyLoss(SameDiff sd, SDVariable targets, SDVariable inputs, SDVariable weights) {
        this(sd, LossReduce.SUM, inputs, weights, targets);
    }

    public WeightedCrossEntropyLoss(INDArray targets, INDArray inputs, INDArray weights) {
        this(LossReduce.SUM, inputs, targets, weights);
    }

    @Override
    public String opName() {
        return "weighted_cross_entropy_with_logits";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No TensorFlow op opName found for " + this.opName());
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 3 ? 1 : 0) != 0, (String)"Expected exactly 3 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }
}

