/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scalar;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseScalarOp;

public class LogX
extends BaseScalarOp {
    private double base;

    public LogX(SameDiff sameDiff, SDVariable i_v, double base) {
        super(sameDiff, i_v, (Number)base);
        this.base = base;
        this.extraArgs = new Object[]{base};
    }

    public LogX() {
    }

    public LogX(INDArray x, INDArray z, double base) {
        super(x, null, z, base);
        this.base = base;
        this.extraArgs = new Object[]{base};
    }

    public LogX(INDArray x, double base) {
        super(x, base);
        this.base = base;
        this.extraArgs = new Object[]{base};
    }

    @Override
    public int opNum() {
        return 38;
    }

    @Override
    public String opName() {
        return "log_x";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        double logb = Math.log(this.base);
        return Collections.singletonList(f1.get(0).div(this.arg().mul(logb)));
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No TensorFlow op found for " + this.getClass().getSimpleName());
    }
}

