/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DistributionUniform
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(DistributionUniform.class);
    private double min = 0.0;
    private double max = 1.0;
    private DataType dataType;

    public DistributionUniform() {
    }

    public DistributionUniform(SameDiff sd, SDVariable shape, double min, double max) {
        this(sd, shape, min, max, null);
    }

    public DistributionUniform(SameDiff sd, SDVariable shape, double min, double max, DataType dataType) {
        super(null, sd, new SDVariable[]{shape});
        Preconditions.checkState((min <= max ? 1 : 0) != 0, (String)"Minimum (%s) must be <= max (%s)", (double)min, (double)max);
        Preconditions.checkState((dataType == null || dataType.isNumerical() ? 1 : 0) != 0, (String)"Only numerical datatypes can be used with DistributionUniform - rquested output datatype: %s", (Object)((Object)dataType));
        this.dataType = dataType;
        this.min = min;
        this.max = max;
        this.addArgs();
    }

    public DistributionUniform(INDArray shape, INDArray out, double min, double max) {
        this(shape, out, min, max, null);
    }

    public DistributionUniform(INDArray shape, INDArray out, double min, double max, DataType dataType) {
        super(null, new INDArray[]{shape}, new INDArray[]{out}, Arrays.asList(min, max), (List<Integer>)null);
        this.min = min;
        this.max = max;
        this.dataType = dataType;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        AttrValue vDtype = attributesForNode.get("dtype");
        AttrValue vTout = attributesForNode.get("Tout");
        if (vDtype == null && vTout == null) {
            throw new ND4JIllegalStateException("Unable to find output data type for node " + nodeDef.getName());
        }
        AttrValue v = vDtype == null ? vTout : vDtype;
        this.dataType = TFGraphMapper.convertType(v.getType());
        this.addIArgument(this.dataType.toInt());
        this.addTArgument(0.0, 1.0);
    }

    protected void addArgs() {
        this.tArguments.clear();
        this.addTArgument(this.min, this.max);
        if (this.dataType != null) {
            this.iArguments.clear();
            this.addIArgument(this.dataType.toInt());
        }
    }

    @Override
    public String opName() {
        return "randomuniform";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"RandomUniform", "RandomUniformInt"};
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null ? 1 : 0) != 0, (String)"Expected input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        if (this.dataType != null) {
            return Collections.singletonList(this.dataType);
        }
        return Collections.singletonList(DataType.FLOAT);
    }
}

