/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Range
extends DynamicCustomOp {
    public static final DataType DEFAULT_DTYPE = DataType.FLOAT;
    private Double from;
    private Double to;
    private Double delta;
    private DataType dataType;

    public Range() {
    }

    public Range(SameDiff sd, double from, double to, double step, DataType dataType) {
        super(null, sd, new SDVariable[0]);
        this.addTArgument(from, to, step);
        this.addDArgument(dataType);
        this.from = from;
        this.to = to;
        this.delta = step;
        this.dataType = dataType;
    }

    public Range(double from, double to, double step, DataType dataType) {
        this.addTArgument(from, to, step);
        this.from = from;
        this.to = to;
        this.delta = step;
        this.dataType = dataType;
        this.addDArgument(dataType);
    }

    public Range(SameDiff sd, SDVariable from, SDVariable to, SDVariable step, DataType dataType) {
        super(null, sd, new SDVariable[]{from, to, step});
        this.dataType = dataType;
        this.addDArgument(dataType);
    }

    public Range(INDArray from, INDArray to, INDArray step, DataType dataType) {
        super(new INDArray[]{from, to, step}, null);
        this.dataType = dataType;
        this.addDArgument(dataType);
    }

    @Override
    public int opNum() {
        return 4;
    }

    @Override
    public String opName() {
        return "range";
    }

    @Override
    public String onnxName() {
        return "Range";
    }

    @Override
    public String tensorflowName() {
        return "Range";
    }

    @Override
    public void configureFromArguments() {
        if (!this.iArguments.isEmpty()) {
            this.from = ((Long)this.iArguments.get(0)).doubleValue();
            this.to = ((Long)this.iArguments.get(1)).doubleValue();
            this.delta = ((Long)this.iArguments.get(2)).doubleValue();
        }
        if (!this.tArguments.isEmpty()) {
            this.from = (double)((Double)this.tArguments.get(0));
            this.to = (double)((Double)this.tArguments.get(1));
            this.delta = (double)((Double)this.tArguments.get(2));
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        super.setPropertiesForFunction(properties);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        super.initFromTensorFlow(nodeDef, initWith, attributesForNode, graph);
        if (attributesForNode.containsKey("Tidx")) {
            this.dataType = TFGraphMapper.convertType(attributesForNode.get("Tidx").getType());
        }
        this.addDArgument(this.dataType);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.emptyList();
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes == null || inputDataTypes.isEmpty() || inputDataTypes.size() == 3 ? 1 : 0) != 0, (String)"Expected no input datatypes (no args) or 3 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(this.dataType == null ? DEFAULT_DTYPE : this.dataType);
    }
}

