/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning;

import java.util.Collections;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.GradientUpdater;
import org.nd4j.linalg.learning.config.Nesterovs;

public class NesterovsUpdater
implements GradientUpdater<Nesterovs> {
    public static final String V_STATE = "V";
    private final Nesterovs config;
    private INDArray v;
    private char gradientReshapeOrder;

    public NesterovsUpdater(Nesterovs config) {
        this.config = config;
    }

    @Override
    public void setState(@NonNull Map<String, INDArray> stateMap, boolean initialize) {
        if (stateMap == null) {
            throw new NullPointerException("stateMap is marked non-null but is null");
        }
        if (!stateMap.containsKey(V_STATE) || stateMap.size() != 1) {
            throw new IllegalStateException("State map should contain only key [V] but has keys " + stateMap.keySet());
        }
        this.v = stateMap.get(V_STATE);
    }

    @Override
    public Map<String, INDArray> getState() {
        return Collections.singletonMap(V_STATE, this.v);
    }

    @Override
    public void setStateViewArray(INDArray viewArray, long[] gradientShape, char gradientOrder, boolean initialize) {
        if (!viewArray.isRowVectorOrScalar()) {
            throw new IllegalArgumentException("Invalid input: expect row vector input");
        }
        if (initialize) {
            viewArray.assign(0);
        }
        this.v = viewArray;
        this.v = Shape.newShapeNoCopy(this.v, gradientShape, gradientOrder == 'f');
        if (this.v == null) {
            throw new IllegalStateException("Could not correctly reshape gradient view array");
        }
        this.gradientReshapeOrder = gradientOrder;
    }

    @Override
    public void applyUpdater(INDArray gradient, int iteration, int epoch) {
        if (this.v == null) {
            throw new IllegalStateException("Updater has not been initialized with view state");
        }
        double momentum = this.config.currentMomentum(iteration, epoch);
        double learningRate = this.config.getLearningRate(iteration, epoch);
        Nd4j.exec(new org.nd4j.linalg.api.ops.impl.updaters.NesterovsUpdater(gradient.reshape(this.v.shape()), this.v, learningRate, momentum));
    }

    @Override
    public Nesterovs getConfig() {
        return this.config;
    }

    public INDArray getV() {
        return this.v;
    }

    public char getGradientReshapeOrder() {
        return this.gradientReshapeOrder;
    }

    public void setV(INDArray v) {
        this.v = v;
    }

    public void setGradientReshapeOrder(char gradientReshapeOrder) {
        this.gradientReshapeOrder = gradientReshapeOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NesterovsUpdater)) {
            return false;
        }
        NesterovsUpdater other = (NesterovsUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getGradientReshapeOrder() != other.getGradientReshapeOrder()) {
            return false;
        }
        Nesterovs this$config = this.getConfig();
        Nesterovs other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        INDArray this$v = this.getV();
        INDArray other$v = other.getV();
        return !(this$v == null ? other$v != null : !this$v.equals(other$v));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NesterovsUpdater;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGradientReshapeOrder();
        Nesterovs $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        INDArray $v = this.getV();
        result = result * 59 + ($v == null ? 43 : $v.hashCode());
        return result;
    }

    public String toString() {
        return "NesterovsUpdater(config=" + this.getConfig() + ", v=" + this.getV() + ", gradientReshapeOrder=" + this.getGradientReshapeOrder() + ")";
    }
}

