/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions.impl;

import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.same.Abs;
import org.nd4j.linalg.api.ops.impl.transforms.same.Sign;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossUtil;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.serde.jackson.shaded.NDArrayTextDeSerializer;
import org.nd4j.serde.jackson.shaded.NDArrayTextSerializer;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.databind.annotation.JsonDeserialize;
import org.nd4j.shade.jackson.databind.annotation.JsonSerialize;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LossMAPE
implements ILossFunction {
    @JsonSerialize(using=NDArrayTextSerializer.class)
    @JsonDeserialize(using=NDArrayTextDeSerializer.class)
    private final INDArray weights;

    public LossMAPE() {
        this(null);
    }

    public LossMAPE(INDArray weights) {
        if (weights != null && !weights.isRowVectorOrScalar()) {
            throw new IllegalArgumentException("Weights array must be a row vector");
        }
        this.weights = weights;
    }

    public INDArray scoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        if (!labels.equalShapes(preOutput)) {
            Preconditions.throwEx((String)"Labels and preOutput must have equal shapes: got shapes %s vs %s", (Object[])new Object[]{labels.shape(), preOutput.shape()});
        }
        labels = labels.castTo(preOutput.dataType());
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        INDArray scoreArr = output.rsubi(labels).divi(labels);
        Transforms.abs(scoreArr, false);
        scoreArr.muli(100.0 / (double)labels.size(1));
        if (this.weights != null) {
            if (this.weights.length() != output.size(1)) {
                throw new IllegalStateException("Weights vector (length " + this.weights.length() + ") does not match output.size(1)=" + output.size(1));
            }
            scoreArr.muliRowVector(this.weights.castTo(scoreArr.dataType()));
        }
        if (mask != null) {
            LossUtil.applyMask(scoreArr, mask);
        }
        return scoreArr;
    }

    @Override
    public double computeScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        double score = scoreArr.sumNumber().doubleValue();
        if (average) {
            score /= (double)scoreArr.size(0);
        }
        return score;
    }

    @Override
    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr = this.scoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(true, 1);
    }

    @Override
    public INDArray computeGradient(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        if (!labels.equalShapes(preOutput)) {
            Preconditions.throwEx((String)"Labels and preOutput must have equal shapes: got shapes %s vs %s", (Object[])new Object[]{labels.shape(), preOutput.shape()});
        }
        labels = labels.castTo(preOutput.dataType());
        INDArray output = activationFn.getActivation(preOutput.dup(), true);
        INDArray actSubPredicted = labels.sub(output);
        INDArray dLda = Nd4j.getExecutioner().exec(new Sign(actSubPredicted));
        INDArray absLabels = Nd4j.getExecutioner().exec(new Abs(labels.dup()));
        dLda.divi(absLabels).muli(-100.0 / (double)labels.size(1));
        if (this.weights != null) {
            dLda.muliRowVector(this.weights.castTo(dLda.dataType()));
        }
        if (mask != null && LossUtil.isPerOutputMasking(dLda, mask)) {
            LossUtil.applyMask(dLda, mask);
        }
        INDArray gradient = (INDArray)activationFn.backprop(preOutput, dLda).getFirst();
        if (mask != null) {
            LossUtil.applyMask(gradient, mask);
        }
        return gradient;
    }

    @Override
    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        return new Pair((Object)this.computeScore(labels, preOutput, activationFn, mask, average), (Object)this.computeGradient(labels, preOutput, activationFn, mask));
    }

    @Override
    public String name() {
        return this.toString();
    }

    public String toString() {
        if (this.weights == null) {
            return "LossMAPE()";
        }
        return "LossMAPE(weights=" + this.weights + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LossMAPE)) {
            return false;
        }
        LossMAPE other = (LossMAPE)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$weights = this.getWeights();
        INDArray other$weights = other.getWeights();
        return !(this$weights == null ? other$weights != null : !this$weights.equals(other$weights));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LossMAPE;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : $weights.hashCode());
        return result;
    }

    public INDArray getWeights() {
        return this.weights;
    }
}

