/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.Ints;
import com.google.flatbuffers.FlatBufferBuilder;
import com.rits.cloning.Cloner;
import com.rits.cloning.IFastCloner;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.autodiff.execution.conf.ExecutionMode;
import org.nd4j.autodiff.execution.conf.ExecutorConfiguration;
import org.nd4j.autodiff.execution.conf.OutputMode;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.functions.DifferentialFunctionFactory;
import org.nd4j.autodiff.functions.FunctionProperties;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiffConditional;
import org.nd4j.autodiff.samediff.SameDiffFunctionDefinition;
import org.nd4j.autodiff.samediff.flow.FlowPath;
import org.nd4j.autodiff.util.cloner.DataBufferFastCloner;
import org.nd4j.autodiff.util.cloner.INDArrayFastCloner;
import org.nd4j.base.Preconditions;
import org.nd4j.graph.FlatGraph;
import org.nd4j.graph.FlatNode;
import org.nd4j.graph.FlatVariable;
import org.nd4j.graph.IntPair;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.AllocationPolicy;
import org.nd4j.linalg.api.memory.enums.LearningPolicy;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.GradientOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.controlflow.If;
import org.nd4j.linalg.api.ops.impl.controlflow.While;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Enter;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Exit;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.LoopCond;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.NextIteration;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Switch;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.GRUCell;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.LSTMCell;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.SRU;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.SRUCell;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.GRUCellConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMCellConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.SRUCellConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.SRUConfiguration;
import org.nd4j.linalg.api.ops.impl.shape.Eye;
import org.nd4j.linalg.api.ops.impl.shape.tensorops.BaseTensorOp;
import org.nd4j.linalg.api.ops.impl.shape.tensorops.TensorArrayV3;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.GradientBackwardsMarker;
import org.nd4j.linalg.api.ops.impl.transforms.temp.ExternalErrorsFunction;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.collection.IntArrayKeyMap;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.exception.ND4UnresolvedOutputVariables;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT;
import org.nd4j.linalg.lossfunctions.impl.LossCosineProximity;
import org.nd4j.linalg.lossfunctions.impl.LossHinge;
import org.nd4j.linalg.lossfunctions.impl.LossKLD;
import org.nd4j.linalg.lossfunctions.impl.LossL1;
import org.nd4j.linalg.lossfunctions.impl.LossL2;
import org.nd4j.linalg.lossfunctions.impl.LossMAE;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMSE;
import org.nd4j.linalg.lossfunctions.impl.LossMSLE;
import org.nd4j.linalg.lossfunctions.impl.LossNegativeLogLikelihood;
import org.nd4j.linalg.lossfunctions.impl.LossPoisson;
import org.nd4j.linalg.lossfunctions.impl.LossSquaredHinge;
import org.nd4j.linalg.primitives.AtomicBoolean;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.list.compat.TensorList;
import org.nd4j.weightinit.WeightInitScheme;
import org.nd4j.weightinit.impl.ConstantInitScheme;
import org.nd4j.weightinit.impl.NDArraySupplierInitScheme;
import org.nd4j.weightinit.impl.ZeroInitScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameDiff {
    private static final Logger log;
    private Map<String, String[]> incomingArgsReverse;
    private Map<String, String[]> outgoingArgsReverse;
    private Map<String, int[]> permuteOrder;
    private boolean shouldBootStrap = true;
    private Set<String> importedVarName;
    private Map<String, String> baseNameForFunctionInstanceId;
    private DifferentialFunctionFactory functionFactory;
    private Map<String, SDVariable> variableMap;
    private Map<String, long[]> variableNameToShape;
    private Map<String, SDVariable> gradients;
    private Map<String, SDVariable> forwardVarForGrad;
    private Map<String, INDArray> variableNameToArr;
    private Map<String, List<DifferentialFunction>> functionsArgsFor;
    private Map<String, List<DifferentialFunction>> functionOutputFor;
    private Map<String, TensorList> lists = new HashMap<String, TensorList>();
    private transient ThreadLocal<FlowPath> localFlowPath = new ThreadLocal();
    private transient Map<String, Integer> reverseMap = null;
    private int variableId = 0;
    private Map<String, List<String>> propertiesToResolve;
    private Map<String, Map<String, Object>> propertiesForFunction;
    private Map<String, List<String[]>> placeHolderMap;
    private Map<String, long[]> placeHolderOriginalShapes;
    private Set<String> placeHolderVarNames;
    private MemoryWorkspace workspace;
    private Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap;
    private Map<String, SameDiff> sameDiffFunctionInstances;
    private Set<String> placeHolderFunctions;
    private static Cloner cloner;
    private static Map<String, Method> opMethods;
    private Map<String, DifferentialFunction> functionInstancesById;
    private Table<String, String, String> fieldVariableResolutionMapping;
    private transient AtomicBoolean wasRegistered = new AtomicBoolean(false);
    private boolean debugMode;
    private Map<int[], Op> opsForResult;
    private boolean resolvedVariables = false;
    boolean logExecution = true;
    private SameDiff parent;
    private SameDiff child;
    private SDVariable[] outputs;
    private SDVariable[] inputs;
    private Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec_cache;

    public static Cloner newCloner() {
        Cloner cloner = new Cloner();
        INDArrayFastCloner fc = new INDArrayFastCloner();
        cloner.registerFastCloner(Nd4j.getBackend().getNDArrayClass(), (IFastCloner)fc);
        DataBufferFastCloner fc2 = new DataBufferFastCloner();
        DataBufferFactory d = Nd4j.getDataBufferFactory();
        SameDiff.doReg(cloner, fc2, d.intBufferClass());
        SameDiff.doReg(cloner, fc2, d.longBufferClass());
        SameDiff.doReg(cloner, fc2, d.halfBufferClass());
        SameDiff.doReg(cloner, fc2, d.floatBufferClass());
        SameDiff.doReg(cloner, fc2, d.doubleBufferClass());
        SameDiff.doReg(cloner, fc2, CompressedDataBuffer.class);
        return cloner;
    }

    private static void doReg(Cloner cl, IFastCloner fc, Class<?> c) {
        if (c != null) {
            cl.registerFastCloner(c, fc);
        }
    }

    public void updateVariableName(String varName, String withName) {
        BaseOp baseOp;
        List<DifferentialFunction> funcs;
        int i;
        SDVariable oldVarNameRef = this.getVariable(varName);
        this.variableMap.remove(oldVarNameRef.getVarName());
        String oldVarName = varName;
        oldVarNameRef.setVarName(withName);
        this.variableMap.put(withName, oldVarNameRef);
        for (Map.Entry<String, String[]> reverseValues : this.outgoingArgsReverse.entrySet()) {
            for (i = 0; i < reverseValues.getValue().length; ++i) {
                if (!reverseValues.getValue()[i].equals(oldVarName)) continue;
                reverseValues.getValue()[i] = withName;
            }
        }
        for (Map.Entry<String, String[]> reverseValues : this.incomingArgsReverse.entrySet()) {
            for (i = 0; i < reverseValues.getValue().length; ++i) {
                if (!reverseValues.getValue()[i].equals(oldVarName)) continue;
                reverseValues.getValue()[i] = withName;
            }
        }
        if (this.variableNameToArr.containsKey(oldVarName)) {
            INDArray arr = this.variableNameToArr.remove(oldVarName);
            this.variableNameToArr.put(withName, arr);
        }
        if (this.variableNameToShape.containsKey(oldVarName)) {
            long[] shape = this.variableNameToShape.remove(oldVarName);
            this.variableNameToShape.put(withName, shape);
        }
        if (this.gradients.containsKey(oldVarName)) {
            SDVariable grad = this.gradients.remove(oldVarName);
            this.gradients.put(withName, grad);
        }
        if (this.forwardVarForGrad.containsKey(oldVarName)) {
            SDVariable forwardGrad = this.forwardVarForGrad.remove(oldVarName);
            this.forwardVarForGrad.put(withName, forwardGrad);
        }
        if (this.placeHolderMap.containsKey(oldVarName)) {
            List<String[]> placeholders = this.placeHolderMap.remove(oldVarName);
            this.placeHolderMap.put(withName, placeholders);
        }
        if (this.functionsArgsFor.containsKey(oldVarName)) {
            funcs = this.functionsArgsFor.remove(oldVarName);
            for (DifferentialFunction func : funcs) {
                if (!(func instanceof BaseOp)) continue;
                baseOp = (BaseOp)func;
                if (baseOp.getXVertexId() != null && baseOp.getXVertexId().equals(oldVarName)) {
                    baseOp.setXVertexId(withName);
                }
                if (baseOp.getYVertexId() != null && baseOp.getYVertexId().equals(oldVarName)) {
                    baseOp.setYVertexId(withName);
                }
                if (baseOp.getZVertexId() == null || !baseOp.getZVertexId().equals(oldVarName)) continue;
                baseOp.setZVertexId(withName);
            }
            this.functionsArgsFor.put(withName, funcs);
        }
        if (this.functionOutputFor.containsKey(oldVarName)) {
            funcs = this.functionOutputFor.remove(oldVarName);
            for (DifferentialFunction func : funcs) {
                if (!(func instanceof BaseOp)) continue;
                baseOp = (BaseOp)func;
                if (baseOp.getXVertexId() != null && baseOp.getXVertexId().equals(oldVarName)) {
                    baseOp.setXVertexId(withName);
                }
                if (baseOp.getYVertexId() != null && baseOp.getYVertexId().equals(oldVarName)) {
                    baseOp.setYVertexId(withName);
                }
                if (baseOp.getZVertexId() == null || !baseOp.getZVertexId().equals(oldVarName)) continue;
                baseOp.setZVertexId(withName);
            }
            this.functionOutputFor.put(withName, funcs);
        }
        this.variableMap.remove(oldVarName);
    }

    public SameDiff disableDebugging() {
        this.debugMode = false;
        return this;
    }

    public SameDiff enableDebugMode() {
        this.debugMode = true;
        return this;
    }

    public DifferentialFunctionFactory f() {
        return this.functionFactory;
    }

    public SDVariable invokeGraphOn(SameDiff sameDiff) {
        HashMap<Integer, Integer> thisVertexIdToNew = new HashMap<Integer, Integer>();
        int idx = 1;
        for (SDVariable var : this.variables()) {
            SDVariable clone = (SDVariable)cloner.deepCloneDontCloneInstances((Object)var, new Object[]{var.getSameDiff()});
            SDVariable newVar = sameDiff.var(clone);
            if (var.getArr() != null) {
                sameDiff.associateArrayWithVariable(var.getArr(), newVar);
            }
            thisVertexIdToNew.put(idx, idx);
            clone.setSameDiff(sameDiff);
            ++idx;
        }
        LinkedHashMap<String, DifferentialFunction> newFunctions = new LinkedHashMap<String, DifferentialFunction>();
        for (DifferentialFunction function : this.functionInstancesById.values()) {
            if (function instanceof SDVariable) continue;
            DifferentialFunction clone = (DifferentialFunction)cloner.deepCloneDontCloneInstances((Object)function, new Object[]{function.getSameDiff()});
            clone.setSameDiff(sameDiff);
            clone.setOwnName(function.getOwnName());
            if (sameDiff.functionExists(function.getOwnName())) {
                sameDiff.putFunctionForId(function.getOwnName(), function);
            }
            newFunctions.put(function.getOwnName(), clone);
            SDVariable[] argsForFunction = function.args();
            SDVariable[] outputsForFunction = function.outputVariables();
            sameDiff.addArgsFor(argsForFunction, clone);
            sameDiff.addOutgoingFor(outputsForFunction, function);
            for (SDVariable arg : clone.args()) {
                arg.setSameDiff(sameDiff);
            }
            for (SDVariable output : clone.outputVariables()) {
                output.setSameDiff(sameDiff);
            }
            sameDiff.functionInstancesById.put(function.getOwnName(), function);
        }
        return sameDiff.variables().get(sameDiff.variables().size() - 1);
    }

    public boolean functionExists(String id) {
        return this.functionInstancesById.containsKey(id);
    }

    public DifferentialFunction getFunctionById(String id) {
        if (!this.functionInstancesById.containsKey(id)) {
            throw new ND4JIllegalStateException("No function with id " + id + " found!");
        }
        return this.functionInstancesById.get(id);
    }

    public void putFunctionForId(String id, DifferentialFunction function) {
        if (this.functionInstancesById.containsKey(id)) {
            throw new ND4JIllegalStateException("Function by id already exists!");
        }
        if (function instanceof SDVariable) {
            throw new ND4JIllegalStateException("Function must not be a variable!");
        }
        this.functionInstancesById.put(id, function);
    }

    public String[] getInputsForFunction(DifferentialFunction function) {
        if (!this.incomingArgsReverse.containsKey(function.getOwnName())) {
            throw new ND4JIllegalStateException("Illegal function instance id found " + function.getOwnName());
        }
        return this.incomingArgsReverse.get(function.getOwnName());
    }

    public String[] getOutputsForFunction(DifferentialFunction function) {
        return this.outgoingArgsReverse.get(function.getOwnName());
    }

    public SDVariable[] getOutputVariablesForFunction(DifferentialFunction function) {
        String[] inputs = this.getOutputsForFunction(function);
        if (inputs == null) {
            throw new ND4JIllegalStateException("No inputs found for function " + function);
        }
        SDVariable[] vars = new SDVariable[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            vars[i] = this.getVariable(inputs[i]);
        }
        return vars;
    }

    public SDVariable[] getInputVariablesForFunction(DifferentialFunction function) {
        String[] inputs = this.getInputsForFunction(function);
        if (inputs == null) {
            throw new ND4JIllegalStateException("No inputs found for function " + function);
        }
        SDVariable[] vars = new SDVariable[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            vars[i] = this.getVariable(inputs[i]);
            if (vars[i] != null) continue;
            throw new ND4JIllegalStateException("Found null variable at index " + i);
        }
        return vars;
    }

    public void updateArrayForVarName(String varName, INDArray arr) {
        if (!this.variableNameToArr.containsKey(varName)) {
            throw new ND4JIllegalStateException("Array for " + varName + " does not exist. Please use putArrayForVertexId instead.");
        }
        this.variableNameToArr.put(varName, arr);
    }

    public void putArrayForVarName(String varName, INDArray arr) {
        if (varName == null) {
            throw new ND4JIllegalStateException("No null names allowed!");
        }
        if (this.variableNameToArr.containsKey(varName)) {
            throw new ND4JIllegalStateException("Array for " + varName + " already exists!");
        }
        this.variableNameToArr.put(varName, arr);
    }

    public void putOrUpdateArrayForVarName(@NonNull String varName, INDArray arr) {
        if (varName == null) {
            throw new NullPointerException("varName is marked @NonNull but is null");
        }
        if (this.variableNameToArr.containsKey(varName)) {
            this.updateArrayForVarName(varName, arr);
        } else {
            this.putArrayForVarName(varName, arr);
        }
    }

    public long[] getShapeForVarName(String varName) {
        if (this.variableNameToArr.containsKey(varName)) {
            return this.variableNameToArr.get(varName).shape();
        }
        return this.variableNameToShape.get(varName);
    }

    public void updateShapeForVarName(String varName, long[] shape) {
        this.updateShapeForVarName(varName, shape, false);
    }

    public void updateShapeForVarName(String varName, long[] shape, boolean clearArrayOnShapeMismatch) {
        if (shape == null) {
            throw new ND4JIllegalStateException("Null shapes not allowed!");
        }
        if (this.variableNameToArr.containsKey(varName) && !Arrays.equals(this.variableNameToArr.get(varName).shape(), shape)) {
            if (clearArrayOnShapeMismatch) {
                if (log.isTraceEnabled()) {
                    log.trace("Clearing array for variable {}: array shape {}, new shape {}", new Object[]{varName, Arrays.toString(this.variableNameToArr.get(varName).shape()), Arrays.toString(shape)});
                }
                this.variableNameToArr.remove(varName);
            } else {
                throw new ND4JIllegalStateException("Already found an existing array for variable \"" + varName + "\" with shape " + Arrays.toString(this.variableNameToArr.get(varName).shape()) + " - attempting to put new array shape " + Arrays.toString(shape));
            }
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 1L) continue;
            this.addAsPlaceHolder(varName);
            this.placeHolderOriginalShapes.put(varName, shape);
            return;
        }
        if (log.isTraceEnabled()) {
            long[] pShape = this.variableNameToShape.get(varName);
            log.trace("Updated shape for variable \"{}\": previous shape {}, new shape {}", new Object[]{varName, pShape == null ? "<not set>" : Arrays.toString(pShape), Arrays.toString(shape)});
        }
        this.variableNameToShape.put(varName, shape);
    }

    public void putShapeForVarName(String varName, long[] shape) {
        if (shape == null) {
            throw new ND4JIllegalStateException("Shape must not be null!");
        }
        if (this.variableNameToShape.containsKey(varName)) {
            throw new ND4JIllegalStateException("Shape for " + varName + " already exists!");
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 1L) continue;
            this.addAsPlaceHolder(varName);
            this.placeHolderOriginalShapes.put(varName, shape);
            return;
        }
        this.variableNameToShape.put(varName, shape);
    }

    public void putOrUpdateShapeForVarName(String varName, @NonNull long[] shape, boolean clearArrayOnShapeMismatch) {
        if (shape == null) {
            throw new NullPointerException("shape is marked @NonNull but is null");
        }
        if (this.variableNameToShape.containsKey(varName)) {
            this.updateShapeForVarName(varName, shape, clearArrayOnShapeMismatch);
        } else {
            this.putShapeForVarName(varName, shape);
        }
    }

    public boolean shapeAlreadyExistsForVarName(String varName) {
        return this.variableNameToShape.containsKey(varName) || this.arrayAlreadyExistsForVarName(varName);
    }

    public boolean arrayAlreadyExistsForVarName(String varName) {
        return this.variableNameToArr.containsKey(varName);
    }

    public INDArray getArrForVarName(String varName) {
        return this.variableNameToArr.get(varName);
    }

    public void associateArrayWithVariable(INDArray arr, @NonNull String variable) {
        if (variable == null) {
            throw new NullPointerException("variable is marked @NonNull but is null");
        }
        this.associateArrayWithVariable(arr, this.getVariable(variable));
    }

    public void associateArrayWithVariable(INDArray arr, SDVariable variable) {
        if (variable == null) {
            throw new ND4JIllegalArgumentException("Variable must not be null!");
        }
        if (arr == null) {
            throw new ND4JIllegalArgumentException("Array must not be null");
        }
        this.variableNameToArr.put(variable.getVarName(), arr);
        this.putOrUpdateShapeForVarName(variable.getVarName(), arr.shape(), true);
        this.exec_cache = null;
        if (this.sameDiffFunctionInstances != null && this.sameDiffFunctionInstances.size() > 0) {
            for (Map.Entry<String, SameDiff> e : this.sameDiffFunctionInstances.entrySet()) {
                SameDiff sd = e.getValue();
                if (sd.variableNameToArr == null || !sd.variableNameToArr.containsKey(variable.getVarName())) continue;
                sd.associateArrayWithVariable(arr, variable);
            }
        }
    }

    public void putSubFunction(String name, SameDiff nameSpace) {
        if (this.sameDiffFunctionInstances.containsKey(name) && this.sameDiffFunctionInstances.get(name) != nameSpace) {
            throw new ND4JIllegalStateException("Unable to replace samediff namespace. Please choose another opName");
        }
        this.sameDiffFunctionInstances.put(name, nameSpace);
    }

    public Map<String, SDVariable> variableMap() {
        return this.variableMap;
    }

    public SDVariable invoke(Op op, SDVariable x, SDVariable y) {
        if (!opMethods.containsKey(op.opName())) {
            throw new ND4JIllegalStateException("Illegal method opName " + op.opName());
        }
        if (x != null && y != null) {
            try {
                return (SDVariable)opMethods.get(op.opName()).invoke((Object)this, x, y);
            }
            catch (Exception exception) {
            }
        } else {
            try {
                return (SDVariable)opMethods.get(op.opName()).invoke((Object)this, x);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ND4JIllegalStateException("Illegal method opName " + op.opName());
    }

    public Collection<String> definedFunctionNames() {
        return this.sameDiffFunctionInstances.keySet();
    }

    public long memoryForGraph() {
        return this.numElements() * (long)DataTypeUtil.lengthForDtype((DataBuffer.Type)Nd4j.dataType());
    }

    public SDVariable invoke(Op op, SDVariable x) {
        return this.invoke(op, x, null);
    }

    private SameDiff() {
        this.functionFactory = new DifferentialFunctionFactory(this);
        this.variableMap = new LinkedHashMap<String, SDVariable>();
        this.sameDiffFunctionDefinitionMap = new LinkedHashMap<String, SameDiffFunctionDefinition>();
        this.sameDiffFunctionInstances = new LinkedHashMap<String, SameDiff>();
        this.gradients = new LinkedHashMap<String, SDVariable>();
        this.forwardVarForGrad = new LinkedHashMap<String, SDVariable>();
        this.opsForResult = new IntArrayKeyMap();
        this.variableNameToArr = new LinkedHashMap<String, INDArray>();
        this.variableNameToShape = new LinkedHashMap<String, long[]>();
        this.placeHolderMap = new LinkedHashMap<String, List<String[]>>();
        this.placeHolderVarNames = new LinkedHashSet<String>();
        this.placeHolderOriginalShapes = new LinkedHashMap<String, long[]>();
        this.incomingArgsReverse = new LinkedHashMap<String, String[]>();
        this.outgoingArgsReverse = new LinkedHashMap<String, String[]>();
        this.functionInstancesById = new LinkedHashMap<String, DifferentialFunction>();
        this.placeHolderFunctions = new LinkedHashSet<String>();
        this.functionsArgsFor = new LinkedHashMap<String, List<DifferentialFunction>>();
        this.functionOutputFor = new LinkedHashMap<String, List<DifferentialFunction>>();
        this.baseNameForFunctionInstanceId = new LinkedHashMap<String, String>();
        this.importedVarName = new LinkedHashSet<String>();
        this.permuteOrder = new LinkedHashMap<String, int[]>();
        this.propertiesToResolve = new LinkedHashMap<String, List<String>>();
        this.propertiesForFunction = new LinkedHashMap<String, Map<String, Object>>();
        this.fieldVariableResolutionMapping = HashBasedTable.create();
    }

    public void addPropertyToResolve(DifferentialFunction forFunction, String arrayName) {
        if (!this.propertiesToResolve.containsKey(forFunction.getOwnName())) {
            ArrayList<String> newVal = new ArrayList<String>();
            newVal.add(arrayName);
            this.propertiesToResolve.put(forFunction.getOwnName(), newVal);
        } else {
            List<String> newVal = this.propertiesToResolve.get(forFunction.getOwnName());
            newVal.add(arrayName);
        }
    }

    public List<String> propertiesToResolveForFunction(DifferentialFunction function) {
        if (!this.propertiesToResolve.containsKey(function.getOwnName())) {
            return Collections.emptyList();
        }
        return this.propertiesToResolve.get(function.getOwnName());
    }

    public boolean hasPropertiesToResolve(DifferentialFunction function) {
        return this.propertiesToResolve.containsKey(function.getOwnName());
    }

    public <T> T getPropertyForFunction(DifferentialFunction functionInstance, String propertyName) {
        if (!this.propertiesForFunction.containsKey(functionInstance.getOwnName())) {
            return null;
        }
        Map<String, Object> map = this.propertiesForFunction.get(functionInstance.getOwnName());
        return (T)map.get(propertyName);
    }

    public void addPropertyForFunction(DifferentialFunction functionFor, String propertyName, INDArray property) {
        this.addPropertyForFunction(functionFor, propertyName, (Object)property);
    }

    public void addPropertyForFunction(DifferentialFunction functionFor, String propertyName, long property) {
        this.addPropertyForFunction(functionFor, propertyName, (Object)property);
    }

    private void addPropertyForFunction(DifferentialFunction functionFor, String propertyName, Object propertyValue) {
        if (!this.propertiesForFunction.containsKey(functionFor.getOwnName())) {
            LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
            fields.put(propertyName, propertyValue);
            this.propertiesForFunction.put(functionFor.getOwnName(), fields);
        } else {
            Map<String, Object> fieldMap = this.propertiesForFunction.get(functionFor.getOwnName());
            if (fieldMap.containsKey(propertyName)) {
                throw new ND4JIllegalStateException("Attempting to override property " + propertyName);
            }
            fieldMap.put(propertyName, propertyValue);
        }
    }

    public void addVariableMappingForField(DifferentialFunction function, String fieldName, String varName) {
        this.fieldVariableResolutionMapping.put((Object)function.getOwnName(), (Object)fieldName, (Object)varName);
    }

    public String getVarNameForFieldAndFunction(DifferentialFunction function, String fieldName) {
        return (String)this.fieldVariableResolutionMapping.get((Object)function.getOwnName(), (Object)fieldName);
    }

    public boolean isImportVariable(String variableName) {
        return this.importedVarName.contains(variableName);
    }

    public void addVarNameForImport(String varName) {
        this.importedVarName.add(varName);
    }

    public void setBaseNameForFunctionInstanceId(String baseName, DifferentialFunction function) {
        this.baseNameForFunctionInstanceId.put(function.getOwnName(), baseName);
    }

    public String getBaseNameForFunction(DifferentialFunction function) {
        return this.baseNameForFunctionInstanceId.get(function.getOwnName());
    }

    public <X extends SDVariable> X setupFunction(X function) {
        Preconditions.checkNotNull(function, (String)"Passed in function must not be null!");
        if (function instanceof SDVariable) {
            if (function.getSameDiff() != this) {
                function.setSameDiff(this);
            }
            return function;
        }
        return function;
    }

    public void addOutgoingFor(SDVariable[] variables, DifferentialFunction function) {
        String[] varNames = new String[variables.length];
        for (int i = 0; i < varNames.length; ++i) {
            varNames[i] = variables[i].getVarName();
        }
        this.addOutgoingFor(varNames, function);
    }

    public void addOutgoingFor(String[] varNames, DifferentialFunction function) {
        if (function.getOwnName() == null) {
            throw new ND4JIllegalStateException("Instance id can not be null. Function not initialized properly");
        }
        if (this.outgoingArgsReverse.containsKey(function.getOwnName())) {
            throw new ND4JIllegalStateException("Outgoing arguments already declared for " + function);
        }
        if (varNames == null) {
            throw new ND4JIllegalStateException("Var names can not be null!");
        }
        for (int i = 0; i < varNames.length; ++i) {
            if (varNames[i] != null) continue;
            throw new ND4JIllegalStateException("Variable name elements can not be null!");
        }
        this.outgoingArgsReverse.put(function.getOwnName(), varNames);
        for (String resultName : varNames) {
            List<DifferentialFunction> funcs = this.functionOutputFor.get(resultName);
            if (funcs == null) {
                funcs = new ArrayList<DifferentialFunction>();
                this.functionOutputFor.put(resultName, funcs);
            }
            funcs.add(function);
        }
    }

    public void addArgsFor(String[] variables, DifferentialFunction function) {
        if (function.getOwnName() == null) {
            throw new ND4JIllegalStateException("Instance id can not be null. Function not initialized properly");
        }
        for (String varName : variables) {
            if (!this.isPlaceHolder(varName)) continue;
            this.placeHolderFunctions.add(function.getOwnName());
        }
        this.incomingArgsReverse.put(function.getOwnName(), variables);
        for (String variableName : variables) {
            List<DifferentialFunction> funcs = this.functionsArgsFor.get(variableName);
            if (funcs == null) {
                funcs = new ArrayList<DifferentialFunction>();
                this.functionsArgsFor.put(variableName, funcs);
            }
            funcs.add(function);
        }
    }

    public void addArgsFor(SDVariable[] variables, DifferentialFunction function) {
        String[] varNames = new String[variables.length];
        for (int i = 0; i < varNames.length; ++i) {
            if (variables[i] == null) {
                throw new ND4JIllegalStateException("Found null variable at index " + i);
            }
            varNames[i] = variables[i].getVarName();
        }
        this.addArgsFor(varNames, function);
    }

    public DifferentialFunction getVariableOutputFunction(String variableName) {
        List<DifferentialFunction> list = this.functionOutputFor.get(variableName);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public List<DifferentialFunction> getVariableArgOfFunctions(String variableName) {
        return this.functionsArgsFor.get(variableName);
    }

    public boolean hasArgs(DifferentialFunction function) {
        String[] vertexIdArgs = this.incomingArgsReverse.get(function.getOwnName());
        return vertexIdArgs != null && vertexIdArgs.length > 0;
    }

    public DifferentialFunction[] functions() {
        Collection<DifferentialFunction> ret = this.functionInstancesById.values();
        return ret.toArray(new DifferentialFunction[ret.size()]);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.variableMap != null ? this.variableMap.hashCode() : 0);
        return result;
    }

    public static SameDiff create(SameDiff originalSameDiff) {
        DifferentialFunctionFactory differentialFunctionFactory;
        SameDiff ret = SameDiff.builder().variableMap(originalSameDiff.variableMap).sameDiffFunctionInstances(originalSameDiff.sameDiffFunctionInstances).build();
        ret.functionFactory = differentialFunctionFactory = new DifferentialFunctionFactory(ret);
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SameDiff sameDiff = (SameDiff)o;
        if (this.variableMap != null ? !this.variableMap.equals(sameDiff.variableMap) : sameDiff.variableMap != null) {
            return false;
        }
        if (this.sameDiffFunctionDefinitionMap != null ? !this.sameDiffFunctionDefinitionMap.equals(sameDiff.sameDiffFunctionDefinitionMap) : sameDiff.sameDiffFunctionDefinitionMap != null) {
            return false;
        }
        return this.sameDiffFunctionInstances != null ? this.sameDiffFunctionInstances.equals(sameDiff.sameDiffFunctionInstances) : sameDiff.sameDiffFunctionInstances == null;
    }

    public static SameDiff create() {
        return new SameDiff();
    }

    public INDArray[] eval(Map<String, INDArray> inputs) {
        SameDiff execPipeline = this.dup();
        List opExecAction = (List)execPipeline.exec().getRight();
        if (opExecAction.isEmpty()) {
            throw new IllegalStateException("No ops found to execute.");
        }
        INDArray[] ret = new INDArray[opExecAction.size()];
        for (int i = 0; i < ret.length; ++i) {
            String varName = ((DifferentialFunction)opExecAction.get(i)).outputVariables()[0].getVarName();
            ret[i] = execPipeline.getArrForVarName(varName);
        }
        return ret;
    }

    public SameDiff dup() {
        Cloner cloner = SameDiff.newCloner();
        SameDiff clone = (SameDiff)cloner.deepClone((Object)this);
        return clone;
    }

    public long numElements() {
        long ret = 0L;
        for (SDVariable variable : this.variables()) {
            ret += (long)ArrayUtil.prod((long[])variable.getShape());
        }
        return ret;
    }

    private void initWorkspace() {
        this.workspace = Nd4j.getWorkspaceManager().createNewWorkspace(WorkspaceConfiguration.builder().initialSize(this.memoryForGraph()).policyAllocation(AllocationPolicy.OVERALLOCATE).policyLearning(LearningPolicy.FIRST_LOOP).build());
        Nd4j.getWorkspaceManager().setWorkspaceForCurrentThread(this.workspace);
    }

    public List<SDVariable> variables() {
        return new ArrayList<SDVariable>(this.variableMap.values());
    }

    public SDVariable one(String name, int[] shape) {
        return this.var(name, ArrayUtil.toLongArray((int[])shape), new ConstantInitScheme('f', 1.0));
    }

    public SDVariable one(String name, long[] shape) {
        return this.var(name, shape, new ConstantInitScheme('f', 1.0));
    }

    public SDVariable onesLike(SDVariable input) {
        return this.onesLike(null, input);
    }

    public SDVariable onesLike(String name, SDVariable input) {
        SDVariable ret = this.f().onesLike(name, input);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable zero(String name, long[] shape) {
        return this.var(name, shape, new ZeroInitScheme());
    }

    public SDVariable zero(String name, int[] shape) {
        return this.var(name, ArrayUtil.toLongArray((int[])shape), new ZeroInitScheme());
    }

    public SDVariable zerosLike(SDVariable input) {
        return this.zerosLike(null, input);
    }

    public SDVariable zerosLike(String name, SDVariable input) {
        SDVariable ret = this.f().zerosLike(name, input);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable constant(SDVariable value, long ... shape) {
        return this.constant(null, value, shape);
    }

    public SDVariable constant(String name, SDVariable value, long ... shape) {
        SDVariable ret = this.f().constant(value, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable linspace(double start, double stop, long number) {
        return this.linspace(null, start, stop, number);
    }

    public SDVariable linspace(String name, double start, double stop, long number) {
        SDVariable ret = this.f().linspace(start, stop, number);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable range(double from, double to, double step) {
        return this.range(null, from, to, step);
    }

    public SDVariable range(String name, double from, double to, double step) {
        SDVariable ret = this.f().range(from, to, step);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] meshgrid(SDVariable ... inputs) {
        return this.meshgrid((List<String>)null, inputs);
    }

    public SDVariable[] meshgrid(List<String> names, SDVariable ... inputs) {
        return this.meshgrid(names, true, inputs);
    }

    public SDVariable[] meshgrid(List<String> names, boolean cartesian, SDVariable ... inputs) {
        Preconditions.checkState((names == null || names.size() == inputs.length ? 1 : 0) != 0, (String)"Got %s names but %s inputs", (int)(names == null ? 0 : names.size()), (int)inputs.length);
        SDVariable[] ret = this.f().meshgrid(cartesian, inputs);
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.updateVariableNameAndReference(ret[i], names == null ? null : names.get(i));
        }
        return ret;
    }

    public SDVariable var(String name, long[] shape, WeightInitScheme weightInitScheme) {
        if (this.variableMap.containsKey(name) && this.variableMap.get(name).getArr() != null) {
            throw new IllegalArgumentException("Another variable with the name " + name + " already exists.");
        }
        if (name == null || name.length() < 1) {
            name = this.getNewVarName();
        }
        if (this.workspace == null) {
            this.initWorkspace();
        }
        SDVariable ret = SDVariable.builder().sameDiff(this).shape(shape).weightInitScheme(weightInitScheme).varName(name).build();
        this.addVariable(ret);
        this.variableMap.put(name, ret);
        return ret;
    }

    public SDVariable var(String name, long ... shape) {
        Preconditions.checkNotNull((Object)(shape != null ? 1 : 0), (String)"Invalid shape: shape may not be null");
        return this.var(name, shape, new ZeroInitScheme());
    }

    public SDVariable var(String name, int ... shape) {
        Preconditions.checkNotNull((Object)(shape != null ? 1 : 0), (String)"Invalid shape: shape may not be null");
        return this.var(name, ArrayUtil.toLongArray((int[])shape), new ZeroInitScheme());
    }

    public SDVariable var(final SDVariable arr) {
        if (this.variableMap.containsKey(arr.getVarName()) && this.variableMap.get(arr.getVarName()).getArr() != null) {
            return this.variableMap.get(arr.getVarName());
        }
        if (arr.getVarName() == null || arr.getVarName().length() < 1) {
            throw new IllegalArgumentException("Name for variable must be defined");
        }
        if (arr == null) {
            throw new IllegalArgumentException("Array for " + arr.getVarName() + " must not be null");
        }
        if (this.workspace == null) {
            this.initWorkspace();
        }
        SDVariable ret = SDVariable.builder().sameDiff(this).shape(arr.getShape()).varName(arr.getVarName()).weightInitScheme(new NDArraySupplierInitScheme(new NDArraySupplierInitScheme.NDArraySupplier(){

            @Override
            public INDArray getArr() {
                if (arr.getArr() == null) {
                    INDArray retArr = arr.getWeightInitScheme().create(arr.getShape());
                    SameDiff.this.associateArrayWithVariable(retArr, arr);
                }
                return arr.getArr();
            }
        })).build();
        this.variableMap.put(arr.getVarName(), ret);
        return ret;
    }

    private String getNewVarName() {
        String varName = "sd_var_" + String.valueOf(this.variableId);
        while (this.variableMap.containsKey(varName)) {
            ++this.variableId;
            varName = "sd_var_" + String.valueOf(this.variableId);
        }
        return varName;
    }

    public SDVariable var(int ... shape) {
        return this.var(this.getNewVarName(), shape);
    }

    public SDVariable var(long ... shape) {
        return this.var(this.getNewVarName(), shape);
    }

    public SDVariable var(WeightInitScheme weightInitScheme, long ... shape) {
        return this.var(this.getNewVarName(), shape, weightInitScheme);
    }

    public SDVariable var(INDArray arr) {
        return this.var(this.getNewVarName(), arr);
    }

    public SDVariable var(String name, INDArray arr) {
        if (this.variableMap.containsKey(name) && this.variableMap.get(name).getArr() != null) {
            throw new IllegalArgumentException("Another variable with the name " + name + " already exists.");
        }
        if (name == null || name.length() < 1) {
            name = this.getNewVarName();
        }
        if (arr == null) {
            throw new IllegalArgumentException("Array for " + name + " must not be null");
        }
        if (this.workspace == null) {
            this.initWorkspace();
        }
        final INDArray arrRef = arr.migrate();
        SDVariable ret = SDVariable.builder().sameDiff(this).shape(arr.shape()).varName(name).weightInitScheme(new NDArraySupplierInitScheme(new NDArraySupplierInitScheme.NDArraySupplier(){

            @Override
            public INDArray getArr() {
                return arrRef;
            }
        })).build();
        this.associateArrayWithVariable(arr, ret);
        if (ArrayUtil.prod((long[])arr.shape()) == 1) {
            ret.setScalarValue(arr.getDouble(0L));
        }
        this.addVariable(ret);
        if (this.getShapeForVarName(name) == null) {
            this.putShapeForVarName(name, arr.shape());
        }
        this.variableMap.put(name, ret);
        return ret;
    }

    public SDVariable eye(int rows) {
        return this.eye(rows, rows);
    }

    public SDVariable eye(String name, int rows) {
        return this.eye(name, rows, rows);
    }

    public SDVariable eye(int rows, int cols) {
        return this.eye(null, rows, cols);
    }

    public SDVariable eye(String name, int rows, int cols) {
        return this.eye(name, rows, cols, null);
    }

    public SDVariable eye(int rows, int cols, int ... batchDimension) {
        return this.eye(null, rows, cols, batchDimension);
    }

    public SDVariable eye(String name, int rows, int cols, int ... batchDimension) {
        SDVariable eye = new Eye(this, rows, cols, batchDimension).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(String name, SDVariable rows, SDVariable cols, SDVariable batchDimension) {
        SDVariable eye = new Eye(this, rows, cols, batchDimension).outputVariable();
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(SDVariable rows, SDVariable cols, SDVariable batchDimension) {
        return this.eye(null, rows, cols, batchDimension);
    }

    public SDVariable eye(String name, SDVariable rows, SDVariable cols) {
        SDVariable eye = new Eye(this, rows, cols).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(SDVariable rows, SDVariable cols) {
        SDVariable eye = new Eye(this, rows, cols).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, null);
    }

    public SDVariable eye(String name, SDVariable rows) {
        SDVariable eye = new Eye(this, rows).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, name);
    }

    public SDVariable eye(SDVariable rows) {
        SDVariable eye = new Eye(this, rows).outputVariables()[0];
        return this.updateVariableNameAndReference(eye, null);
    }

    public void removeArgFromFunction(String varName, DifferentialFunction function) {
        SDVariable[] args = function.args();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].getVarName().equals(varName)) continue;
            String[] reverseArgs = this.incomingArgsReverse.get(function.getOwnName());
            this.incomingArgsReverse.remove(function.getOwnName());
            ArrayList<String> newArgs = new ArrayList<String>(args.length - 1);
            for (int arg = 0; arg < args.length; ++arg) {
                if (reverseArgs[arg].equals(varName)) continue;
                newArgs.add(reverseArgs[arg]);
            }
            String[] newArgsArr = newArgs.toArray(new String[newArgs.size()]);
            this.incomingArgsReverse.put(function.getOwnName(), newArgsArr);
            break;
        }
    }

    public SDVariable getVariable(String name) {
        return this.variableMap.get(name);
    }

    public SDVariable getGradForVariable(String varName) {
        if (this.gradients.containsKey(varName)) {
            return this.gradients.get(varName);
        }
        if (this.sameDiffFunctionInstances.containsKey("grad") && this.sameDiffFunctionInstances.get((Object)"grad").gradients.containsKey(varName)) {
            return this.sameDiffFunctionInstances.get((Object)"grad").gradients.get(varName);
        }
        return null;
    }

    public void setGradientForVariableName(String variableName, SDVariable variable) {
        if (variable == null) {
            throw new ND4JIllegalStateException("Unable to set null gradient for variable name " + variableName);
        }
        this.gradients.put(variableName, variable);
    }

    public SDVariable getForwardVariableForVertexId(int vertexId) {
        return this.forwardVarForGrad.get(vertexId);
    }

    public void setForwardVariableForVarName(String varName, SDVariable forwardVariable) {
        this.forwardVarForGrad.put(varName, forwardVariable);
    }

    public SDVariable grad(String varName) {
        if (!this.sameDiffFunctionInstances.containsKey("grad")) {
            throw new IllegalStateException("Unable to obtain gradient. Please run execBackwards() first.");
        }
        SameDiff grad = this.getFunction("grad");
        SDVariable var = grad.getVariable(varName);
        return this.getFunction("grad").getGradForVariable(var.getVarName());
    }

    public SDVariable randomUniform(double min, double max, SDVariable shape) {
        return this.randomUniform(null, min, max, shape);
    }

    public SDVariable randomUniform(String name, double min, double max, SDVariable shape) {
        SDVariable ret = this.f().randomUniform(min, max, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomUniform(double min, double max, long ... shape) {
        return this.randomUniform(null, min, max, shape);
    }

    public SDVariable randomUniform(String name, double min, double max, long ... shape) {
        SDVariable ret = this.f().randomUniform(min, max, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomNormal(double mean, double stddev, SDVariable shape) {
        return this.randomNormal(null, mean, stddev, shape);
    }

    public SDVariable randomNormal(String name, double mean, double stddev, SDVariable shape) {
        SDVariable ret = this.f().randomNormal(mean, stddev, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomNormal(double mean, double stddev, long ... shape) {
        return this.randomNormal(null, mean, stddev, shape);
    }

    public SDVariable randomNormal(String name, double mean, double stddev, long ... shape) {
        SDVariable ret = this.f().randomNormal(mean, stddev, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomLogNormal(double mean, double stddev, long ... shape) {
        return this.randomLogNormal(null, mean, stddev, shape);
    }

    public SDVariable randomLogNormal(String name, double mean, double stddev, long ... shape) {
        SDVariable ret = this.f().randomLogNormal(mean, stddev, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomNormalTruncated(double mean, double stddev, long ... shape) {
        return this.randomNormalTruncated(null, mean, stddev, shape);
    }

    public SDVariable randomNormalTruncated(String name, double mean, double stddev, long ... shape) {
        SDVariable ret = this.f().randomNormalTruncated(mean, stddev, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomBernoulli(double p, SDVariable shape) {
        return this.randomBernoulli(null, p, shape);
    }

    public SDVariable randomBernoulli(String name, double p, SDVariable shape) {
        SDVariable ret = this.f().randomBernoulli(p, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomBernoulli(double p, long ... shape) {
        return this.randomBernoulli(null, p, shape);
    }

    public SDVariable randomBernoulli(String name, double p, long ... shape) {
        SDVariable ret = this.f().randomBernoulli(p, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomBinomial(int nTrials, double p, long ... shape) {
        return this.randomBinomial(null, nTrials, p, shape);
    }

    public SDVariable randomBinomial(String name, int nTrials, double p, long ... shape) {
        SDVariable ret = this.f().randomBinomial(nTrials, p, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable randomExponential(double lambda, SDVariable shape) {
        return this.randomExponential(null, lambda, shape);
    }

    public SDVariable randomExponential(String name, double lambda, SDVariable shape) {
        SDVariable ret = this.f().randomExponential(lambda, shape);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable upsampling2d(SDVariable input, int scale) {
        return this.upsampling2d(null, input, true, scale, scale);
    }

    public SDVariable upsampling2d(String name, SDVariable input, int scale) {
        return this.upsampling2d(name, input, true, scale, scale);
    }

    public SDVariable upsampling2d(SDVariable input, boolean nchw, int scaleH, int scaleW) {
        return this.upsampling2d(null, input, nchw, scaleH, scaleW);
    }

    public SDVariable upsampling2d(String name, SDVariable input, boolean nchw, int scaleH, int scaleW) {
        SDVariable ret = this.f().upsampling2d(input, nchw, scaleH, scaleW);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable avgPooling2d(SDVariable input, Pooling2DConfig pooling2DConfig) {
        return this.avgPooling2d(null, input, pooling2DConfig);
    }

    public SDVariable avgPooling2d(String name, SDVariable input, Pooling2DConfig pooling2DConfig) {
        SDVariable ret = this.f().avgPooling2d(input, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling2d(SDVariable input, Pooling2DConfig pooling2DConfig) {
        return this.maxPooling2d(null, input, pooling2DConfig);
    }

    public SDVariable maxPooling2d(String name, SDVariable input, Pooling2DConfig pooling2DConfig) {
        SDVariable ret = this.f().maxPooling2d(input, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable avgPooling3d(SDVariable input, Pooling3DConfig pooling3DConfig) {
        return this.avgPooling3d(null, input, pooling3DConfig);
    }

    public SDVariable avgPooling3d(String name, SDVariable input, Pooling3DConfig pooling3DConfig) {
        SDVariable ret = this.f().avgPooling3d(input, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling3d(SDVariable input, Pooling3DConfig pooling3DConfig) {
        return this.maxPooling3d(null, input, pooling3DConfig);
    }

    public SDVariable maxPooling3d(String name, SDVariable input, Pooling3DConfig pooling3DConfig) {
        SDVariable ret = this.f().maxPooling3d(input, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv1d(SDVariable input, SDVariable weights, Conv1DConfig conv1DConfig) {
        return this.conv1d(null, input, weights, conv1DConfig);
    }

    public SDVariable conv1d(String name, SDVariable input, SDVariable weights, Conv1DConfig conv1DConfig) {
        SDVariable ret = this.f().conv1d(input, weights, conv1DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable localResponseNormalization(SDVariable inputs, LocalResponseNormalizationConfig lrnConfig) {
        return this.localResponseNormalization(null, inputs, lrnConfig);
    }

    public SDVariable localResponseNormalization(String name, SDVariable input, LocalResponseNormalizationConfig lrnConfig) {
        SDVariable ret = this.f().localResponseNormalization(input, lrnConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv2d(SDVariable layerInput, SDVariable weights, Conv2DConfig config) {
        return this.conv2d(layerInput, weights, null, config);
    }

    public SDVariable conv2d(SDVariable layerInput, SDVariable weights, SDVariable bias, Conv2DConfig config) {
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = weights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.conv2d(arr, config);
    }

    public SDVariable conv2d(SDVariable[] inputs, Conv2DConfig config) {
        return this.conv2d(null, inputs, config);
    }

    public SDVariable conv2d(String name, SDVariable[] inputs, Conv2DConfig config) {
        SDVariable ret = this.f().conv2d(inputs, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthWiseConv2d(SDVariable layerInput, SDVariable depthWeights, Conv2DConfig config) {
        return this.depthWiseConv2d(layerInput, depthWeights, null, config);
    }

    public SDVariable depthWiseConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable bias, Conv2DConfig config) {
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = depthWeights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.depthWiseConv2d(arr, config);
    }

    public SDVariable depthWiseConv2d(SDVariable[] inputs, Conv2DConfig depthConv2DConfig) {
        return this.depthWiseConv2d(null, inputs, depthConv2DConfig);
    }

    public SDVariable depthWiseConv2d(String name, SDVariable[] inputs, Conv2DConfig depthConv2DConfig) {
        SDVariable ret = this.f().depthWiseConv2d(inputs, depthConv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable separableConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, Conv2DConfig config) {
        return this.separableConv2d(layerInput, depthWeights, pointWeights, null, config);
    }

    public SDVariable separableConv2d(SDVariable layerInput, SDVariable depthWeights, SDVariable pointWeights, SDVariable bias, Conv2DConfig config) {
        SDVariable[] arr = new SDVariable[bias == null ? 3 : 4];
        arr[0] = layerInput;
        arr[1] = depthWeights;
        arr[2] = pointWeights;
        if (bias != null) {
            arr[3] = bias;
        }
        return this.sconv2d(arr, config);
    }

    public SDVariable sconv2d(SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        return this.sconv2d(null, inputs, conv2DConfig);
    }

    public SDVariable sconv2d(String name, SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        SDVariable ret = this.f().sconv2d(inputs, conv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable deconv2d(SDVariable layerInput, SDVariable weights, DeConv2DConfig deconv2DConfig) {
        return this.deconv2d(layerInput, weights, null, deconv2DConfig);
    }

    public SDVariable deconv2d(SDVariable layerInput, SDVariable weights, SDVariable bias, DeConv2DConfig deconv2DConfig) {
        SDVariable[] arr = new SDVariable[bias == null ? 2 : 3];
        arr[0] = layerInput;
        arr[1] = weights;
        if (bias != null) {
            arr[2] = bias;
        }
        return this.deconv2d(arr, deconv2DConfig);
    }

    public SDVariable deconv2d(SDVariable[] inputs, DeConv2DConfig deconv2DConfig) {
        return this.deconv2d(null, inputs, deconv2DConfig);
    }

    public SDVariable deconv2d(String name, SDVariable[] inputs, DeConv2DConfig deconv2DConfig) {
        SDVariable ret = this.f().deconv2d(inputs, deconv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv3d(SDVariable input, SDVariable weights, Conv3DConfig conv3DConfig) {
        return this.conv3d(null, input, weights, null, conv3DConfig);
    }

    public SDVariable conv3d(SDVariable input, SDVariable weights, SDVariable bias, Conv3DConfig conv3DConfig) {
        return this.conv3d(null, input, weights, bias, conv3DConfig);
    }

    public SDVariable conv3d(String name, SDVariable input, SDVariable weights, Conv3DConfig conv3DConfig) {
        return this.conv3d(name, input, weights, null, conv3DConfig);
    }

    public SDVariable conv3d(String name, SDVariable input, SDVariable weights, SDVariable bias, Conv3DConfig conv3DConfig) {
        SDVariable[] args = bias == null ? new SDVariable[]{input, weights} : new SDVariable[]{input, weights, bias};
        SDVariable ret = this.f().conv3d(args, conv3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable batchNorm(SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, boolean applyGamma, boolean applyBeta, double epsilon) {
        return this.batchNorm(null, input, mean, variance, gamma, beta, applyGamma, applyBeta, epsilon);
    }

    public SDVariable batchNorm(String name, SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, boolean applyGamma, boolean applyBeta, double epsilon) {
        SDVariable res = this.f().batchNorm(input, mean, variance, gamma, beta, applyGamma, applyBeta, epsilon);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable im2Col(SDVariable in, Conv2DConfig config) {
        return this.im2Col(null, in, config);
    }

    public SDVariable im2Col(String name, SDVariable in, Conv2DConfig config) {
        SDVariable ret = this.f().im2Col(in, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable col2Im(SDVariable in, Conv2DConfig config) {
        return this.col2Im(null, in, config);
    }

    public SDVariable col2Im(String name, SDVariable in, Conv2DConfig config) {
        SDVariable ret = this.f().col2Im(in, config);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalar(String name, double value) {
        return this.var(name, Nd4j.scalar(value));
    }

    public SDVariable gte(SDVariable x, double y) {
        return this.gte(null, x, y);
    }

    public SDVariable gte(String name, SDVariable x, double y) {
        SDVariable result = this.functionFactory.gte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lte(SDVariable x, double y) {
        return this.lte(null, x, y);
    }

    public SDVariable lte(String name, SDVariable x, double y) {
        SDVariable result = this.functionFactory.lte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gt(SDVariable x, double y) {
        return this.gt(null, x, y);
    }

    public SDVariable gt(String name, SDVariable x, double y) {
        SDVariable result = this.functionFactory.gt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lt(SDVariable x, double y) {
        return this.lt(null, x, y);
    }

    public SDVariable lt(String name, SDVariable x, double y) {
        SDVariable result = this.functionFactory.lt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neq(SDVariable x, double y) {
        return this.neq(null, x, y);
    }

    public SDVariable neq(String name, SDVariable x, double y) {
        SDVariable result = this.functionFactory.neq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eq(SDVariable x, double y) {
        return this.eq(null, x, y);
    }

    public SDVariable eq(String name, SDVariable x, double y) {
        SDVariable result = this.functionFactory.eq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gte(SDVariable x, SDVariable y) {
        return this.gte(null, x, y);
    }

    public SDVariable gte(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.functionFactory.gte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lte(SDVariable x, SDVariable y) {
        return this.lte(null, x, y);
    }

    public SDVariable lte(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.functionFactory.lte(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gt(SDVariable x, SDVariable y) {
        return this.gt(null, x, y);
    }

    public SDVariable gt(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.functionFactory.gt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lt(SDVariable x, SDVariable y) {
        return this.lt(null, x, y);
    }

    public SDVariable lt(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.functionFactory.lt(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neq(SDVariable x, SDVariable y) {
        return this.neq(null, x, y);
    }

    public SDVariable neq(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.functionFactory.neq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eq(SDVariable x, SDVariable y) {
        return this.eq(null, x, y);
    }

    public SDVariable eq(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.functionFactory.eq(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable or(SDVariable x, SDVariable y) {
        return this.or(null, x, y);
    }

    public SDVariable or(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.functionFactory.or(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable and(SDVariable x, SDVariable y) {
        return this.and(null, x, y);
    }

    public SDVariable and(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.f().and(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable xor(SDVariable x, SDVariable y) {
        return this.xor(null, x, y);
    }

    public SDVariable xor(String name, SDVariable x, SDVariable y) {
        SDVariable result = this.f().xor(x, y);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable abs(SDVariable x) {
        return this.abs(null, x);
    }

    public SDVariable abs(String name, SDVariable x) {
        SDVariable result = this.f().abs(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neg(SDVariable x) {
        return this.neg(null, x);
    }

    public SDVariable neg(String name, SDVariable x) {
        SDVariable result = this.functionFactory.neg(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cos(SDVariable x) {
        return this.cos(null, x);
    }

    public SDVariable cos(String name, SDVariable x) {
        SDVariable result = this.functionFactory.cos(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sin(SDVariable x) {
        return this.sin(null, x);
    }

    public SDVariable sin(String name, SDVariable x) {
        SDVariable result = this.functionFactory.sin(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tan(SDVariable x) {
        return this.tan(null, x);
    }

    public SDVariable tan(String name, SDVariable x) {
        SDVariable result = this.functionFactory.tan(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable identity(SDVariable input) {
        return this.identity(null, input);
    }

    public SDVariable identity(String name, SDVariable input) {
        SDVariable s = this.f().identity(input);
        return this.updateVariableNameAndReference(s, name);
    }

    public SDVariable invertPermutation(SDVariable input) {
        return this.invertPermutation(null, input);
    }

    public SDVariable invertPermutation(String name, SDVariable input) {
        SDVariable ret = this.f().invertPermutation(input, false);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable acos(SDVariable x) {
        return this.acos(null, x);
    }

    public SDVariable acos(String name, SDVariable x) {
        SDVariable result = this.functionFactory.acos(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable asin(SDVariable x) {
        return this.asin(null, x);
    }

    public SDVariable asin(String name, SDVariable x) {
        SDVariable result = this.functionFactory.asin(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable atan(SDVariable x) {
        return this.atan(null, x);
    }

    public SDVariable atan(String name, SDVariable x) {
        SDVariable result = this.functionFactory.atan(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable atan2(SDVariable y, SDVariable x) {
        return this.atan2(null, y, x);
    }

    public SDVariable atan2(String name, SDVariable y, SDVariable x) {
        SDVariable ret = this.f().atan2(y, x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cosh(SDVariable x) {
        return this.cosh(null, x);
    }

    public SDVariable cosh(String name, SDVariable x) {
        SDVariable result = this.functionFactory.cosh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sinh(SDVariable x) {
        return this.sinh(null, x);
    }

    public SDVariable sinh(String name, SDVariable x) {
        SDVariable result = this.functionFactory.sinh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tanh(SDVariable x) {
        return this.tanh(null, x);
    }

    public SDVariable tanh(String name, SDVariable x) {
        SDVariable result = this.functionFactory.tanh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable step(SDVariable in, double cutoff) {
        return this.step(null, in, cutoff);
    }

    public SDVariable step(String name, SDVariable in, double cutoff) {
        SDVariable ret = this.f().step(in, cutoff);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable acosh(SDVariable x) {
        return this.acosh(null, x);
    }

    public SDVariable acosh(String name, SDVariable x) {
        SDVariable result = this.functionFactory.acosh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable asinh(SDVariable x) {
        return this.asinh(null, x);
    }

    public SDVariable asinh(String name, SDVariable x) {
        SDVariable result = this.functionFactory.asinh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable atanh(SDVariable x) {
        return this.atanh(null, x);
    }

    public SDVariable atanh(String name, SDVariable x) {
        SDVariable result = this.functionFactory.atanh(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable exp(SDVariable x) {
        return this.exp(null, x);
    }

    public SDVariable exp(String name, SDVariable x) {
        SDVariable result = this.functionFactory.exp(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable rsqrt(SDVariable x) {
        return this.rsqrt(null, x);
    }

    public SDVariable rsqrt(String name, SDVariable x) {
        SDVariable result = this.functionFactory.rsqrt(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable expm1(SDVariable x) {
        return this.expm1(null, x);
    }

    public SDVariable expm1(String name, SDVariable x) {
        SDVariable result = this.functionFactory.expm1(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable log1p(SDVariable x) {
        return this.log1p(null, x);
    }

    public SDVariable log1p(String name, SDVariable x) {
        SDVariable result = this.functionFactory.log1p(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable round(SDVariable x) {
        return this.round(null, x);
    }

    public SDVariable round(String name, SDVariable x) {
        SDVariable result = this.functionFactory.round(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isInfinite(SDVariable x) {
        return this.isInfinite(null, x);
    }

    public SDVariable isInfinite(String name, SDVariable x) {
        SDVariable result = this.functionFactory.isInfinite(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isNaN(SDVariable x) {
        return this.isNaN(null, x);
    }

    public SDVariable isNaN(String name, SDVariable x) {
        SDVariable result = this.functionFactory.isNaN(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isFinite(SDVariable x) {
        return this.isFinite(null, x);
    }

    public SDVariable isFinite(String name, SDVariable x) {
        SDVariable result = this.functionFactory.isFinite(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isMax(SDVariable x) {
        return this.isMax(null, x);
    }

    public SDVariable isMax(String name, SDVariable x) {
        SDVariable ret = this.f().isMax(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable isNonDecreasing(SDVariable x) {
        return this.isNonDecreasing(null, x);
    }

    public SDVariable isNonDecreasing(String name, SDVariable x) {
        SDVariable result = this.functionFactory.isNonDecreasing(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isStrictlyIncreasing(SDVariable x) {
        return this.isStrictlyIncreasing(null, x);
    }

    public SDVariable isStrictlyIncreasing(String name, SDVariable x) {
        SDVariable result = this.functionFactory.isStrictlyIncreasing(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isNumericTensor(SDVariable x) {
        return this.isNumericTensor(null, x);
    }

    public SDVariable isNumericTensor(String name, SDVariable x) {
        SDVariable result = this.functionFactory.isNumericTensor(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable replaceWhere(SDVariable update, SDVariable from, Condition condition) {
        return this.replaceWhere(null, update, from, condition);
    }

    public SDVariable replaceWhere(String name, SDVariable update, SDVariable from, Condition condition) {
        SDVariable ret = this.f().replaceWhere(update, from, condition);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable replaceWhere(SDVariable update, Number value, Condition condition) {
        return this.replaceWhere(null, update, value, condition);
    }

    public SDVariable replaceWhere(String name, SDVariable update, Number value, Condition condition) {
        SDVariable ret = this.f().replaceWhere(update, value, condition);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable log(SDVariable x) {
        return this.log(null, x);
    }

    public SDVariable log(String name, SDVariable x) {
        SDVariable result = this.functionFactory.log(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable log(SDVariable in, double base) {
        return this.log(null, in, base);
    }

    public SDVariable log(String name, SDVariable in, double base) {
        SDVariable ret = this.f().log(in, base);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable logSumExp(SDVariable input, int ... dimensions) {
        return this.logSumExp(null, input, dimensions);
    }

    public SDVariable logSumExp(String name, SDVariable input, int ... dimensions) {
        SDVariable ret = this.f().logSumExp(input, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cube(SDVariable x) {
        return this.cube(null, x);
    }

    public SDVariable cube(String name, SDVariable x) {
        SDVariable result = this.functionFactory.cube(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable pow(SDVariable x, double value) {
        return this.pow(null, x, value);
    }

    public SDVariable pow(String name, SDVariable x, double value) {
        SDVariable result = this.functionFactory.pow(x, value);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sqrt(SDVariable x) {
        return this.sqrt(null, x);
    }

    public SDVariable sqrt(String name, SDVariable x) {
        SDVariable result = this.functionFactory.sqrt(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable square(SDVariable x) {
        return this.square(null, x);
    }

    public SDVariable square(String name, SDVariable x) {
        SDVariable result = this.functionFactory.square(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable floor(SDVariable x) {
        return this.floor(null, x);
    }

    public SDVariable floor(String name, SDVariable x) {
        SDVariable result = this.functionFactory.floor(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable ceil(SDVariable x) {
        return this.ceil(null, x);
    }

    public SDVariable ceil(String name, SDVariable x) {
        SDVariable ret = this.f().ceil(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByValue(SDVariable x, double clipValueMin, double clipValueMax) {
        return this.clipByValue(null, x, clipValueMin, clipValueMax);
    }

    public SDVariable clipByValue(String name, SDVariable x, double clipValueMin, double clipValueMax) {
        SDVariable ret = this.f().clipByValue(x, clipValueMin, clipValueMax);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByNorm(SDVariable x, double clipValue) {
        return this.clipByNorm(null, x, clipValue);
    }

    public SDVariable clipByNorm(String name, SDVariable x, double clipValue) {
        SDVariable ret = this.f().clipByNorm(x, clipValue);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByNorm(SDVariable x, double clipValue, int ... dimensions) {
        return this.clipByNorm(null, x, clipValue, dimensions);
    }

    public SDVariable clipByNorm(String name, SDVariable x, double clipValue, int ... dimensions) {
        SDVariable ret = this.f().clipByNorm(x, clipValue, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable relu(SDVariable x, double cutoff) {
        return this.relu(null, x, cutoff);
    }

    public SDVariable relu(String name, SDVariable x, double cutoff) {
        SDVariable result = this.functionFactory.relu(x, cutoff);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable relu6(SDVariable x, double cutoff) {
        return this.relu6(null, x, cutoff);
    }

    public SDVariable relu6(String name, SDVariable x, double cutoff) {
        SDVariable result = this.functionFactory.relu6(x, cutoff);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softmax(SDVariable x) {
        return this.softmax(null, x);
    }

    public SDVariable softmax(String name, SDVariable x) {
        SDVariable result = this.functionFactory.softmax(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable logSoftmax(SDVariable x) {
        return this.logSoftmax(null, x);
    }

    public SDVariable logSoftmax(String name, SDVariable x) {
        SDVariable ret = this.f().logSoftmax(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable selu(SDVariable x) {
        return this.selu(null, x);
    }

    public SDVariable selu(String name, SDVariable x) {
        SDVariable ret = this.f().selu(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable mergeAdd(SDVariable ... x) {
        return this.mergeAdd((String)null, x);
    }

    public SDVariable mergeAdd(String name, SDVariable ... inputs) {
        SDVariable ret = this.f().mergeAdd(inputs);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable mergeMax(SDVariable ... x) {
        return this.mergeMax((String)null, x);
    }

    public SDVariable mergeMax(String name, SDVariable ... inputs) {
        SDVariable ret = this.f().mergeMax(inputs);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable mergeAvg(SDVariable ... inputs) {
        return this.mergeAvg((String)null, inputs);
    }

    public SDVariable mergeAvg(String name, SDVariable ... inputs) {
        SDVariable ret = this.f().mergeAvg(inputs);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable batchToSpace(SDVariable x, int[] blocks, int[][] crops) {
        return this.batchToSpace(null, x, blocks, crops);
    }

    public SDVariable batchToSpace(String name, SDVariable x, int[] blocks, int[][] crops) {
        SDVariable ret = this.f().batchToSpace(x, blocks, crops);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthToSpace(SDVariable x, int blockSize, String dataFormat) {
        return this.depthToSpace(null, x, blockSize, dataFormat);
    }

    public SDVariable depthToSpace(String name, SDVariable x, int blockSize, String dataFormat) {
        SDVariable ret = this.f().depthToSpace(x, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToBatch(SDVariable x, int[] blocks, int[][] padding) {
        return this.spaceToBatch(null, x, blocks, padding);
    }

    public SDVariable spaceToBatch(String name, SDVariable x, int[] blocks, int[][] padding) {
        SDVariable ret = this.f().spaceToBatch(x, blocks, padding);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToDepth(SDVariable x, int blockSize, String dataFormat) {
        return this.spaceToDepth(null, x, blockSize, dataFormat);
    }

    public SDVariable spaceToDepth(String name, SDVariable x, int blockSize, String dataFormat) {
        SDVariable ret = this.f().spaceToDepth(x, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] dynamicPartition(SDVariable x, SDVariable partitions, int numPartitions) {
        return this.dynamicPartition(null, x, partitions, numPartitions);
    }

    public SDVariable[] dynamicPartition(String[] name, SDVariable x, SDVariable partitions, int numPartitions) {
        SDVariable[] ret = this.f().dynamicPartition(x, partitions, numPartitions);
        return this.updateVariableNamesAndReferences(ret, name);
    }

    public SDVariable dynamicStitch(SDVariable[] indices, SDVariable[] x) {
        return this.dynamicStitch(null, indices, x);
    }

    public SDVariable dynamicStitch(String name, SDVariable[] indices, SDVariable[] x) {
        SDVariable ret = this.f().dynamicStitch(indices, x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentMax(SDVariable data, SDVariable segmentIds) {
        return this.segmentMax(null, data, segmentIds);
    }

    public SDVariable segmentMax(String name, SDVariable data, SDVariable segmentIds) {
        SDVariable ret = this.f().segmentMax(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentMin(SDVariable data, SDVariable segmentIds) {
        return this.segmentMin(null, data, segmentIds);
    }

    public SDVariable segmentMin(String name, SDVariable data, SDVariable segmentIds) {
        SDVariable ret = this.f().segmentMin(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentMean(SDVariable data, SDVariable segmentIds) {
        return this.segmentMean(null, data, segmentIds);
    }

    public SDVariable segmentMean(String name, SDVariable data, SDVariable segmentIds) {
        SDVariable ret = this.f().segmentMean(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentProd(SDVariable data, SDVariable segmentIds) {
        return this.segmentProd(null, data, segmentIds);
    }

    public SDVariable segmentProd(String name, SDVariable data, SDVariable segmentIds) {
        SDVariable ret = this.f().segmentProd(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable segmentSum(SDVariable data, SDVariable segmentIds) {
        return this.segmentSum(null, data, segmentIds);
    }

    public SDVariable segmentSum(String name, SDVariable data, SDVariable segmentIds) {
        SDVariable ret = this.f().segmentSum(data, segmentIds);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable dilation2D(SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        return this.dilation2D(null, df, weights, strides, rates, isSameMode);
    }

    public SDVariable dilation2D(String name, SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        SDVariable ret = this.f().dilation2D(df, weights, strides, rates, isSameMode);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable shape(SDVariable input) {
        return this.shape(null, input);
    }

    public SDVariable shape(String name, SDVariable input) {
        SDVariable ret = this.f().shape(input);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable size(SDVariable in) {
        return this.size(null, in);
    }

    public SDVariable size(String name, SDVariable in) {
        SDVariable ret = this.f().size(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable rank(SDVariable in) {
        return this.rank(null, in);
    }

    public SDVariable rank(String name, SDVariable in) {
        SDVariable ret = this.f().rank(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sizeAt(SDVariable in, int dimension) {
        return this.sizeAt(null, in, dimension);
    }

    public SDVariable sizeAt(String name, SDVariable in, int dimension) {
        SDVariable ret = this.f().sizeAt(in, dimension);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cross(SDVariable a, SDVariable b) {
        return this.cross(null, a, b);
    }

    public SDVariable cross(String name, SDVariable a, SDVariable b) {
        SDVariable ret = this.f().cross(a, b);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gather(SDVariable df, int[] indices, int axis) {
        return this.gather(null, df, indices, axis);
    }

    public SDVariable gather(String name, SDVariable df, int[] indices, int axis) {
        SDVariable ret = this.f().gather(df, indices, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gather(SDVariable df, SDVariable indices, int axis) {
        return this.gather(null, df, indices, axis);
    }

    public SDVariable gather(String name, SDVariable df, SDVariable indices, int axis) {
        SDVariable ret = this.f().gather(df, indices, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gatherNd(SDVariable df, SDVariable indices) {
        return this.gatherNd(null, df, indices);
    }

    public SDVariable gatherNd(String name, SDVariable df, SDVariable indices) {
        SDVariable ret = this.f().gatherNd(df, indices);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable repeat(SDVariable df, int axis) {
        return this.repeat(null, df, axis);
    }

    public SDVariable repeat(String name, SDVariable df, int axis) {
        SDVariable ret = this.f().repeat(df, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stack(int axis, SDVariable ... values) {
        return this.stack(null, axis, values);
    }

    public SDVariable stack(String name, int axis, SDVariable ... values) {
        SDVariable ret = this.f().stack(values, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable parallel_stack(SDVariable[] values) {
        return this.parallel_stack(null, values);
    }

    public SDVariable parallel_stack(String name, SDVariable[] values) {
        SDVariable ret = this.f().parallel_stack(values);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] unstack(SDVariable value, int axis) {
        return this.unstack(null, value, axis);
    }

    public SDVariable[] unstack(String[] names, SDVariable value, int axis) {
        SDVariable[] ret = this.f().unstack(value, axis);
        return this.updateVariableNamesAndReferences(ret, names);
    }

    public SDVariable[] unstack(SDVariable value, int axis, int num) {
        return this.unstack(null, value, axis, num);
    }

    public SDVariable[] unstack(String[] names, SDVariable value, int axis, int num) {
        SDVariable[] ret = this.f().unstack(value, axis, num);
        return this.updateVariableNamesAndReferences(ret, names);
    }

    public SDVariable erf(SDVariable x) {
        return this.erf(null, x);
    }

    public SDVariable erf(String name, SDVariable x) {
        SDVariable ret = this.f().erf(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable erfc(SDVariable x) {
        return this.erfc(null, x);
    }

    public SDVariable erfc(String name, SDVariable x) {
        SDVariable ret = this.f().erfc(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable diag(SDVariable x) {
        return this.diag(null, x);
    }

    public SDVariable diag(String name, SDVariable x) {
        SDVariable ret = this.f().diag(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable diagPart(SDVariable x) {
        return this.diagPart(null, x);
    }

    public SDVariable diagPart(String name, SDVariable x) {
        SDVariable ret = this.f().diagPart(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable setDiag(SDVariable in, SDVariable diag) {
        return this.setDiag(null, in, diag);
    }

    public SDVariable setDiag(String name, SDVariable in, SDVariable diag) {
        SDVariable ret = this.f().setDiag(in, diag);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable oneHot(SDVariable indices, int depth) {
        return this.oneHot(null, indices, depth, -1, 1.0, 0.0);
    }

    public SDVariable oneHot(SDVariable indices, int depth, int axis, double on, double off) {
        return this.oneHot(null, indices, depth, axis, on, off);
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth) {
        return this.oneHot(name, indices, depth, -1, 1.0, 0.0);
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth, int axis, double on, double off) {
        SDVariable ret = this.f().onehot(indices, depth, axis, on, off);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reciprocal(SDVariable a) {
        return this.reciprocal(null, a);
    }

    public SDVariable reciprocal(String name, SDVariable a) {
        SDVariable ret = this.f().reciprocal(a);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gradientBackwardsMarker(SDVariable x) {
        return this.gradientBackwardsMarker(this.generateNewVarName(new GradientBackwardsMarker().opName(), 0), x);
    }

    public SDVariable gradientBackwardsMarker(String name, SDVariable x) {
        SDVariable result = this.functionFactory.gradientBackwardsMarker(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable hardTanh(SDVariable in) {
        return this.hardTanh(null, in);
    }

    public SDVariable hardTanh(String name, SDVariable in) {
        SDVariable result = this.functionFactory.hardTanh(in);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable hardSigmoid(SDVariable in) {
        return this.hardSigmoid(null, in);
    }

    public SDVariable hardSigmoid(String name, SDVariable in) {
        SDVariable ret = this.f().hardSigmoid(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable hardTanhDerivative(SDVariable x) {
        return this.hardTanhDerivative(null, x);
    }

    public SDVariable hardTanhDerivative(String name, SDVariable x) {
        SDVariable result = this.functionFactory.hardTanhDerivative(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sigmoid(SDVariable x) {
        return this.sigmoid(null, x);
    }

    public SDVariable sigmoid(String name, SDVariable x) {
        SDVariable result = this.functionFactory.sigmoid(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sigmoidDerivative(SDVariable x, SDVariable wrt) {
        return this.sigmoidDerivative(null, x, wrt);
    }

    public SDVariable sigmoidDerivative(String name, SDVariable x, SDVariable wrt) {
        SDVariable result = this.functionFactory.sigmoidDerivative(x, wrt);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable logSigmoid(SDVariable x) {
        return this.logSigmoid(null, x);
    }

    public SDVariable logSigmoid(String name, SDVariable x) {
        SDVariable ret = this.f().logSigmoid(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sign(SDVariable x) {
        return this.sign(null, x);
    }

    public SDVariable sign(String name, SDVariable x) {
        SDVariable result = this.functionFactory.sign(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softsign(SDVariable x) {
        return this.softsign(null, x);
    }

    public SDVariable softsign(String name, SDVariable x) {
        SDVariable result = this.functionFactory.softsign(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softsignDerivative(SDVariable x) {
        return this.softsignDerivative(null, x);
    }

    public SDVariable softsignDerivative(String name, SDVariable x) {
        SDVariable result = this.functionFactory.softsignDerivative(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softplus(SDVariable x) {
        return this.softplus(null, x);
    }

    public SDVariable softplus(String name, SDVariable x) {
        SDVariable result = this.functionFactory.softplus(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable swish(SDVariable x) {
        return this.swish(null, x);
    }

    public SDVariable swish(String name, SDVariable x) {
        SDVariable ret = this.f().swish(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable elu(SDVariable x) {
        return this.elu(null, x);
    }

    public SDVariable elu(String name, SDVariable x) {
        SDVariable result = this.functionFactory.elu(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eluDerivative(SDVariable x) {
        return this.eluDerivative(null, x);
    }

    public SDVariable eluDerivative(String name, SDVariable x) {
        SDVariable result = this.functionFactory.eluDerivative(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable leakyRelu(SDVariable x, double alpha) {
        return this.leakyRelu(null, x, alpha);
    }

    public SDVariable leakyRelu(String name, SDVariable x, double alpha) {
        SDVariable result = this.functionFactory.leakyRelu(x, alpha);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable leakyReluDerivative(String name, SDVariable x, double alpha) {
        SDVariable result = this.functionFactory.leakyReluDerivative(x, alpha);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mean(SDVariable x) {
        return this.mean(null, x, new int[0]);
    }

    public SDVariable mean(SDVariable x, int ... dimension) {
        return this.mean(null, x, dimension);
    }

    public SDVariable mean(String name, SDVariable x, int ... dimension) {
        return this.mean(name, x, false, dimension);
    }

    public SDVariable mean(String name, SDVariable x, boolean keepDims, int ... dimension) {
        SDVariable result = this.functionFactory.mean(x, keepDims, dimension);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable standardDeviation(SDVariable x, boolean biasCorrected, int ... dimensions) {
        return this.standardDeviation(null, x, biasCorrected, dimensions);
    }

    public SDVariable standardDeviation(String name, SDVariable x, boolean biasCorrected, int ... dimensions) {
        return this.standardDeviation(name, x, biasCorrected, false, dimensions);
    }

    public SDVariable standardDeviation(String name, SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        SDVariable result = this.functionFactory.std(x, biasCorrected, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable variance(SDVariable x, boolean biasCorrected, int ... dimensions) {
        return this.variance(null, x, biasCorrected, dimensions);
    }

    public SDVariable variance(String name, SDVariable x, boolean biasCorrected, int ... dimensions) {
        return this.variance(name, x, biasCorrected, false, dimensions);
    }

    public SDVariable variance(String name, SDVariable x, boolean biasCorrected, boolean keepDims, int ... dimensions) {
        SDVariable result = this.functionFactory.variance(x, biasCorrected, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable entropy(SDVariable in, int ... dimensions) {
        return this.entropy(null, in, dimensions);
    }

    public SDVariable entropy(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().entropy(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable logEntropy(SDVariable in, int ... dimensions) {
        return this.logEntropy(null, in, dimensions);
    }

    public SDVariable logEntropy(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().logEntropy(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable shannonEntropy(SDVariable in, int ... dimensions) {
        return this.shannonEntropy(null, in, dimensions);
    }

    public SDVariable shannonEntropy(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().shannonEntropy(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sum(SDVariable x, int ... dimensions) {
        return this.sum(null, x, dimensions);
    }

    public SDVariable sum(String name, SDVariable x, int ... dimensions) {
        return this.sum(name, x, false, dimensions);
    }

    public SDVariable sum(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.functionFactory.sum(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sum(SDVariable x, boolean keepDims, int ... dimensions) {
        return this.sum(null, x, keepDims, dimensions);
    }

    public SDVariable prod(SDVariable x, int ... dimensions) {
        return this.prod(null, x, dimensions);
    }

    public SDVariable prod(String name, SDVariable x, int ... dimensions) {
        return this.prod(name, x, false, dimensions);
    }

    public SDVariable prod(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.functionFactory.prod(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable scalarMax(SDVariable in, Number value) {
        return this.scalarMax(null, in, value);
    }

    public SDVariable scalarMax(String name, SDVariable in, Number value) {
        SDVariable ret = this.f().scalarMax(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalarMin(SDVariable in, Number value) {
        return this.scalarMin(null, in, value);
    }

    public SDVariable scalarMin(String name, SDVariable in, Number value) {
        SDVariable ret = this.f().scalarMin(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalarFloorMod(SDVariable in, Number value) {
        return this.scalarFloorMod(null, in, value);
    }

    public SDVariable scalarFloorMod(String name, SDVariable in, Number value) {
        SDVariable ret = this.f().scalarFloorMod(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scalarSet(SDVariable in, Number set) {
        return this.scalarSet(null, in, set);
    }

    public SDVariable scalarSet(String name, SDVariable in, Number set) {
        SDVariable ret = this.f().scalarSet(in, set);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable max(SDVariable x, int ... dimensions) {
        return this.max(null, x, dimensions);
    }

    public SDVariable max(String name, SDVariable x, int ... dimensions) {
        return this.max(name, x, false, dimensions);
    }

    public SDVariable max(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.functionFactory.max(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable max(SDVariable first, SDVariable second) {
        return this.max(null, first, second);
    }

    public SDVariable max(String name, SDVariable first, SDVariable second) {
        SDVariable result = this.f().max(first, second);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable amax(SDVariable in, int ... dimensions) {
        return this.amax(null, in, dimensions);
    }

    public SDVariable amax(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().amax(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable amin(SDVariable in, int ... dimensions) {
        return this.amin(null, in, dimensions);
    }

    public SDVariable amin(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().amin(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable amean(SDVariable in, int ... dimensions) {
        return this.amean(null, in, dimensions);
    }

    public SDVariable amean(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().amean(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable asum(SDVariable in, int ... dimensions) {
        return this.asum(null, in, dimensions);
    }

    public SDVariable asum(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().asum(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable countZero(SDVariable input, int ... dimensions) {
        return this.countZero(null, input, dimensions);
    }

    public SDVariable countZero(String name, SDVariable input, int ... dimensions) {
        SDVariable res = this.f().countZero(input, dimensions);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable zeroFraction(SDVariable input) {
        return this.zeroFraction(null, input);
    }

    public SDVariable zeroFraction(String name, SDVariable input) {
        SDVariable res = this.f().zeroFraction(input);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable countNonZero(SDVariable input, int ... dimensions) {
        return this.countNonZero(null, input, dimensions);
    }

    public SDVariable countNonZero(String name, SDVariable input, int ... dimensions) {
        SDVariable res = this.f().countNonZero(input, dimensions);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable min(SDVariable x, int ... dimensions) {
        return this.min(null, x, dimensions);
    }

    public SDVariable min(String name, SDVariable x, int ... dimensions) {
        return this.min(name, x, false, dimensions);
    }

    public SDVariable min(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.functionFactory.min(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable min(SDVariable first, SDVariable second) {
        return this.min(null, first, second);
    }

    public SDVariable min(String name, SDVariable first, SDVariable second) {
        SDVariable result = this.f().min(first, second);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable argmax(SDVariable in, int ... dimensions) {
        return this.argmax(null, in, false, dimensions);
    }

    public SDVariable argmax(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.argmax(null, in, keepDims, dimensions);
    }

    public SDVariable argmax(String name, SDVariable in, int ... dimensions) {
        return this.argmax(name, in, false, dimensions);
    }

    public SDVariable argmax(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().argmax(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable argmin(SDVariable in, int ... dimensions) {
        return this.argmin(null, in, dimensions);
    }

    public SDVariable argmin(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.argmin(null, in, keepDims, dimensions);
    }

    public SDVariable argmin(String name, SDVariable in, int ... dimensions) {
        return this.argmin(name, in, false, dimensions);
    }

    public SDVariable argmin(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().argmin(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable iamax(SDVariable in, int ... dimensions) {
        return this.iamax(null, in, dimensions);
    }

    public SDVariable iamax(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.iamax(null, in, keepDims, dimensions);
    }

    public SDVariable iamax(String name, SDVariable in, int ... dimensions) {
        return this.iamax(name, in, false, dimensions);
    }

    public SDVariable iamax(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().iamax(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable iamin(SDVariable in, int ... dimensions) {
        return this.iamin(null, in, dimensions);
    }

    public SDVariable iamin(SDVariable in, boolean keepDims, int ... dimensions) {
        return this.iamin(null, in, keepDims, dimensions);
    }

    public SDVariable iamin(String name, SDVariable in, int ... dimensions) {
        return this.iamin(name, in, false, dimensions);
    }

    public SDVariable iamin(String name, SDVariable in, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().iamin(in, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable firstIndex(SDVariable in, Condition condition, int ... dimensions) {
        return this.firstIndex(null, in, condition, dimensions);
    }

    public SDVariable firstIndex(SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        return this.firstIndex(null, in, condition, keepDims, dimensions);
    }

    public SDVariable firstIndex(String name, SDVariable in, Condition condition, int ... dimensions) {
        return this.firstIndex(name, in, condition, false, dimensions);
    }

    public SDVariable firstIndex(String name, SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().firstIndex(in, condition, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable lastIndex(SDVariable in, Condition condition, int ... dimensions) {
        return this.lastIndex(null, in, condition, dimensions);
    }

    public SDVariable lastIndex(SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        return this.lastIndex(null, in, condition, keepDims, dimensions);
    }

    public SDVariable lastIndex(String name, SDVariable in, Condition condition, int ... dimensions) {
        return this.lastIndex(name, in, condition, false, dimensions);
    }

    public SDVariable lastIndex(String name, SDVariable in, Condition condition, boolean keepDims, int ... dimensions) {
        SDVariable ret = this.f().lastIndex(in, condition, keepDims, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable matchConditionCount(SDVariable in, Condition condition) {
        return this.matchConditionCount(null, in, condition);
    }

    public SDVariable matchConditionCount(String name, SDVariable in, Condition condition) {
        return this.matchConditionCount(name, in, condition, false, new int[0]);
    }

    public SDVariable matchConditionCount(String name, SDVariable in, Condition condition, boolean keepDim, int ... dimensions) {
        SDVariable ret = this.f().matchConditionCount(in, condition, keepDim, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable matchCondition(SDVariable in, Condition condition) {
        return this.matchCondition(null, in, condition);
    }

    public SDVariable matchCondition(String name, SDVariable in, Condition condition) {
        SDVariable ret = this.f().matchCondition(in, condition);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cumsum(SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        return this.cumsum(null, in, exclusive, reverse, axis);
    }

    public SDVariable cumsum(String name, SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDVariable ret = this.f().cumsum(in, exclusive, reverse, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cumprod(SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        return this.cumprod(null, in, exclusive, reverse, axis);
    }

    public SDVariable cumprod(String name, SDVariable in, boolean exclusive, boolean reverse, int ... axis) {
        SDVariable ret = this.f().cumprod(in, exclusive, reverse, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable biasAdd(SDVariable input, SDVariable bias) {
        return this.biasAdd(null, input, bias);
    }

    public SDVariable biasAdd(String name, SDVariable input, SDVariable bias) {
        SDVariable ret = this.f().biasAdd(input, bias);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reshape(SDVariable x, long ... shape) {
        return this.reshape(null, x, shape);
    }

    public SDVariable reshape(String name, SDVariable x, long ... shape) {
        SDVariable result = this.functionFactory.reshape(x, shape);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reshape(SDVariable x, int ... shape) {
        return this.reshape((String)null, x, shape);
    }

    public SDVariable reshape(String name, SDVariable x, int ... shape) {
        SDVariable result = this.functionFactory.reshape(x, shape);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reshape(SDVariable x, SDVariable shape) {
        return this.reshape(null, x, shape);
    }

    public SDVariable reshape(String name, SDVariable x, SDVariable shape) {
        SDVariable result = this.functionFactory.reshape(x, shape);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reverse(SDVariable x, int ... dimensions) {
        return this.reverse(null, x, dimensions);
    }

    public SDVariable reverse(String name, SDVariable x, int ... dimensions) {
        SDVariable ret = this.f().reverse(x, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        SDVariable ret = this.f().reverseSequence(x, seq_lengths, seqDim, batchDim);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths) {
        SDVariable ret = this.f().reverseSequence(x, seq_lengths);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        return this.reverseSequence(null, x, seq_lengths, seqDim, batchDim);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths) {
        return this.reverseSequence(null, x, seq_lengths);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, SDVariable maxLen) {
        SDVariable ret = this.f().sequenceMask(lengths, maxLen);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, SDVariable maxLen) {
        return this.sequenceMask(null, lengths, maxLen);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, int maxLen) {
        SDVariable ret = this.f().sequenceMask(lengths, maxLen);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, int maxLen) {
        return this.sequenceMask(null, lengths, maxLen);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths) {
        SDVariable ret = this.f().sequenceMask(lengths);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths) {
        SDVariable ret = this.f().sequenceMask(lengths);
        return this.updateVariableNameAndReference(ret, null);
    }

    public SDVariable expandDims(SDVariable x, int axis) {
        return this.expandDims(null, x, axis);
    }

    public SDVariable expandDims(String name, SDVariable x, int axis) {
        SDVariable result = this.f().expandDims(x, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable squeeze(SDVariable x, int axis) {
        return this.squeeze(null, x, axis);
    }

    public SDVariable squeeze(String name, SDVariable x, int axis) {
        SDVariable result = this.f().squeeze(x, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable assign(SDVariable x, SDVariable y) {
        return this.assign(null, x, y);
    }

    public SDVariable assign(String name, SDVariable x, SDVariable y) {
        SDVariable ret = this.f().assign(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable assign(SDVariable in, Number value) {
        return this.assign(null, in, value);
    }

    public SDVariable assign(String name, SDVariable in, Number value) {
        SDVariable ret = this.f().assign(in, value);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable transpose(SDVariable x) {
        return this.transpose(null, x);
    }

    public SDVariable transpose(String name, SDVariable x) {
        SDVariable result = this.functionFactory.transpose(x);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable permute(SDVariable x, int ... dimensions) {
        return this.permute(null, x, dimensions);
    }

    public SDVariable permute(String name, SDVariable x, int ... dimensions) {
        SDVariable result = this.functionFactory.permute(x, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable rollAxis(SDVariable x, int axis) {
        return this.rollAxis(null, x, axis);
    }

    public SDVariable rollAxis(String name, SDVariable x, int axis) {
        SDVariable result = this.functionFactory.rollAxis(x, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable concat(int dimension, SDVariable ... inputs) {
        return this.concat(null, dimension, inputs);
    }

    public SDVariable concat(String name, int dimension, SDVariable ... inputs) {
        SDVariable result = this.functionFactory.concat(dimension, inputs);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable[] moments(SDVariable input, int ... axes) {
        return this.moments(null, input, axes);
    }

    public SDVariable[] moments(String[] name, SDVariable input, int ... axes) {
        SDVariable[] res = this.f().moments(input, axes);
        return this.updateVariableNamesAndReferences(res, name);
    }

    public SDVariable[] normalizeMoments(SDVariable counts, SDVariable means, SDVariable variances, double shift) {
        return this.normalizeMoments(null, counts, means, variances, shift);
    }

    public SDVariable[] normalizeMoments(String[] name, SDVariable counts, SDVariable means, SDVariable variances, double shift) {
        SDVariable[] res = this.f().normalizeMoments(counts, means, variances, shift);
        return this.updateVariableNamesAndReferences(res, name);
    }

    public SDVariable matrixDeterminant(SDVariable in) {
        return this.matrixDeterminant(null, in);
    }

    public SDVariable matrixDeterminant(String name, SDVariable in) {
        SDVariable ret = this.f().matrixDeterminant(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable matrixInverse(SDVariable in) {
        return this.matrixInverse(null, in);
    }

    public SDVariable matrixInverse(String name, SDVariable in) {
        SDVariable ret = this.f().matrixInverse(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable predictions) {
        return this.confusionMatrix((String)null, labels, predictions);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred) {
        SDVariable result = this.f().confusionMatrix(labels, pred);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses) {
        return this.confusionMatrix(null, labels, pred, numClasses);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, Integer numClasses) {
        SDVariable result = this.f().confusionMatrix(labels, pred, numClasses);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, SDVariable weights) {
        return this.confusionMatrix(null, labels, pred, weights);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, SDVariable weights) {
        SDVariable result = this.f().confusionMatrix(labels, pred, weights);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses, SDVariable weights) {
        return this.confusionMatrix(null, labels, pred, numClasses, weights);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, Integer numClasses, SDVariable weights) {
        SDVariable result = this.f().confusionMatrix(labels, pred, numClasses, weights);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tile(SDVariable x, int[] repeat) {
        return this.tile(null, x, repeat);
    }

    public SDVariable tile(String name, SDVariable x, int[] repeat) {
        SDVariable result = this.functionFactory.tile(x, repeat);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable fill(SDVariable shape, double value) {
        return this.fill(null, shape, value);
    }

    public SDVariable fill(String name, SDVariable shape, double value) {
        SDVariable result = this.functionFactory.fill(shape, value);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable dropout(SDVariable input, double inputRetainProbability) {
        return this.dropout(null, input, inputRetainProbability);
    }

    public SDVariable dropout(String name, SDVariable input, double inputRetainProbability) {
        SDVariable res = this.f().dropout(input, inputRetainProbability);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable linear(SDVariable input, SDVariable weights, SDVariable bias) {
        return this.linear(null, input, weights, bias);
    }

    public SDVariable linear(String name, SDVariable input, SDVariable weights, SDVariable bias) {
        SDVariable res = this.f().xwPlusB(input, weights, bias);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable reluLayer(SDVariable input, SDVariable weights, SDVariable bias) {
        return this.reluLayer(null, input, weights, bias);
    }

    public SDVariable reluLayer(String name, SDVariable input, SDVariable weights, SDVariable bias) {
        SDVariable res = this.f().reluLayer(input, weights, bias);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y, MMulTranspose transpose) {
        return this.mmul(null, x, y, transpose);
    }

    public SDVariable mmul(SDVariable x, SDVariable y) {
        return this.mmul(null, x, y);
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y, MMulTranspose transpose) {
        SDVariable result = this.functionFactory.mmul(x, y, transpose);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y) {
        return this.mmul(name, x, y, MMulTranspose.allFalse());
    }

    public SDVariable[] batchMmul(String[] names, SDVariable[] matricesA, SDVariable[] matricesB, boolean transposeA, boolean transposeB) {
        SDVariable[] result = this.functionFactory.batchMmul(matricesA, matricesB, transposeA, transposeB);
        return this.updateVariableNamesAndReferences(result, names);
    }

    public SDVariable[] batchMmul(SDVariable[] matricesA, SDVariable[] matricesB, boolean transposeA, boolean transposeB) {
        return this.batchMmul(null, matricesA, matricesB, transposeA, transposeB);
    }

    public SDVariable[] batchMmul(SDVariable[] matricesA, SDVariable[] matricesB) {
        return this.batchMmul(null, matricesA, matricesB, false, false);
    }

    public SDVariable tensorMmul(SDVariable x, SDVariable y, int[][] dimensions) {
        return this.tensorMmul(null, x, y, dimensions);
    }

    public SDVariable dot(SDVariable x, SDVariable y, int ... dimensions) {
        return this.dot(null, x, y, dimensions);
    }

    public SDVariable dot(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable ret = this.f().dot(x, y, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable norm1(String name, SDVariable x, int ... dimensions) {
        return this.norm1(name, x, false, dimensions);
    }

    public SDVariable norm1(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.f().norm1(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable norm2(String name, SDVariable x, int ... dimensions) {
        return this.norm2(name, x, false, dimensions);
    }

    public SDVariable norm2(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.f().norm2(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable squaredNorm(SDVariable x, int ... dimensions) {
        return this.squaredNorm(null, x, false, dimensions);
    }

    public SDVariable squaredNorm(String name, SDVariable x, int ... dimensions) {
        return this.squaredNorm(name, x, false, dimensions);
    }

    public SDVariable squaredNorm(SDVariable x, boolean keepDims, int ... dimensions) {
        return this.squaredNorm(null, x, keepDims, dimensions);
    }

    public SDVariable squaredNorm(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.f().squaredNorm(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable normmax(String name, SDVariable x, int ... dimensions) {
        return this.normmax(name, x, false, dimensions);
    }

    public SDVariable normmax(String name, SDVariable x, boolean keepDims, int ... dimensions) {
        SDVariable result = this.f().normmax(x, keepDims, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cosineSimilarity(SDVariable x, SDVariable y, int ... dimensions) {
        return this.cosineSimilarity(this.generateNewVarName("cosinesimilarity", 0), x, y, dimensions);
    }

    public SDVariable cosineSimilarity(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable cosim = this.functionFactory.cosineSimilarity(x, y, dimensions);
        return this.updateVariableNameAndReference(cosim, name);
    }

    public SDVariable euclideanDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.euclideanDistance(this.generateNewVarName("euclidean", 0), x, y, dimensions);
    }

    public SDVariable euclideanDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.euclideanDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable manhattanDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.manhattanDistance(this.generateNewVarName("manhattan", 0), x, y, dimensions);
    }

    public SDVariable manhattanDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.manhattanDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cosineDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.cosineDistance(null, x, y, dimensions);
    }

    public SDVariable cosineDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.cosineDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable hammingDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.hammingDistance(null, x, y, dimensions);
    }

    public SDVariable hammingDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.hammingDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable jaccardDistance(SDVariable x, SDVariable y, int ... dimensions) {
        return this.jaccardDistance(null, x, y, dimensions);
    }

    public SDVariable jaccardDistance(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.jaccardDistance(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossBinaryXENT(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossBinaryXENT(this.generateNewVarName(new LossBinaryXENT().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossCosineSimilarity(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossCosineSimilarity(this.generateNewVarName(new LossCosineProximity().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossHinge(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossHinge(this.generateNewVarName(new LossHinge().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossKLD(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossKLD(this.generateNewVarName(new LossKLD().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossL1(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossL1(this.generateNewVarName(new LossL1().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossL2(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossL2(this.generateNewVarName(new LossL2().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossMAE(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossMAE(this.generateNewVarName(new LossMAE().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossMSE(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossMSE(this.generateNewVarName(new LossMSE().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossMCXENT(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossMCXENT(this.generateNewVarName(new LossMCXENT().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossMSLE(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossMSLE(this.generateNewVarName(new LossMSLE().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossNegativeLogLikelihood(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossNegativeLogLikelihood(this.generateNewVarName(new LossNegativeLogLikelihood().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossPoisson(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossPoisson(this.generateNewVarName(new LossPoisson().opName(), 0), x, y, dimensions);
    }

    public SDVariable lossSquaredHinge(SDVariable x, SDVariable y, int ... dimensions) {
        return this.lossSquaredHinge(this.generateNewVarName(new LossSquaredHinge().opName(), 0), x, y, dimensions);
    }

    public SDVariable softmaxDerivative(String name, SDVariable x, SDVariable wrt) {
        return this.softmaxDerivative(name, x, wrt, null);
    }

    public SDVariable softmaxDerivative(String name, SDVariable x, SDVariable wrt, Integer dimension) {
        SDVariable result = this.functionFactory.softmaxDerivative(x, wrt, dimension);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tensorMmul(String name, SDVariable x, SDVariable y, int[][] dimensions) {
        SDVariable result = this.functionFactory.tensorMmul(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sigmoidCrossEntropyWithLogits(SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        return this.sigmoidCrossEntropyWithLogits(null, logits, weights, labels, reductionMode, labelSmoothing);
    }

    public SDVariable sigmoidCrossEntropyWithLogits(String name, SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        SDVariable res = this.f().sigmoidCrossEntropyWithLogits(logits, weights, labels, reductionMode, labelSmoothing);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable softmaxCrossEntropyWithLogits(SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        return this.softmaxCrossEntropyWithLogits(null, logits, weights, labels, reductionMode, labelSmoothing);
    }

    public SDVariable softmaxCrossEntropyWithLogits(String name, SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        SDVariable res = this.f().softmaxCrossEntropyWithLogits(logits, weights, labels, reductionMode, labelSmoothing);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable weightedCrossEntropyWithLogits(SDVariable targets, SDVariable inputs, SDVariable weights) {
        return this.weightedCrossEntropyWithLogits(null, targets, inputs, weights);
    }

    public SDVariable weightedCrossEntropyWithLogits(String name, SDVariable targets, SDVariable inputs, SDVariable weights) {
        SDVariable res = this.f().weightedCrossEntropyWithLogits(targets, inputs, weights);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable lossBinaryXENT(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossBinaryXENT(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossCosineSimilarity(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossCosineSimilarity(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossHinge(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossHinge(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossKLD(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossKLD(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossL1(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossL1(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossL2(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossL2(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMAE(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMAE(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMSE(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMSE(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMCXENT(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMCXENT(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMSLE(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMSLE(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossNegativeLogLikelihood(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossNegativeLogLikelihood(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossPoisson(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossPoisson(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossSquaredHinge(String name, SDVariable x, SDVariable y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossSquaredHinge(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public void addVariable(SDVariable variable) {
        if (this.variableMap == null) {
            this.variableMap = new HashMap<String, SDVariable>();
        }
        Preconditions.checkState((variable.getSameDiff() == this ? 1 : 0) != 0, (String)"Samediff instance must be the same.");
        if (this.variableMap.containsKey(variable.getVarName()) && !this.variableMap.get(variable.getVarName()).equals(variable)) {
            throw new IllegalArgumentException("Variable already found with variable opName " + variable.getVarName());
        }
        Preconditions.checkState((variable.getSameDiff() == this ? 1 : 0) != 0, (String)"Same diff instance for variable must be the same!");
        this.variableMap.put(variable.getVarName(), variable);
    }

    public String generateNewVarName(String baseName, int argIndex) {
        if (this.getVariable(baseName) == null && argIndex == 0) {
            return baseName;
        }
        int count = 0;
        String name = baseName + (count == 0 ? "" : "_" + count) + (argIndex > 0 ? ":" + argIndex : "");
        while (this.getVariable(name) != null) {
            name = baseName + "_" + ++count + (argIndex > 0 ? ":" + argIndex : "");
        }
        if (this.getVariable(name) != null) {
            throw new ND4JIllegalStateException("Converged on already generated variable!");
        }
        return name;
    }

    public SDVariable lstm(String baseName, LSTMCellConfiguration configuration) {
        return new LSTMCell(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable sruCell(SRUCellConfiguration configuration) {
        return new SRUCell(this, configuration).outputVariables()[0];
    }

    public SDVariable sru(SRUConfiguration configuration) {
        return new SRU(this, configuration).outputVariables()[0];
    }

    public SDVariable gru(GRUCellConfiguration configuration) {
        return new GRUCell(this, configuration).outputVariables()[0];
    }

    public SDVariable sruCell(String baseName, SRUCellConfiguration configuration) {
        return new SRUCell(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable sru(String baseName, SRUConfiguration configuration) {
        return new SRU(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable gru(String baseName, GRUCellConfiguration configuration) {
        return new GRUCell(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable slice(SDVariable input, int[] begin, int[] size) {
        return this.slice(null, input, begin, size);
    }

    public SDVariable slice(String name, SDVariable input, int[] begin, int[] size) {
        SDVariable ret = this.f().slice(input, begin, size);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stridedSlice(SDVariable input, int[] begin, int[] end, int[] strides) {
        return this.stridedSlice((String)null, input, begin, end, strides);
    }

    public SDVariable stridedSlice(String name, SDVariable input, int[] begin, int[] end, int[] strides) {
        return this.stridedSlice(name, input, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public SDVariable stridedSlice(SDVariable input, long[] begin, long[] end, long[] strides) {
        return this.stridedSlice(null, input, begin, end, strides);
    }

    public SDVariable stridedSlice(String name, SDVariable input, long[] begin, long[] end, long[] strides) {
        return this.stridedSlice(name, input, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public SDVariable stridedSlice(String name, SDVariable in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        SDVariable ret = this.f().stridedSlice(in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stridedSlice(SDVariable in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        return this.stridedSlice((String)null, in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
    }

    public SDVariable stridedSlice(String name, SDVariable in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        SDVariable ret = this.f().stridedSlice(in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stridedSlice(SDVariable in, long[] begin, long[] end, long[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        return this.stridedSlice(null, in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
    }

    public SDVariable scatterAdd(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterAdd(null, ref, indices, updates);
    }

    public SDVariable scatterAdd(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterAdd(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterMul(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterMul(null, ref, indices, updates);
    }

    public SDVariable scatterMul(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterMul(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterSub(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterSub(null, ref, indices, updates);
    }

    public SDVariable scatterSub(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterSub(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterDiv(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterDiv(null, ref, indices, updates);
    }

    public SDVariable scatterDiv(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterDiv(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterMax(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterMax(null, ref, indices, updates);
    }

    public SDVariable scatterMax(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterMax(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterMin(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterMin(null, ref, indices, updates);
    }

    public SDVariable scatterMin(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterMin(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterUpdate(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterUpdate(null, ref, indices, updates);
    }

    public SDVariable scatterUpdate(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterUpdate(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable trace(SDVariable in) {
        return this.trace(null, in);
    }

    public SDVariable trace(String name, SDVariable in) {
        SDVariable ret = this.f().trace(in);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] generateOutputVariableForOp(DifferentialFunction function, String baseName) {
        List<long[]> outputShape;
        if (baseName == null || baseName.isEmpty() && this.getBaseNameForFunction(function) != null) {
            baseName = this.getBaseNameForFunction(function);
        }
        if (baseName == null) {
            baseName = function.opName();
        }
        if ((outputShape = function.calculateOutputShape()) == null || outputShape.isEmpty()) {
            if (function instanceof CustomOp) {
                CustomOp customOp = (CustomOp)((Object)function);
                int num_outputs = function.getNumOutputs();
                if (num_outputs <= 0) {
                    CustomOpDescriptor descriptor = customOp.getDescriptor();
                    if (descriptor != null) {
                        num_outputs = descriptor.getNumOutputs();
                    }
                    if (num_outputs <= 0) {
                        throw new ND4UnresolvedOutputVariables("Could not determine number of output variables for op " + function.getOwnName() + " - " + function.getClass().getSimpleName() + ". Ops can override getNumOutputs() to specify number of outputs if required");
                    }
                }
                char ordering = 'c';
                SDVariable[] args = function.args();
                if (args != null && args.length > 0 && args[0].getArr() != null) {
                    ordering = function.args()[0].getArr().ordering();
                }
                SDVariable[] ret = new SDVariable[num_outputs];
                for (int i = 0; i < ret.length; ++i) {
                    SDVariable var;
                    SDVariable sDVariable = var = i == 0 ? this.getVariable(baseName) : this.getVariable(baseName + ":" + i);
                    if (var == null) {
                        var = this.var(this.generateNewVarName(baseName, i), null, new ZeroInitScheme(ordering));
                    }
                    var.setOutputIndex(i);
                    var.setCreator(function);
                    ret[i] = var;
                }
                if (this.getOutputsForFunction(function) == null) {
                    this.addOutgoingFor(ret, function);
                }
                return ret;
            }
            if (function instanceof BaseOp && outputShape.isEmpty()) {
                SDVariable[] ret = new SDVariable[1];
                SDVariable checkGet = this.getVariable(baseName);
                char ordering = 'c';
                SDVariable[] args = function.args();
                if (args != null && args.length > 0 && function.args()[0].getArr() != null) {
                    ordering = function.args()[0].getArr().ordering();
                }
                if (checkGet == null) {
                    checkGet = this.var(baseName, null, new ZeroInitScheme(ordering));
                } else if (!this.importedVarName.contains(baseName)) {
                    String newName = this.generateNewVarName(baseName, 0);
                    checkGet = this.var(newName, null, new ZeroInitScheme(ordering));
                }
                if (checkGet == null) {
                    checkGet = this.var(baseName, null, new ZeroInitScheme(ordering));
                }
                checkGet.setOutputIndex(0);
                checkGet.setCreator(function);
                ret[0] = checkGet;
                if (this.getOutputsForFunction(function) == null) {
                    this.addOutgoingFor(ret, function);
                }
                return ret;
            }
        }
        char ordering = 'c';
        if (function.args() != null && function.args().length > 0 && function.args()[0].getArr() != null) {
            ordering = function.args()[0].getArr().ordering();
        }
        SDVariable[] ret = new SDVariable[outputShape.size()];
        String ownName = function.getOwnName();
        String rootName = baseName;
        for (int i = 0; i < ret.length; ++i) {
            long[] shape = outputShape.get(i);
            baseName = rootName + (i > 0 ? ":" + i : "");
            SDVariable checkGet = this.getVariable(baseName);
            if (checkGet == null) {
                checkGet = this.var(baseName, shape, new ZeroInitScheme(ordering));
            } else if (shape != null && !this.shapeAlreadyExistsForVarName(checkGet.getVarName())) {
                this.putShapeForVarName(checkGet.getVarName(), shape);
            } else if (!(shape != null && this.shapeAlreadyExistsForVarName(checkGet.getVarName()) || this.importedVarName.contains(baseName))) {
                int count = 1;
                String name = baseName + "_" + count + (i > 0 ? ":" + i : "");
                while (this.getVariable(name) != null) {
                    name = baseName + "_" + ++count + (i > 0 ? ":" + i : "");
                }
                if (this.getVariable(name) != null) {
                    throw new ND4JIllegalStateException("Converged on already generated variable!");
                }
                checkGet = this.var(name, shape, new ZeroInitScheme(ordering));
            }
            if (checkGet == null) {
                checkGet = this.var(baseName + (i > 0 ? ":" + i : ""), shape, new ZeroInitScheme(ordering));
            }
            checkGet.setOutputIndex(i);
            checkGet.setCreator(function);
            ret[i] = checkGet;
        }
        return ret;
    }

    public SDVariable[] generateOutputVariableForOp(DifferentialFunction function) {
        return this.generateOutputVariableForOp(function, function.opName());
    }

    public SameDiff getFunction(String functionName) {
        return this.sameDiffFunctionInstances.get(functionName);
    }

    public INDArray execAndEndResult(List<DifferentialFunction> ops) {
        List<DifferentialFunction> exec = this.exec(ops);
        Op op = (Op)((Object)exec.get(exec.size() - 1));
        return op.z();
    }

    public INDArray execAndEndResult() {
        List exec = (List)this.exec().getRight();
        DifferentialFunction finalOp = (DifferentialFunction)exec.get(exec.size() - 1);
        SDVariable[] output = finalOp.outputVariables();
        if (output.length > 1) {
            throw new ND4JIllegalStateException(finalOp.opName() + " has multiple outputs. Use execAndEndResults instead.");
        }
        return output[0].getArr();
    }

    public INDArray[] execAndEndResults() {
        List exec = (List)this.exec().getRight();
        DifferentialFunction finalOp = (DifferentialFunction)exec.get(exec.size() - 1);
        SDVariable[] output = finalOp.outputVariables();
        INDArray[] outArrays = new INDArray[output.length];
        for (int i = 0; i < outArrays.length; ++i) {
            outArrays[i] = output[i].getArr();
        }
        return outArrays;
    }

    public INDArray execAndEndResult(int outputIndex) {
        List exec = (List)this.exec().getRight();
        SDVariable output = ((DifferentialFunction)exec.get(exec.size() - 1)).outputVariables()[outputIndex];
        return output.getArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray yetAnotherExecMethod(@NonNull Map<String, INDArray> inputs) {
        if (inputs == null) {
            throw new NullPointerException("inputs is marked @NonNull but is null");
        }
        if (!this.wasRegistered.get()) {
            SameDiff sameDiff = this;
            synchronized (sameDiff) {
                if (!this.wasRegistered.get()) {
                    ByteBuffer bb = this.asFlatBuffers();
                    BytePointer ptr = new BytePointer(bb);
                    Nd4j.getExecutioner().registerGraph(this.hashCode(), (Pointer)ptr);
                    this.wasRegistered.set(true);
                }
            }
        }
        LinkedHashMap<String, INDArray> newMap = new LinkedHashMap<String, INDArray>();
        Set<String> keySet = inputs.keySet();
        for (String key : keySet) {
            SDVariable vx = this.variableMap.get(key);
            newMap.put(vx.getVarName(), inputs.get(key));
        }
        Map<String, INDArray> result = Nd4j.getExecutioner().executeGraph(this.hashCode(), newMap, this.reverseMap);
        if (result.size() == 0) {
            throw new ND4JIllegalStateException("Execution failed");
        }
        ArrayList<INDArray> list = new ArrayList<INDArray>(result.values());
        return list.get(list.size() - 1);
    }

    public List<DifferentialFunction> exec(List<DifferentialFunction> ops) {
        for (int i = 0; i < ops.size(); ++i) {
            Op op = (Op)((Object)ops.get(i));
            Nd4j.getExecutioner().exec(op);
        }
        return ops;
    }

    public TensorList getListByName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        return this.lists.get(name);
    }

    public void putListByName(@NonNull String name, TensorList list) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.lists.put(name, list);
    }

    public While whileStatement(SameDiffConditional sameDiffConditional, SameDiffFunctionDefinition conditionBody, SameDiffFunctionDefinition loopBody, SDVariable[] inputVars) {
        return While.builder().inputVars(inputVars).condition(conditionBody).predicate(sameDiffConditional).trueBody(loopBody).parent(this).blockName("while-" + UUID.randomUUID().toString()).build();
    }

    public If ifStatement(SameDiffConditional conditional, SameDiffFunctionDefinition conditionBody, SameDiffFunctionDefinition trueBody, SameDiffFunctionDefinition falseBody, SDVariable[] inputVars) {
        return If.builder().conditionBody(conditionBody).falseBody(falseBody).trueBody(trueBody).predicate(conditional).inputVars(inputVars).parent(this).blockName("if-" + UUID.randomUUID().toString()).build();
    }

    public TensorArrayV3 tensorArray() {
        return new TensorArrayV3(this);
    }

    public SDVariable invokeFunctionOn(String functionName, SameDiff with) {
        SameDiff instance = this.sameDiffFunctionInstances.get(functionName);
        SDVariable ret = instance.invokeGraphOn(with);
        return ret;
    }

    public SameDiff defineFunction(String function, SameDiffFunctionDefinition functionDefinition, SDVariable[] variables) {
        if (!this.sameDiffFunctionInstances.containsKey(function)) {
            SameDiff sub = SameDiff.create();
            sub.workspace = this.workspace;
            this.child = sub;
            sub.parent = this;
            SDVariable[] ret = new SDVariable[variables.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = sub.var(variables[i]);
            }
            sub.inputs = ret;
            sub.outputs = functionDefinition.define(sub, null, ret);
            this.sameDiffFunctionInstances.put(function, sub);
        }
        this.child = null;
        return this.sameDiffFunctionInstances.get(function);
    }

    public void defineFunction(String function, SameDiffFunctionDefinition functionDefinition) {
        this.defineFunction(function, functionDefinition, new LinkedHashMap<String, INDArray>());
    }

    public void defineFunction(String function, SameDiffFunctionDefinition functionDefinition, Map<String, INDArray> inputs) {
        if (!this.sameDiffFunctionInstances.containsKey(function)) {
            SameDiff sub = SameDiff.create();
            sub.workspace = this.workspace;
            functionDefinition.define(sub, inputs, null);
            this.sameDiffFunctionInstances.put(function, sub);
        }
    }

    public INDArray execAndEndResult(String functionName) {
        return this.sameDiffFunctionInstances.get(functionName).execAndEndResult();
    }

    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec(String functionName) {
        Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> ret = this.debugMode ? this.sameDiffFunctionInstances.get(functionName).enableDebugMode().exec() : this.sameDiffFunctionInstances.get(functionName).exec();
        this.associateSameDiffWithOpsAndVariables();
        return ret;
    }

    public List<DifferentialFunction> exec(String functionName, List<DifferentialFunction> cachedOps) {
        return this.sameDiffFunctionInstances.get(functionName).exec(cachedOps);
    }

    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> execBackwards() {
        if (this.getFunction("grad") == null) {
            this.createGradFunction();
        }
        if (log.isTraceEnabled()) {
            log.trace("About to execute backward function");
        }
        Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> forward = this.exec("grad");
        SameDiff grad = this.getFunction("grad");
        if (grad.isDebugMode()) {
            for (SDVariable sdVariable : grad.variables()) {
                sdVariable.gradient();
            }
        }
        return forward;
    }

    public void createGradFunction() {
        if (log.isTraceEnabled()) {
            log.trace("Defining function \"grad\"");
        }
        final SameDiff outer = this;
        this.defineFunction("grad", new SameDiffFunctionDefinition(){

            @Override
            public SDVariable[] define(SameDiff sameDiff, Map<String, INDArray> inputs, SDVariable[] variableInputs) {
                ArrayList allFunctions;
                if (SameDiff.this.debugMode) {
                    sameDiff.enableDebugMode();
                }
                outer.invokeGraphOn(sameDiff);
                if (SameDiff.this.debugMode) {
                    Preconditions.checkState((boolean)sameDiff.incomingArgsReverse.keySet().equals(SameDiff.this.incomingArgsReverse.keySet()), (String)"incomingArgsReverse keysets not equal");
                    Preconditions.checkState((boolean)sameDiff.outgoingArgsReverse.keySet().equals(SameDiff.this.outgoingArgsReverse.keySet()), (String)"outgoingArgsReverse keysets not equal");
                }
                if ((allFunctions = new ArrayList(sameDiff.functionInstancesById.values())).isEmpty()) {
                    throw new ND4JIllegalStateException("No ops found!");
                }
                for (DifferentialFunction func : allFunctions) {
                    SDVariable[] outputs;
                    SDVariable[] args;
                    if (func instanceof SDVariable) continue;
                    for (SDVariable arg : args = func.args()) {
                        arg.setSameDiff(sameDiff);
                    }
                    for (SDVariable output : outputs = func.outputVariables()) {
                        output.setSameDiff(sameDiff);
                    }
                    func.setSameDiff(sameDiff);
                }
                SDVariable[] initialOuts = ((DifferentialFunction)allFunctions.get(allFunctions.size() - 1)).outputVariables();
                SDVariable firstBackward = initialOuts[0];
                if (log.isTraceEnabled()) {
                    Object[] initialOutputsStr = ((DifferentialFunction)allFunctions.get(allFunctions.size() - 1)).outputVariablesNames();
                    String s = initialOutputsStr == null ? "null" : Arrays.toString(initialOutputsStr);
                    log.trace("Defining backward function: initial outputs {}", (Object)s);
                }
                SDVariable initialGrad = sameDiff.var("one-var", Nd4j.trueScalar(1.0));
                sameDiff.forwardVarForGrad.put(firstBackward.getVarName(), initialGrad);
                sameDiff.gradients.put(firstBackward.getVarName(), initialGrad);
                SDVariable gradientBackwardsMarker = sameDiff.gradientBackwardsMarker(firstBackward);
                allFunctions = new ArrayList(sameDiff.functionInstancesById.values());
                Collections.reverse(allFunctions);
                for (int i = 0; i < allFunctions.size(); ++i) {
                    SDVariable[] args;
                    DifferentialFunction action = (DifferentialFunction)allFunctions.get(i);
                    if (log.isTraceEnabled()) {
                        log.trace("Defining backward function step {} of {}: {} ({}) - {}", new Object[]{i + 1, allFunctions.size(), action.opName(), action.getOwnName(), action.getClass().getName()});
                    }
                    if (action instanceof GradientBackwardsMarker) continue;
                    DifferentialFunction currFunction = action;
                    Preconditions.checkState((currFunction.getSameDiff() == sameDiff ? 1 : 0) != 0, (String)"Wrong samediff instance found!");
                    for (SDVariable arg : args = currFunction.outputVariables()) {
                        if (arg.getSameDiff() == sameDiff) continue;
                        arg.setSameDiff(sameDiff);
                    }
                    ArrayList<SDVariable> grads = new ArrayList<SDVariable>();
                    for (SDVariable varToGrad : args) {
                        SDVariable grad = varToGrad.gradient();
                        if (grad == null) {
                            throw new ND4JIllegalStateException("No gradient found for " + varToGrad.getVarName());
                        }
                        grads.add(grad);
                    }
                    List<SDVariable> currFnGrads = currFunction.diff(grads);
                    if (log.isTraceEnabled()) {
                        log.trace("Finished Defining backward function step {} of {}: {} ({}) - {}", new Object[]{i + 1, allFunctions.size(), action.opName(), action.getOwnName(), action.getClass().getName()});
                    }
                    if (!SameDiff.this.debugMode) continue;
                    Preconditions.checkState((boolean)sameDiff.incomingArgsReverse.keySet().equals(sameDiff.outgoingArgsReverse.keySet()), (String)"incomingArgsReverse and outgoingArgsReverse keysets not equal after backprop of function %s of %s: %s (%s)", (Object)(i + 1), (Object)allFunctions.size(), (Object)action.getOwnName(), (Object)action.getClass().getName());
                }
                if (sameDiff.isDebugMode()) {
                    for (SDVariable sdVariable : SameDiff.this.variables()) {
                        sdVariable.gradient();
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("Defining backward function complete");
                }
                return new SDVariable[]{sameDiff.var("grad", 1, 1)};
            }
        });
    }

    public INDArray execBackwardAndEndResult() {
        List backwards = (List)this.execBackwards().getRight();
        DifferentialFunction df = (DifferentialFunction)backwards.get(backwards.size() - 1);
        if (df instanceof Op) {
            return ((Op)((Object)df)).z();
        }
        if (df instanceof DynamicCustomOp) {
            return ((DynamicCustomOp)df).getOutputArgument(0);
        }
        return null;
    }

    public INDArray execWithPlaceHolderAndEndResult(Map<String, INDArray> inputs) {
        this.resolveVariablesWith(inputs);
        return this.execAndEndResult();
    }

    public void setOriginalPlaceHolderShape(String variableName, long[] shape) {
        if (!this.isPlaceHolder(variableName)) {
            throw new ND4JIllegalStateException("Vertex id " + variableName + " does not appear to be a place holder. Did you forget to call addPlaceHolder?");
        }
        if (shape == null) {
            throw new ND4JIllegalStateException("Null and 0 length shape arrays not allowed");
        }
        if (this.placeHolderOriginalShapes.containsKey(variableName) && !Arrays.equals(this.placeHolderOriginalShapes.get(variableName), shape)) {
            throw new ND4JIllegalStateException("Unable to add a new shape for vertex id " + variableName);
        }
        this.placeHolderOriginalShapes.put(variableName, shape);
    }

    public long[] getOriginalShapeForPlaceHolder(String varName) {
        return this.placeHolderOriginalShapes.get(varName);
    }

    public boolean isPlaceHolder(String varName) {
        return this.placeHolderVarNames.contains(varName);
    }

    public void addAsPlaceHolder(String varName) {
        this.placeHolderVarNames.add(varName);
        if (this.getVariable(varName) != null && this.getVariable(varName).getShape() != null) {
            this.placeHolderOriginalShapes.put(varName, this.getVariable(varName).getShape());
        }
    }

    public void resolveVariablesWith(Map<String, INDArray> arrays) {
        for (Map.Entry<String, INDArray> arrayEntry : arrays.entrySet()) {
            long[] originalShape;
            SDVariable varForName = this.getVariable(arrayEntry.getKey());
            if (varForName == null) {
                throw new ND4JIllegalStateException("No variable name found for " + arrayEntry.getKey());
            }
            if (!this.placeHolderOriginalShapes.containsKey(arrayEntry.getKey()) || (originalShape = this.placeHolderOriginalShapes.get(arrayEntry.getKey())).length != arrayEntry.getValue().rank()) continue;
            for (int i = 0; i < originalShape.length; ++i) {
                if (originalShape[i] == arrayEntry.getValue().shape()[i] || originalShape[i] < 1L) continue;
                throw new ND4JIllegalStateException("Incompatible shape passed for variable. " + Arrays.toString(arrayEntry.getValue().shape()));
            }
        }
        for (Map.Entry<String, INDArray> entry : arrays.entrySet()) {
            if (!this.placeHolderVarNames.contains(entry.getKey())) {
                throw new ND4JIllegalStateException("Illegal variable " + entry.getKey() + " passed in. Variable found not to be a place holder variable");
            }
            long[] specifiedShape = this.getOriginalShapeForPlaceHolder(entry.getKey());
            if (!Shape.isPlaceholderShape(specifiedShape) && !Shape.shapeEquals(specifiedShape, entry.getValue().shape())) {
                throw new ND4JIllegalStateException("Place holder shape specified was " + Arrays.toString(specifiedShape) + " but array shape was " + Arrays.toString(entry.getValue().shape()));
            }
            this.updateShapeForVarName(entry.getKey(), entry.getValue().shape());
            this.associateArrayWithVariable(entry.getValue(), this.getVariable(entry.getKey()));
            this.updateArrayForVarName(entry.getKey(), entry.getValue());
        }
        for (String funcName : this.propertiesToResolve.keySet()) {
            DifferentialFunction func = this.functionInstancesById.get(funcName);
            if (!this.functionInstancesById.containsKey(funcName)) {
                throw new ND4JIllegalStateException("Unable to resolve function name " + funcName);
            }
            if (!(func instanceof CustomOp)) continue;
            CustomOp customOp = (CustomOp)((Object)func);
            customOp.populateInputsAndOutputsFromSameDiff();
        }
        this.resolvedVariables = true;
    }

    public boolean allPlaceHolderVariablesResolved() {
        for (String vertexId : this.placeHolderVarNames) {
            SDVariable var = this.getVariable(vertexId);
            if (var.getArr() != null) continue;
            return false;
        }
        return true;
    }

    public void putPlaceHolderForVariable(String varName, String ... placeHolderVariables) {
        for (String placeHolderVariable : placeHolderVariables) {
            if (this.variableMap.containsKey(placeHolderVariable)) continue;
            throw new ND4JIllegalStateException("No variable found for " + placeHolderVariable);
        }
        List<String[]> placeHolders = this.placeHolderMap.get(varName);
        if (placeHolders == null) {
            placeHolders = new ArrayList<String[]>();
            this.placeHolderMap.put(varName, placeHolders);
        }
        placeHolders.add(placeHolderVariables);
    }

    public boolean hasPlaceHolderVariables(String vertexId) {
        return this.placeHolderMap.containsKey(vertexId);
    }

    public List<String[]> getPlaceHoldersFor(String varName) {
        return this.placeHolderMap.get(varName);
    }

    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> execWithPlaceHolder(Map<String, INDArray> inputs) {
        this.resolveVariablesWith(inputs);
        return this.exec();
    }

    public List<SDVariable> getVariablesAssociatedWithFunctions(List<DifferentialFunction> functions) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>(functions.size());
        for (DifferentialFunction function : functions) {
            ret.addAll(Arrays.asList(function.outputVariables()));
        }
        return ret;
    }

    public SDVariable updateVariableNameAndReference(SDVariable varToUpdate, String newVarName) {
        if (varToUpdate == null) {
            throw new NullPointerException("Null input: No variable found for updating!");
        }
        if (newVarName != null && this.variableMap.containsKey(newVarName) && varToUpdate != this.variableMap.get(newVarName)) {
            throw new IllegalStateException("Variable name \"" + newVarName + "\" already exists for a different SDVariable");
        }
        if (newVarName == null && this.variableMap.containsKey(varToUpdate.getVarName())) {
            newVarName = this.generateNewVarName(varToUpdate.getVarName(), 0);
        }
        if (newVarName == null || varToUpdate.getVarName().equals(newVarName)) {
            return varToUpdate;
        }
        String oldVarName = varToUpdate.getVarName();
        varToUpdate.setVarName(newVarName);
        this.updateVariableName(oldVarName, newVarName);
        return varToUpdate;
    }

    public SDVariable[] updateVariableNamesAndReferences(SDVariable[] variablesToUpdate, String[] newVariableNames) {
        int numVariables = variablesToUpdate.length;
        SDVariable[] updatedVariables = new SDVariable[numVariables];
        for (int i = 0; i < numVariables; ++i) {
            SDVariable varToUpdate = variablesToUpdate[i];
            String name = newVariableNames == null ? null : newVariableNames[i];
            updatedVariables[i] = this.updateVariableNameAndReference(varToUpdate, name);
        }
        return updatedVariables;
    }

    protected void associateSameDiffWithOpsAndVariables() {
        for (DifferentialFunction df : this.functionInstancesById.values()) {
            SDVariable[] outputs;
            df.setSameDiff(this);
            SDVariable[] args = df.args();
            if (args != null) {
                for (SDVariable arg : args) {
                    arg.setSameDiff(this);
                }
            }
            if ((outputs = df.outputVariables()) == null) continue;
            for (SDVariable out : outputs) {
                out.setSameDiff(this);
            }
        }
        for (SDVariable var : this.variableMap.values()) {
            var.setSameDiff(this);
        }
    }

    public void clearExecutionCache() {
        this.exec_cache = null;
    }

    /*
     * WARNING - void declaration
     */
    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec() {
        Pair ret;
        if (log.isTraceEnabled()) {
            log.trace("Starting execution: {} functions", (Object)this.functionInstancesById.size());
        }
        if (!this.resolvedVariables) {
            this.resolveVariablesWith(new LinkedHashMap<String, INDArray>());
        }
        ArrayList<DifferentialFunction> ops = new ArrayList<DifferentialFunction>();
        this.localFlowPath.set(new FlowPath());
        FlowPath flowPath = this.localFlowPath.get();
        HashMap opMap = new HashMap();
        ArrayList<DifferentialFunction> funcs = new ArrayList<DifferentialFunction>(this.functionInstancesById.values());
        ArrayList<String> funcNames = new ArrayList<String>(this.functionInstancesById.keySet());
        boolean onBackward = false;
        ArrayDeque<String> frames = new ArrayDeque<String>();
        boolean inFrame = false;
        boolean frameLeft = false;
        boolean isExecBackwards = this.functionInstancesById.containsKey("gradientbackwards");
        this.associateSameDiffWithOpsAndVariables();
        int exec_counter = 0;
        for (int i = 0; i < funcs.size(); ++i) {
            Object list;
            Object name;
            boolean shouldSkip;
            String ownName;
            DifferentialFunction differentialFunction;
            String opName;
            Object[] args;
            block124: {
                block123: {
                    ++exec_counter;
                    if (log.isTraceEnabled()) {
                        DifferentialFunction f = funcs.get(i);
                        Object[] argNames = f.argNames();
                        Object[] outNames = f.outputVariablesNames();
                        log.trace("Starting execution of step {} of {}: Function {} (ownName={}) - {}", new Object[]{exec_counter, funcs.size(), f.opName(), f.getOwnName(), f.getClass().getName()});
                        log.trace("Function inputs: {} - Function outputs: {}", (Object)(argNames == null ? "(none)" : Arrays.toString(argNames)), (Object)(outNames == null ? "(none)" : Arrays.toString(outNames)));
                        args = f.args();
                        for (int arg = 0; arg < args.length; ++arg) {
                            if (args[arg] == null) {
                                log.trace("--> arg {} - {}: argument is null!", (Object)arg, argNames[arg]);
                                continue;
                            }
                            INDArray iNDArray = ((SDVariable)args[arg]).getArr();
                            String arrShape = iNDArray == null ? "<array not present>" : Arrays.toString(iNDArray.shape());
                            log.trace("--> arg {} - {}: array shape: {}", new Object[]{arg, argNames[arg], arrShape});
                        }
                    }
                    opName = funcs.get(i).opName();
                    if (!onBackward && "gradientbackwards".equals(opName)) {
                        onBackward = true;
                    }
                    if ("gradientbackwards".equals(opName)) continue;
                    differentialFunction = funcs.get(i);
                    if (differentialFunction instanceof ExternalErrorsFunction) {
                        if (!isExecBackwards) continue;
                        ((ExternalErrorsFunction)differentialFunction).updateBeforeExecution();
                        continue;
                    }
                    ownName = differentialFunction.getOwnName();
                    flowPath.ensureNodeStateExists(differentialFunction.getOwnName());
                    if (differentialFunction instanceof SDVariable) {
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Skipping differentialFunction that is instanceof SDVariable: {}", (Object)opName);
                        continue;
                    }
                    args = this.getInputsForFunction(differentialFunction);
                    log.debug("Step: {}; Executing op [{}] for node [{}]", new Object[]{exec_counter, opName, ownName});
                    shouldSkip = false;
                    if (!(differentialFunction instanceof Merge)) break block123;
                    Object object = args[0];
                    Object arg1 = args[1];
                    if (flowPath.isActive((String)object) || flowPath.isActive((String)arg1)) break block124;
                    shouldSkip = true;
                    break block124;
                }
                if (!(differentialFunction instanceof Exit)) {
                    if (frameLeft) {
                        frameLeft = false;
                        String string = (String)frames.removeLast();
                        flowPath.activateFrame(string, false);
                        flowPath.forgetFrame(string);
                    }
                    for (Object input : args) {
                        if (flowPath.isActive((String)input)) continue;
                        flowPath.markActive(differentialFunction.getOwnName(), false);
                        shouldSkip = true;
                        break;
                    }
                }
            }
            if (shouldSkip) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Skipping function {}: shouldSkip = true", (Object)opName);
                continue;
            }
            differentialFunction.resolvePropertiesFromSameDiffBeforeExecution();
            flowPath.markActive(differentialFunction.getOwnName(), true);
            if (differentialFunction instanceof LoopCond) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of LoopCond op");
                }
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                INDArray array = sDVariableArray[0].getArr();
                this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                if ((int)array.getDouble(0L) == 1) {
                    String frameName = (String)frames.getLast();
                    flowPath.incrementNumberOfCycles(frameName);
                }
            } else if (differentialFunction instanceof Enter) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of Enter op");
                }
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                INDArray array = sDVariableArray[0].getArr();
                String name2 = sDVariableArray[0].getVarName();
                if (array != null) {
                    this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                } else {
                    String cleansed2 = name2.replaceAll(":.*", "");
                    TensorList tensorList = this.lists.get(cleansed2);
                    if (tensorList != null) {
                        this.lists.put(ownName, tensorList);
                    }
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                String frame_name2 = ((Enter)differentialFunction).getFrameName();
                if (!flowPath.isRegisteredFrame(frame_name2)) {
                    flowPath.registerFrame(frame_name2);
                    frames.addLast(frame_name2);
                    inFrame = true;
                }
            } else if (differentialFunction instanceof Exit) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of Exit op");
                }
                String string = (String)frames.getLast();
                ((Exit)differentialFunction).setFrameName(string);
                if (!flowPath.isFrameActive(string)) {
                    flowPath.markActive(differentialFunction.getOwnName(), false);
                    frameLeft = true;
                    continue;
                }
                if (flowPath.isRewindPlanned(string)) {
                    flowPath.planRewind(string, false);
                    int currentPosition = i;
                    i = flowPath.getRewindPosition(string);
                    int startPosition = i + 1;
                    flowPath.setRewindPosition(string, -1);
                    continue;
                }
                SDVariable[] inputs2 = this.getInputVariablesForFunction(differentialFunction);
                INDArray array = inputs2[0].getArr();
                name = inputs2[0].getVarName();
                if (array != null) {
                    this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                } else {
                    String string2 = ((String)name).replaceAll(":.*", "");
                    list = this.lists.get(string2);
                    if (list != null) {
                        this.lists.put(ownName, (TensorList)list);
                    }
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                frameLeft = true;
            } else if (differentialFunction instanceof NextIteration) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of NextIteration op");
                }
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                String frame_name3 = (String)frames.getLast();
                INDArray array = sDVariableArray[0].getArr();
                name = sDVariableArray[0].getVarName();
                if (array != null) {
                    this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                } else {
                    String string = ((String)name).replaceAll(":.*", "");
                    list = this.lists.get(string);
                    if (list != null) {
                        this.lists.put(ownName, (TensorList)list);
                    }
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                if (!flowPath.isRewindPlanned(frame_name3)) {
                    flowPath.planRewind(frame_name3, true);
                    continue;
                }
            } else if (differentialFunction instanceof Merge) {
                INDArray array;
                DifferentialFunction secondArg;
                String frame_name4;
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of Merge op");
                }
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                String string = frame_name4 = frames.size() > 0 ? (String)frames.getLast() : null;
                if (frame_name4 != null) {
                    flowPath.activateFrame(frame_name4, true);
                }
                if (frame_name4 != null) {
                    flowPath.setRewindPositionOnce(frame_name4, i - 1);
                }
                if (sDVariableArray.length == 2 && (secondArg = this.functionInstancesById.get(sDVariableArray[1].getVarName())) != null && secondArg instanceof NextIteration) {
                    ((NextIteration)secondArg).setFrameName(frame_name4);
                }
                if (flowPath.wasExecuted(sDVariableArray[1].getVarName())) {
                    array = sDVariableArray[1].getArr();
                    name = sDVariableArray[1].getVarName();
                    if (array != null) {
                        this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                    } else {
                        String string3 = ((String)name).replaceAll(":.*", "");
                        list = this.lists.get(string3);
                        if (list != null) {
                            this.lists.put(ownName, (TensorList)list);
                        }
                    }
                    flowPath.markExecuted(sDVariableArray[1].getVarName(), false);
                } else {
                    array = sDVariableArray[0].getArr();
                    name = sDVariableArray[0].getVarName();
                    if (array != null) {
                        this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                    } else {
                        String string4 = ((String)name).replaceAll(":.*", "");
                        list = this.lists.get(string4);
                        if (list != null) {
                            this.lists.put(ownName, (TensorList)list);
                        }
                    }
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
            } else if (differentialFunction instanceof Switch) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of Switch op");
                }
                ((CustomOp)((Object)differentialFunction)).populateInputsAndOutputsFromSameDiff();
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                INDArray input = sDVariableArray[0].getArr();
                INDArray bool = sDVariableArray[1].getArr();
                name = sDVariableArray[0].getVarName();
                if ((int)bool.getDouble(0L) == 0) {
                    flowPath.setActiveBranch(differentialFunction.getOwnName(), 0);
                    flowPath.markActive(differentialFunction.getOwnName(), true);
                    flowPath.markActive(differentialFunction.getOwnName() + ":1", false);
                    if (input != null) {
                        this.variableNameToArr.put(differentialFunction.getOwnName(), input.dup(input.ordering()));
                    } else {
                        String string = ((String)name).replaceAll(":.*", "");
                        list = this.lists.get(string);
                        if (list != null) {
                            this.lists.put(ownName, (TensorList)list);
                        }
                    }
                } else {
                    flowPath.setActiveBranch(differentialFunction.getOwnName(), 1);
                    if (input != null) {
                        this.variableNameToArr.put(differentialFunction.getOwnName() + ":1", input.dup(input.ordering()));
                    } else {
                        String string = ((String)name).replaceAll(":.*", "");
                        list = this.lists.get(string);
                        if (list != null) {
                            this.lists.put(ownName, (TensorList)list);
                        }
                    }
                    flowPath.markActive(differentialFunction.getOwnName(), false);
                    flowPath.markActive(differentialFunction.getOwnName() + ":1", true);
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
            } else if (differentialFunction instanceof BaseTensorOp) {
                log.info("Starting execution of Tensor op [{}]", (Object)opName);
                TensorList tensorList = ((BaseTensorOp)differentialFunction).execute(this);
                if (!this.lists.containsKey(tensorList.getName())) {
                    this.lists.put(tensorList.getName(), tensorList);
                }
                ops.add(differentialFunction);
            } else if (differentialFunction instanceof If) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of If op");
                }
                If if_ = (If)differentialFunction;
                if (!onBackward) {
                    if_.getPredicateExecution().exec();
                    if (if_.getTargetBoolean().getArr().sumNumber().doubleValue() > 0.0) {
                        if_.getLoopBodyExecution().exec();
                        if_.exectedTrueOrFalse(true);
                    } else {
                        if_.getFalseBodyExecution().exec();
                        if_.exectedTrueOrFalse(false);
                    }
                } else if (if_.getTrueBodyExecuted() != null) {
                    Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> execBackwards = null;
                    List<SDVariable> variablesForFunctions = null;
                    if (if_.getTrueBodyExecuted().booleanValue()) {
                        execBackwards = if_.getLoopBodyExecution().execBackwards();
                        variablesForFunctions = if_.getLoopBodyExecution().getVariablesAssociatedWithFunctions((List)execBackwards.getRight());
                    } else {
                        execBackwards = if_.getFalseBodyExecution().execBackwards();
                        variablesForFunctions = if_.getFalseBodyExecution().getVariablesAssociatedWithFunctions((List)execBackwards.getRight());
                    }
                    for (SDVariable sDVariable : variablesForFunctions) {
                        list = this.var(sDVariable);
                    }
                } else {
                    throw new ND4JIllegalStateException("No body was run.");
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                ops.add(differentialFunction);
            } else if (differentialFunction instanceof While) {
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of While op");
                }
                While while_ = (While)differentialFunction;
                if (!onBackward) {
                    SameDiff execBody = while_.getLoopBodyExecution();
                    while_.getPredicateExecution().exec();
                    if (execBody.outputs == null) {
                        while (while_.getTargetBoolean().getArr().sumNumber().doubleValue() > 0.0) {
                            execBody.exec();
                            while_.getPredicateExecution().exec();
                            while_.incrementLoopCounter();
                        }
                    } else {
                        if (while_.getTargetBoolean().getSameDiff().inputs == null) {
                            while_.getTargetBoolean().getSameDiff().inputs = new SDVariable[while_.getInputVars().length];
                            for (int e = 0; e < while_.getInputVars().length; ++e) {
                                while_.getTargetBoolean().getSameDiff().inputs[i] = while_.getTargetBoolean().getSameDiff().variables().get(i);
                            }
                        }
                        while (while_.getTargetBoolean().getArr().sumNumber().doubleValue() > 0.0) {
                            execBody.exec();
                            SDVariable[] outputs = execBody.outputs;
                            int cnt = 0;
                            for (SDVariable out : execBody.outputs) {
                                execBody.associateArrayWithVariable(out.getArr(), execBody.inputs[cnt]);
                                while_.getTargetBoolean().getSameDiff().associateArrayWithVariable(out.getArr(), while_.getTargetBoolean().getSameDiff().inputs[cnt++]);
                            }
                            while_.getPredicateExecution().exec();
                            while_.incrementLoopCounter();
                        }
                    }
                    ArrayList outputs = new ArrayList();
                    SDVariable[] outputFuncArgs = new ArrayList<DifferentialFunction>(execBody.functionInstancesById.values()).get(execBody.functionInstancesById.values().size() - 1).outputVariables();
                    outputs.addAll(Arrays.asList(outputFuncArgs));
                    while_.setOutputVars(outputs.toArray(new SDVariable[outputs.size()]));
                    ops.add(differentialFunction);
                } else {
                    Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> mapListPair = while_.getLoopBodyExecution().execBackwards();
                    for (SDVariable variable : ((Map)mapListPair.getFirst()).keySet()) {
                        variable.getArr().muli(while_.getNumLooped());
                    }
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
            } else if (differentialFunction instanceof CustomOp) {
                String cleansed3;
                TensorList list4;
                DynamicCustomOp dynamicCustomOp;
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of CustomOp op");
                }
                if ((dynamicCustomOp = (DynamicCustomOp)differentialFunction).opName().equalsIgnoreCase("identity") && (list4 = this.lists.get(cleansed3 = ((String)args[0]).replaceAll(":.*", ""))) != null) {
                    this.lists.put(ownName, list4);
                    flowPath.markExecuted(differentialFunction.getOwnName(), true);
                    ops.add(dynamicCustomOp);
                    continue;
                }
                try {
                    dynamicCustomOp.populateInputsAndOutputsFromSameDiff();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error populating inputs and outputs for function \"" + differentialFunction.getOwnName() + "\" of type " + differentialFunction.getClass().getName(), t);
                }
                dynamicCustomOp.assertValidForExecution();
                Nd4j.getExecutioner().exec(dynamicCustomOp);
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                ops.add(dynamicCustomOp);
            } else if (differentialFunction instanceof Op) {
                void var22_80;
                List<long[]> outputShape;
                if (log.isTraceEnabled()) {
                    log.trace("Starting execution of Op op");
                }
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                Op op = (Op)((Object)differentialFunction);
                String outVarName = ((BaseOp)op).outputVariable().getVarName();
                if (sDVariableArray != null && sDVariableArray.length > 0) {
                    op.setX(sDVariableArray[0].getArr());
                    if (sDVariableArray.length == 2) {
                        op.setY(sDVariableArray[1].getArr());
                    }
                }
                Preconditions.checkState(((outputShape = ((BaseOp)op).calculateOutputShape()) != null && outputShape.size() == 1 ? 1 : 0) != 0, (String)"Could not calculate output shape for op: %s", op.getClass());
                this.putOrUpdateShapeForVarName(outVarName, outputShape.get(0), true);
                INDArray iNDArray = op.z();
                Preconditions.checkNotNull((Object)iNDArray, (String)"Could not get output array for op: %s", op.getClass());
                if (!Arrays.equals(outputShape.get(0), iNDArray.shape())) {
                    if (log.isTraceEnabled()) {
                        log.trace("Existing op result (z) array shape for op {} was {}, allocating new array of shape {}", new Object[]{op.getClass().getSimpleName(), Arrays.toString(iNDArray.shape()), Arrays.toString(outputShape.get(0))});
                    }
                    String fnName = (String)funcNames.get(i);
                    String outputName = this.outgoingArgsReverse.get(fnName)[0];
                    SDVariable outputVar = this.getVariable(outputName);
                    this.putOrUpdateShapeForVarName(outputName, outputShape.get(0), true);
                    INDArray iNDArray2 = outputVar.storeAndAllocateNewArray();
                    op.setZ(iNDArray2);
                }
                if (this.getArrForVarName(outVarName) != var22_80) {
                    this.putOrUpdateArrayForVarName(outVarName, (INDArray)var22_80);
                }
                if (differentialFunction.getDimensions() == null) {
                    Nd4j.getExecutioner().exec(op);
                } else if (op.isExecSpecial()) {
                    op.exec();
                } else {
                    int[] axes = differentialFunction.getDimensions();
                    if (differentialFunction instanceof Accumulation) {
                        Accumulation accumulation = (Accumulation)((Object)differentialFunction);
                        Nd4j.getExecutioner().exec(accumulation, axes);
                        if (differentialFunction.outputVariable().getArr() == null) {
                            SDVariable var = differentialFunction.outputVariables()[0];
                            this.updateVariable(var.getVarName(), accumulation.z());
                            this.updateShapeForVarName(var.getVarName(), accumulation.z().shape());
                        }
                    } else if (differentialFunction instanceof BroadcastOp) {
                        BroadcastOp broadcastOp = (BroadcastOp)((Object)differentialFunction);
                        Nd4j.getExecutioner().exec(broadcastOp, axes);
                    } else if (differentialFunction instanceof GradientOp) {
                        Nd4j.getExecutioner().exec(op);
                    } else if (differentialFunction instanceof IndexAccumulation) {
                        IndexAccumulation indexAccumulation = (IndexAccumulation)((Object)differentialFunction);
                        Nd4j.getExecutioner().exec(indexAccumulation, axes);
                    } else if (differentialFunction instanceof TransformOp) {
                        TransformOp t = (TransformOp)((Object)differentialFunction);
                        Nd4j.getExecutioner().exec(t, axes);
                    }
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                ops.add(differentialFunction);
            } else {
                throw new IllegalStateException("Unknown function type: " + differentialFunction.getClass().getName());
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("Execution completed for DifferentialFunction {} - {}", (Object)opName, (Object)differentialFunction.getOwnName());
            SDVariable[] sDVariableArray = differentialFunction.outputVariables();
            for (int x = 0; x < sDVariableArray.length; ++x) {
                INDArray arr = sDVariableArray[x].getArr();
                String arrShape = arr == null ? "<no array>" : Arrays.toString(arr.shape());
                log.trace("--> output {} - {}: array shape {}", new Object[]{x, sDVariableArray[x].getVarName(), arrShape});
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Execution complete");
        }
        this.exec_cache = ret = new Pair(opMap, ops);
        if (this.parent != null) {
            this.parent.exec_cache = this.exec_cache;
        }
        return ret;
    }

    public void printFunction(DifferentialFunction differentialFunction) {
        if (!this.logExecution) {
            return;
        }
        if (differentialFunction instanceof SDVariable) {
            return;
        }
        StringBuilder argShapes = new StringBuilder();
        for (SDVariable arg : differentialFunction.args()) {
            argShapes.append(" Variable " + arg.getVarName() + " Shape for " + Arrays.toString(arg.getShape()));
        }
        for (SDVariable func : differentialFunction.outputVariables()) {
            argShapes.append("  Output variable " + func.getVarName() + " is " + Arrays.toString(func.getShape()));
        }
        StringBuilder realShapes = new StringBuilder();
        for (SDVariable arg : differentialFunction.args()) {
            realShapes.append(" Input shape for " + arg.getVarName() + " is  " + Arrays.toString(this.getShapeForVarName(arg.getVarName())));
        }
        for (SDVariable arg : differentialFunction.outputVariables()) {
            realShapes.append(" Output shape for " + arg.getVarName() + " is  " + Arrays.toString(this.getShapeForVarName(arg.getVarName())));
        }
    }

    public static int[] permuteDataFormatForSameDiff(String dataFormat, boolean weights) {
        int i;
        String dl4jFormat = "NCHW";
        dataFormat = dataFormat.toUpperCase();
        int[] ret = new int[4];
        if (weights) {
            ret[0] = dataFormat.indexOf(87);
            ret[1] = dataFormat.indexOf(67);
            ret[2] = dataFormat.indexOf(78);
            ret[3] = dataFormat.indexOf(72);
            return ret;
        }
        for (i = 0; i < dataFormat.length(); ++i) {
            if ("NCHW".indexOf(dataFormat.charAt(i)) >= 0) continue;
            throw new ND4JIllegalStateException("Illegal convolution data format string passed in " + dataFormat + " must be some variant of NCHW");
        }
        for (i = 0; i < "NCHW".length(); ++i) {
            ret[i] = "NCHW".indexOf(dataFormat.charAt(i));
        }
        return ret;
    }

    public void updateVariable(String variableName, INDArray arr) {
        if (!this.variableNameToArr.containsKey(variableName)) {
            this.putArrayForVarName(variableName, arr);
        } else {
            this.updateArrayForVarName(variableName, arr);
        }
    }

    protected int asFlatNode(String name, @NonNull SameDiff scope, @NonNull FlatBufferBuilder bufferBuilder) {
        if (scope == null) {
            throw new NullPointerException("scope is marked @NonNull but is null");
        }
        if (bufferBuilder == null) {
            throw new NullPointerException("bufferBuilder is marked @NonNull but is null");
        }
        int scopeName = bufferBuilder.createString(name);
        int flatNode = FlatNode.createFlatNode(bufferBuilder, scopeName, scopeName, (byte)119, 10L, 0, 0, 0, (byte)0, 0, 0, 0, 0, -1, 0.0f, 0, 0);
        return flatNode;
    }

    public static Pair<String, Integer> parseVariable(@NonNull String varName) {
        if (varName == null) {
            throw new NullPointerException("varName is marked @NonNull but is null");
        }
        if (!varName.contains(":")) {
            return Pair.pairOf((Object)varName, (Object)0);
        }
        String[] split = varName.split(":");
        Integer index = Integer.valueOf(split[split.length - 1]);
        if (split.length == 2) {
            return Pair.pairOf((Object)split[0], (Object)index);
        }
        StringBuilder builder = new StringBuilder();
        for (int e = 0; e < split.length - 1; ++e) {
            builder.append(split[e]);
            if (e >= split.length - 2) continue;
            builder.append(":");
        }
        return Pair.pairOf((Object)builder.toString(), (Object)index);
    }

    protected int asFlatNode(@NonNull DifferentialFunction node, @NonNull FlatBufferBuilder bufferBuilder, List<SDVariable> variables, Map<String, Integer> reverseMap, Map<String, Integer> forwardMap, Map<String, Integer> framesMap, AtomicInteger idCounter) {
        if (node == null) {
            throw new NullPointerException("node is marked @NonNull but is null");
        }
        if (bufferBuilder == null) {
            throw new NullPointerException("bufferBuilder is marked @NonNull but is null");
        }
        String opName = node.opName();
        long hash = SameDiff.getOpNum(node.opName(), node.opType());
        double[] extras = node.getExtraArgs() != null ? new double[node.getExtraArgs().length] : new double[]{};
        for (int e = 0; e < extras.length; ++e) {
            extras[e] = ((Number)node.getExtraArgs()[e]).doubleValue();
        }
        long[] extraBits = null;
        if (node.opType() == Op.Type.CUSTOM) {
            DynamicCustomOp dynamicCustomOp = (DynamicCustomOp)node;
            extraBits = dynamicCustomOp.iArgs();
        } else if (node instanceof Enter) {
            String frameName = ((Enter)node).getFrameName();
            if (!framesMap.containsKey(frameName)) {
                framesMap.put(frameName, idCounter.incrementAndGet());
            }
            extraBits = new long[]{framesMap.get(frameName).intValue()};
        } else {
            extraBits = new long[]{};
        }
        ArrayList<Integer> inPaired = new ArrayList<Integer>();
        int[] outputIds = null;
        SDVariable[] outputVertexId = null;
        try {
            outputVertexId = node.outputVariables();
            outputIds = new int[outputVertexId.length];
            for (int i = 0; i < outputIds.length; ++i) {
                outputIds[i] = variables.indexOf(outputVertexId[i]);
            }
        }
        catch (ND4UnresolvedOutputVariables e) {
            outputIds = new int[]{};
            outputVertexId = null;
        }
        catch (Exception e) {
            throw new ND4JIllegalStateException(e);
        }
        SDVariable[] inputs = node.args();
        log.trace("");
        for (SDVariable input : inputs) {
            Pair<String, Integer> pair = SameDiff.parseVariable(input.getVarName());
            if (!reverseMap.containsKey(pair.getFirst())) {
                if (((String)pair.getFirst()).contains("NextIteration")) {
                    int fwdNodeId = idCounter.incrementAndGet();
                    forwardMap.put((String)pair.getFirst(), fwdNodeId);
                    reverseMap.put((String)pair.getFirst(), fwdNodeId);
                } else {
                    throw new ND4JIllegalStateException("Unknown variable used in input: [" + (String)pair.getFirst() + "]");
                }
            }
            int nodeId = reverseMap.get(pair.getFirst());
            int outputIndex = (Integer)pair.getSecond();
            inPaired.add(IntPair.createIntPair(bufferBuilder, nodeId, outputIndex));
        }
        log.debug("Own Name: {}", (Object)node.getOwnName());
        int ownId = forwardMap.containsKey(node.getOwnName()) ? forwardMap.get(node.getOwnName()).intValue() : idCounter.incrementAndGet();
        reverseMap.put(node.getOwnName(), ownId);
        int[] dims = node.opType() == Op.Type.REDUCE && node.getDimensions() != null ? node.getDimensions() : new int[]{};
        ArrayList<FunctionProperties> props = new ArrayList<FunctionProperties>();
        int properties = FunctionProperties.asFlatProperties(bufferBuilder, props);
        int nodesIn = FlatNode.createInputVector(bufferBuilder, new int[0]);
        int nodesInPaired = FlatNode.createInputPairedVector(bufferBuilder, Ints.toArray(inPaired));
        int nodesOut = FlatNode.createOutputVector(bufferBuilder, outputIds);
        int extraz = FlatNode.createExtraParamsVector(bufferBuilder, extras);
        int integerArgs = FlatNode.createExtraIntegerVector(bufferBuilder, extraBits);
        int dimensions = FlatNode.createDimensionsVector(bufferBuilder, dims);
        int fname = bufferBuilder.createString(outputVertexId == null || outputVertexId.length < 1 || outputVertexId[0] == null ? "" : outputVertexId[0].getVarName());
        int scopeName = bufferBuilder.createString("");
        if (node.opType() == null) {
            log.warn("Null-op node: {}", (Object)node);
        }
        int flatNode = FlatNode.createFlatNode(bufferBuilder, ownId, fname, SameDiff.getFlatOpType(node.opType()), hash, properties, nodesIn, nodesInPaired, (byte)0, nodesOut, extraz, integerArgs, dimensions, -1, node.opType() == Op.Type.SCALAR && node.getScalarValue() != null ? node.getScalarValue().floatValue() : 0.0f, 0, scopeName);
        return flatNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer asFlatBuffers(@NonNull ExecutorConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
        Nd4j.getExecutioner().commit();
        FlatBufferBuilder bufferBuilder = new FlatBufferBuilder(1024);
        AtomicInteger idCounter = new AtomicInteger(0);
        ArrayList<Integer> flatVariables = new ArrayList<Integer>();
        ArrayList flatOffsets = new ArrayList();
        ArrayList<Integer> flatNodes = new ArrayList<Integer>();
        ArrayList<SDVariable> variableList = new ArrayList<SDVariable>(this.variables());
        LinkedHashMap<String, Integer> reverseMap = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> forwardMap = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> framesMap = new LinkedHashMap<String, Integer>();
        int idx = 0;
        for (SDVariable sDVariable : this.variables()) {
            log.debug("Exporting variable: [{}]", (Object)sDVariable.getVarName());
            if (sDVariable.getArr() == null || sDVariable.getShape() == null) continue;
            Pair<String, Integer> pair = SameDiff.parseVariable(sDVariable.getVarName());
            reverseMap.put((String)pair.getFirst(), idCounter.incrementAndGet());
            log.debug("Adding [{}] as [{}]", pair.getFirst(), (Object)idCounter.get());
            Iterator<DifferentialFunction> arr = sDVariable.getArr();
            int name = bufferBuilder.createString(sDVariable.getVarName());
            int array = arr.toFlatArray(bufferBuilder);
            int id = IntPair.createIntPair(bufferBuilder, idCounter.get(), 0);
            int flatVariable = FlatVariable.createFlatVariable(bufferBuilder, id, name, 0, array, -1);
            flatVariables.add(flatVariable);
        }
        for (DifferentialFunction differentialFunction : this.functionInstancesById.values()) {
            flatNodes.add(this.asFlatNode(differentialFunction, bufferBuilder, variableList, reverseMap, forwardMap, framesMap, idCounter));
        }
        for (Map.Entry entry : this.sameDiffFunctionInstances.entrySet()) {
            flatNodes.add(this.asFlatNode((String)entry.getKey(), (SameDiff)entry.getValue(), bufferBuilder));
            ArrayList<SDVariable> currVarList = new ArrayList<SDVariable>(((SameDiff)entry.getValue()).variables());
            for (SDVariable node : ((SameDiff)entry.getValue()).variables()) {
                INDArray arr = node.getArr();
                if (arr == null) continue;
                int name = bufferBuilder.createString(node.getVarName());
                int array = arr.toFlatArray(bufferBuilder);
                int id = IntPair.createIntPair(bufferBuilder, ++idx, 0);
                Pair<String, Integer> pair = SameDiff.parseVariable(node.getVarName());
                reverseMap.put((String)pair.getFirst(), idx);
                log.debug("Adding [{}] as [{}]", pair.getFirst(), (Object)idx);
                int flatVariable = FlatVariable.createFlatVariable(bufferBuilder, id, name, 0, array, -1);
                flatVariables.add(flatVariable);
            }
            for (DifferentialFunction func : ((SameDiff)entry.getValue()).functionInstancesById.values()) {
                flatNodes.add(this.asFlatNode(func, bufferBuilder, currVarList, reverseMap, forwardMap, framesMap, idCounter));
            }
        }
        int outputsOffset = FlatGraph.createVariablesVector(bufferBuilder, Ints.toArray(flatOffsets));
        int n = FlatGraph.createVariablesVector(bufferBuilder, Ints.toArray(flatVariables));
        int nodesOffset = FlatGraph.createNodesVector(bufferBuilder, Ints.toArray(flatNodes));
        int fg = FlatGraph.createFlatGraph(bufferBuilder, 119L, n, nodesOffset, outputsOffset, configuration.getFlatConfiguration(bufferBuilder));
        bufferBuilder.finish(fg);
        SameDiff sameDiff = this;
        synchronized (sameDiff) {
            if (this.reverseMap == null) {
                this.reverseMap = reverseMap;
            }
        }
        return bufferBuilder.dataBuffer();
    }

    public ByteBuffer asFlatBuffers() {
        ExecutorConfiguration configuration = ExecutorConfiguration.builder().outputMode(OutputMode.VARIABLE_SPACE).executionMode(ExecutionMode.SEQUENTIAL).profilingMode(OpExecutioner.ProfilingMode.DISABLED).gatherTimings(true).build();
        return this.asFlatBuffers(configuration);
    }

    public static ByteOrder getOrderFromByte(byte val) {
        if (val == 0) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    public static byte getOrderAsByte() {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return 1;
        }
        return 0;
    }

    public void asFlatFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        ByteBuffer fb = this.asFlatBuffers();
        int offset = fb.position();
        byte[] array = fb.array();
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(bos);){
            dos.write(array, offset, array.length - offset);
        }
    }

    public void asFlatFile(@NonNull File file, @NonNull ExecutorConfiguration configuration) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
        ByteBuffer fb = this.asFlatBuffers(configuration);
        int offset = fb.position();
        byte[] array = fb.array();
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(bos);){
            dos.write(array, offset, array.length - offset);
        }
    }

    public String asFlatPrint() {
        StringBuilder sb = new StringBuilder();
        ByteBuffer fb = this.asFlatBuffers();
        FlatGraph graph = FlatGraph.getRootAsFlatGraph(fb);
        sb.append("\nExternal variables:\n\n");
        for (int e = 0; e < graph.variablesLength(); ++e) {
            FlatVariable var = graph.variables(e);
            INDArray ndarray = Nd4j.createFromFlatArray(var.ndarray());
            sb.append(var.id().first()).append(":<").append(var.name()).append("> ").append(Arrays.toString(ndarray.shapeInfoDataBuffer().asInt())).append("; Values: ").append(Arrays.toString(ndarray.data().asFloat())).append(";\n");
        }
        Map<String, CustomOpDescriptor> map = Nd4j.getExecutioner().getCustomOperations();
        sb.append("\nOps sequence:\n\n");
        for (int e = 0; e < graph.nodesLength(); ++e) {
            FlatNode node = graph.nodes(e);
            log.info("{}:<{}>", (Object)node.id(), (Object)node.name());
            sb.append(node.id()).append(":<").append(node.name()).append("> ").append((Object)SameDiff.getTypeFromByte(node.opType()));
            if (SameDiff.getTypeFromByte(node.opType()) != Op.Type.CUSTOM) {
                sb.append(": ").append(node.opNum());
            } else {
                Set<String> keys = map.keySet();
                String opName = null;
                for (String k : keys) {
                    CustomOpDescriptor d = map.get(k);
                    if (d.getHash() != node.opNum()) continue;
                    opName = k;
                }
                if (opName == null) {
                    opName = "unknown";
                }
                sb.append(": ").append(opName);
            }
            sb.append("; Inputs: {");
            for (int i = 0; i < node.inputPairedLength(); ++i) {
                IntPair pair = node.inputPaired(i);
                sb.append("[").append(pair.first()).append(":").append(pair.second()).append("]");
                if (i >= node.inputPairedLength() - 1) continue;
                sb.append(", ");
            }
            sb.append("};");
            sb.append(" OpNum: {").append(node.opNum()).append("};");
            sb.append("\n");
        }
        return sb.toString();
    }

    public static DataBuffer.Type getDataTypeFromByte(byte val) {
        if (val == 5) {
            return DataBuffer.Type.FLOAT;
        }
        if (val == 6) {
            return DataBuffer.Type.DOUBLE;
        }
        if (val == 3) {
            return DataBuffer.Type.HALF;
        }
        throw new UnsupportedOperationException("Unsupported DataType: [" + val + "]");
    }

    public static byte getDataTypeAsByte(DataBuffer.Type type) {
        switch (type) {
            case FLOAT: {
                return 5;
            }
            case DOUBLE: {
                return 6;
            }
            case HALF: {
                return 3;
            }
            case INT: {
                return 9;
            }
            case LONG: {
                return 10;
            }
        }
        throw new ND4JIllegalStateException("Unknown or unsupported DataType used: [" + type + "]");
    }

    public static long getOpNum(String name, Op.Type type) {
        if (type == Op.Type.LOOP) {
            return 0L;
        }
        if (type == Op.Type.RETURN) {
            return 40L;
        }
        if (type == Op.Type.IF) {
            return 30L;
        }
        if (type == Op.Type.CONDITIONAL) {
            return 10L;
        }
        if (type == Op.Type.MERGE) {
            return 60L;
        }
        if (type == Op.Type.LOOP_COND) {
            return 70L;
        }
        if (type == Op.Type.NEXT_ITERATION) {
            return 80L;
        }
        if (type == Op.Type.EXIT) {
            return 90L;
        }
        if (type == Op.Type.ENTER) {
            return 100L;
        }
        if (type == Op.Type.CUSTOM) {
            CustomOpDescriptor name2 = Nd4j.getExecutioner().getCustomOperations().get(name.toLowerCase());
            if (name2 == null) {
                CustomOpDescriptor name3 = Nd4j.getExecutioner().getCustomOperations().get(name);
                if (name3 == null) {
                    return 0L;
                }
                return name3.getHash();
            }
            return name2.getHash();
        }
        return Nd4j.getOpFactory().getOpNumByName(name);
    }

    public static Op.Type getTypeFromByte(byte type) {
        switch (type) {
            case 3: {
                return Op.Type.SCALAR;
            }
            case 4: {
                return Op.Type.BROADCAST;
            }
            case 0: {
                return Op.Type.TRANSFORM;
            }
            case 1: {
                return Op.Type.REDUCE;
            }
            case 6: {
                return Op.Type.REDUCE3;
            }
            case 2: {
                return Op.Type.INDEXREDUCE;
            }
            case 10: {
                return Op.Type.RANDOM;
            }
            case 119: {
                return Op.Type.META;
            }
            case 11: {
                return Op.Type.CUSTOM;
            }
            case 8: {
                return Op.Type.SHAPE;
            }
            case 5: {
                return Op.Type.PAIRWISE;
            }
            case 7: {
                return Op.Type.SUMMARYSTATS;
            }
        }
        throw new UnsupportedOperationException("Unknown op type passed in: " + type);
    }

    public static byte getFlatOpType(Op.Type type) {
        switch (type) {
            case SCALAR: {
                return 3;
            }
            case BROADCAST: {
                return 4;
            }
            case TRANSFORM: 
            case SPECIAL: {
                return 0;
            }
            case REDUCE: {
                return 1;
            }
            case REDUCE3: {
                return 6;
            }
            case INDEXREDUCE: {
                return 2;
            }
            case RANDOM: {
                return 10;
            }
            case MERGE: 
            case CONDITIONAL: 
            case LOOP: 
            case RETURN: 
            case ENTER: 
            case EXIT: 
            case NEXT_ITERATION: 
            case LOOP_COND: 
            case IF: {
                return 119;
            }
            case CUSTOM: {
                return 11;
            }
            case SHAPE: {
                return 8;
            }
            case PAIRWISE: {
                return 5;
            }
            case SUMMARYSTATS: {
                return 7;
            }
        }
        throw new UnsupportedOperationException("Unknown op type passed in: " + (Object)((Object)type));
    }

    /*
     * WARNING - void declaration
     */
    public String summary() {
        void var15_24;
        Map<String, SDVariable> varMap = this.variableMap();
        DifferentialFunction[] functions = this.functions();
        int countVarsWithArrays = 0;
        for (String s : varMap.keySet()) {
            if (this.getArrForVarName(s) == null) continue;
            ++countVarsWithArrays;
        }
        StringBuilder sb = new StringBuilder();
        String format = "%-25s%-20s";
        sb.append("--- Summary ---\n");
        sb.append(String.format(format, "Variables:", varMap.size())).append(" (").append(countVarsWithArrays).append(" with arrays)").append("\n").append(String.format(format, "Functions:", functions.length)).append("\n").append(String.format(format, "SameDiff Function Defs:", this.sameDiffFunctionInstances.size())).append("\n\n");
        sb.append("--- Variables ---\n");
        HashMap<String, String> outputOfFn = new HashMap<String, String>();
        int maxLengthOutputOf = 22;
        int maxLengthOfName = 8;
        for (String s : varMap.keySet()) {
            String outputOf = null;
            for (Map.Entry<String, String[]> dfToArgs : this.outgoingArgsReverse.entrySet()) {
                if (dfToArgs.getValue() == null || !ArrayUtils.contains((Object[])dfToArgs.getValue(), (Object)s)) continue;
                outputOf = dfToArgs.getKey();
                break;
            }
            if (outputOf == null) {
                outputOf = "<none>";
            } else {
                DifferentialFunction d = this.getFunctionById(outputOf);
                outputOf = d.getOwnName() + "(" + d.opName() + ")";
            }
            outputOfFn.put(s, outputOf);
            maxLengthOutputOf = Math.max(maxLengthOutputOf, outputOf.length());
            maxLengthOfName = Math.max(maxLengthOfName, s.length());
        }
        format = "%-" + (maxLengthOfName += 2) + "s%-20s%-" + (maxLengthOutputOf += 2) + "s%-20s";
        sb.append(String.format(format, "- Name -", "- Array Shape -", "- Output Of Function -", "- Inputs To Functions -")).append("\n");
        for (String s : varMap.keySet()) {
            INDArray arr = this.getArrForVarName(s);
            String arrayShape = "-";
            if (arr != null) {
                arrayShape = Arrays.toString(arr.shape());
            }
            List<DifferentialFunction> dfs = this.functionsArgsFor.get(s);
            String dfArrStr = "";
            if (dfs != null) {
                Object[] objectArray = new String[dfs.size()];
                for (int i = 0; i < dfs.size(); ++i) {
                    objectArray[i] = dfs.get(i).getOwnName();
                }
                dfArrStr = Arrays.toString(objectArray);
            }
            String string = (String)outputOfFn.get(s);
            sb.append(String.format(format, s, arrayShape, string, dfArrStr)).append("\n");
        }
        sb.append("\n\n--- Functions ---\n");
        ArrayList<String> dfInputStr = new ArrayList<String>();
        ArrayList<String> dfOutputStr = new ArrayList<String>();
        int maxInLength = 10;
        int maxOutLength = 11;
        int maxOpNameLength = 17;
        int maxDfClassNameLength = 10;
        for (DifferentialFunction df : functions) {
            Object[] argNames = df.argNames();
            Object[] outNames = df.outputVariablesNames();
            String argStr = Arrays.toString(argNames);
            String outStr = Arrays.toString(outNames);
            maxInLength = Math.max(maxInLength, argStr.length());
            maxOutLength = Math.max(maxOutLength, outStr.length());
            dfInputStr.add(argStr);
            dfOutputStr.add(outStr);
            String name = df.getOwnName() == null ? df.opName() : df.getOwnName();
            maxOpNameLength = Math.max(maxOpNameLength, name.length());
            maxDfClassNameLength = Math.max(maxDfClassNameLength, df.getClass().getSimpleName().length());
        }
        format = "%-5s%-" + (maxOpNameLength += 2) + "s%-" + (maxDfClassNameLength += 2) + "s%-" + (maxInLength += 2) + "s%-" + (maxOutLength += 2) + "s";
        sb.append(String.format(format, "", "- Function Name -", "- Op -", "- Inputs -", "- Outputs -")).append("\n");
        boolean bl = false;
        while (var15_24 < functions.length) {
            DifferentialFunction df = functions[var15_24];
            String fnName = df.getOwnName() == null ? df.opName() : df.getOwnName();
            sb.append(String.format(format, String.valueOf((int)var15_24), fnName, df.getClass().getSimpleName(), dfInputStr.get((int)var15_24), dfOutputStr.get((int)var15_24))).append("\n");
            ++var15_24;
        }
        if (this.sameDiffFunctionInstances.size() > 0) {
            sb.append("\n\n--- SameDiff Defined Functions ---\n");
            format = "%-20s%-15s%-15s%-15s";
            sb.append(String.format(format, "- Name -", "- Variables -", "- Functions -", "- Fn Defs -")).append("\n");
            for (Map.Entry<String, SameDiff> e : this.sameDiffFunctionInstances.entrySet()) {
                SameDiff sd = e.getValue();
                int vars = sd.variableMap().size();
                int fns = sd.functions() == null ? 0 : sd.functions().length;
                int defFns = sd.definedFunctionNames().size();
                sb.append(String.format(format, e.getKey(), String.valueOf(vars), String.valueOf(fns), String.valueOf(defFns))).append("\n");
            }
        }
        return sb.toString();
    }

    public static SameDiffBuilder builder() {
        return new SameDiffBuilder();
    }

    public SameDiff(Map<String, String[]> incomingArgsReverse, Map<String, String[]> outgoingArgsReverse, Map<String, int[]> permuteOrder, boolean shouldBootStrap, Set<String> importedVarName, Map<String, String> baseNameForFunctionInstanceId, DifferentialFunctionFactory functionFactory, Map<String, SDVariable> variableMap, Map<String, long[]> variableNameToShape, Map<String, SDVariable> gradients, Map<String, SDVariable> forwardVarForGrad, Map<String, INDArray> variableNameToArr, Map<String, List<DifferentialFunction>> functionsArgsFor, Map<String, List<DifferentialFunction>> functionOutputFor, Map<String, TensorList> lists, ThreadLocal<FlowPath> localFlowPath, Map<String, Integer> reverseMap, int variableId, Map<String, List<String>> propertiesToResolve, Map<String, Map<String, Object>> propertiesForFunction, Map<String, List<String[]>> placeHolderMap, Map<String, long[]> placeHolderOriginalShapes, Set<String> placeHolderVarNames, MemoryWorkspace workspace, Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap, Map<String, SameDiff> sameDiffFunctionInstances, Set<String> placeHolderFunctions, Map<String, DifferentialFunction> functionInstancesById, Table<String, String, String> fieldVariableResolutionMapping, AtomicBoolean wasRegistered, boolean debugMode, Map<int[], Op> opsForResult, boolean resolvedVariables, boolean logExecution, SameDiff parent, SameDiff child, SDVariable[] outputs, SDVariable[] inputs, Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec_cache) {
        this.incomingArgsReverse = incomingArgsReverse;
        this.outgoingArgsReverse = outgoingArgsReverse;
        this.permuteOrder = permuteOrder;
        this.shouldBootStrap = shouldBootStrap;
        this.importedVarName = importedVarName;
        this.baseNameForFunctionInstanceId = baseNameForFunctionInstanceId;
        this.functionFactory = functionFactory;
        this.variableMap = variableMap;
        this.variableNameToShape = variableNameToShape;
        this.gradients = gradients;
        this.forwardVarForGrad = forwardVarForGrad;
        this.variableNameToArr = variableNameToArr;
        this.functionsArgsFor = functionsArgsFor;
        this.functionOutputFor = functionOutputFor;
        this.lists = lists;
        this.localFlowPath = localFlowPath;
        this.reverseMap = reverseMap;
        this.variableId = variableId;
        this.propertiesToResolve = propertiesToResolve;
        this.propertiesForFunction = propertiesForFunction;
        this.placeHolderMap = placeHolderMap;
        this.placeHolderOriginalShapes = placeHolderOriginalShapes;
        this.placeHolderVarNames = placeHolderVarNames;
        this.workspace = workspace;
        this.sameDiffFunctionDefinitionMap = sameDiffFunctionDefinitionMap;
        this.sameDiffFunctionInstances = sameDiffFunctionInstances;
        this.placeHolderFunctions = placeHolderFunctions;
        this.functionInstancesById = functionInstancesById;
        this.fieldVariableResolutionMapping = fieldVariableResolutionMapping;
        this.wasRegistered = wasRegistered;
        this.debugMode = debugMode;
        this.opsForResult = opsForResult;
        this.resolvedVariables = resolvedVariables;
        this.logExecution = logExecution;
        this.parent = parent;
        this.child = child;
        this.outputs = outputs;
        this.inputs = inputs;
        this.exec_cache = exec_cache;
    }

    public Map<String, DifferentialFunction> getFunctionInstancesById() {
        return this.functionInstancesById;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isLogExecution() {
        return this.logExecution;
    }

    public void setLogExecution(boolean logExecution) {
        this.logExecution = logExecution;
    }

    public SameDiff getParent() {
        return this.parent;
    }

    public SameDiff getChild() {
        return this.child;
    }

    static {
        Method[] methods;
        log = LoggerFactory.getLogger(SameDiff.class);
        cloner = SameDiff.newCloner();
        opMethods = new HashMap<String, Method>();
        for (Method method : methods = SameDiff.class.getDeclaredMethods()) {
            if (!method.getReturnType().equals(SDVariable.class)) continue;
            opMethods.put(method.getName(), method);
        }
    }

    public static class SameDiffBuilder {
        private Map<String, String[]> incomingArgsReverse;
        private Map<String, String[]> outgoingArgsReverse;
        private Map<String, int[]> permuteOrder;
        private boolean shouldBootStrap;
        private Set<String> importedVarName;
        private Map<String, String> baseNameForFunctionInstanceId;
        private DifferentialFunctionFactory functionFactory;
        private Map<String, SDVariable> variableMap;
        private Map<String, long[]> variableNameToShape;
        private Map<String, SDVariable> gradients;
        private Map<String, SDVariable> forwardVarForGrad;
        private Map<String, INDArray> variableNameToArr;
        private Map<String, List<DifferentialFunction>> functionsArgsFor;
        private Map<String, List<DifferentialFunction>> functionOutputFor;
        private Map<String, TensorList> lists;
        private ThreadLocal<FlowPath> localFlowPath;
        private Map<String, Integer> reverseMap;
        private int variableId;
        private Map<String, List<String>> propertiesToResolve;
        private Map<String, Map<String, Object>> propertiesForFunction;
        private Map<String, List<String[]>> placeHolderMap;
        private Map<String, long[]> placeHolderOriginalShapes;
        private Set<String> placeHolderVarNames;
        private MemoryWorkspace workspace;
        private Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap;
        private Map<String, SameDiff> sameDiffFunctionInstances;
        private Set<String> placeHolderFunctions;
        private Map<String, DifferentialFunction> functionInstancesById;
        private Table<String, String, String> fieldVariableResolutionMapping;
        private AtomicBoolean wasRegistered;
        private boolean debugMode;
        private Map<int[], Op> opsForResult;
        private boolean resolvedVariables;
        private boolean logExecution;
        private SameDiff parent;
        private SameDiff child;
        private SDVariable[] outputs;
        private SDVariable[] inputs;
        private Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec_cache;

        SameDiffBuilder() {
        }

        public SameDiffBuilder incomingArgsReverse(Map<String, String[]> incomingArgsReverse) {
            this.incomingArgsReverse = incomingArgsReverse;
            return this;
        }

        public SameDiffBuilder outgoingArgsReverse(Map<String, String[]> outgoingArgsReverse) {
            this.outgoingArgsReverse = outgoingArgsReverse;
            return this;
        }

        public SameDiffBuilder permuteOrder(Map<String, int[]> permuteOrder) {
            this.permuteOrder = permuteOrder;
            return this;
        }

        public SameDiffBuilder shouldBootStrap(boolean shouldBootStrap) {
            this.shouldBootStrap = shouldBootStrap;
            return this;
        }

        public SameDiffBuilder importedVarName(Set<String> importedVarName) {
            this.importedVarName = importedVarName;
            return this;
        }

        public SameDiffBuilder baseNameForFunctionInstanceId(Map<String, String> baseNameForFunctionInstanceId) {
            this.baseNameForFunctionInstanceId = baseNameForFunctionInstanceId;
            return this;
        }

        public SameDiffBuilder functionFactory(DifferentialFunctionFactory functionFactory) {
            this.functionFactory = functionFactory;
            return this;
        }

        public SameDiffBuilder variableMap(Map<String, SDVariable> variableMap) {
            this.variableMap = variableMap;
            return this;
        }

        public SameDiffBuilder variableNameToShape(Map<String, long[]> variableNameToShape) {
            this.variableNameToShape = variableNameToShape;
            return this;
        }

        public SameDiffBuilder gradients(Map<String, SDVariable> gradients) {
            this.gradients = gradients;
            return this;
        }

        public SameDiffBuilder forwardVarForGrad(Map<String, SDVariable> forwardVarForGrad) {
            this.forwardVarForGrad = forwardVarForGrad;
            return this;
        }

        public SameDiffBuilder variableNameToArr(Map<String, INDArray> variableNameToArr) {
            this.variableNameToArr = variableNameToArr;
            return this;
        }

        public SameDiffBuilder functionsArgsFor(Map<String, List<DifferentialFunction>> functionsArgsFor) {
            this.functionsArgsFor = functionsArgsFor;
            return this;
        }

        public SameDiffBuilder functionOutputFor(Map<String, List<DifferentialFunction>> functionOutputFor) {
            this.functionOutputFor = functionOutputFor;
            return this;
        }

        public SameDiffBuilder lists(Map<String, TensorList> lists) {
            this.lists = lists;
            return this;
        }

        public SameDiffBuilder localFlowPath(ThreadLocal<FlowPath> localFlowPath) {
            this.localFlowPath = localFlowPath;
            return this;
        }

        public SameDiffBuilder reverseMap(Map<String, Integer> reverseMap) {
            this.reverseMap = reverseMap;
            return this;
        }

        public SameDiffBuilder variableId(int variableId) {
            this.variableId = variableId;
            return this;
        }

        public SameDiffBuilder propertiesToResolve(Map<String, List<String>> propertiesToResolve) {
            this.propertiesToResolve = propertiesToResolve;
            return this;
        }

        public SameDiffBuilder propertiesForFunction(Map<String, Map<String, Object>> propertiesForFunction) {
            this.propertiesForFunction = propertiesForFunction;
            return this;
        }

        public SameDiffBuilder placeHolderMap(Map<String, List<String[]>> placeHolderMap) {
            this.placeHolderMap = placeHolderMap;
            return this;
        }

        public SameDiffBuilder placeHolderOriginalShapes(Map<String, long[]> placeHolderOriginalShapes) {
            this.placeHolderOriginalShapes = placeHolderOriginalShapes;
            return this;
        }

        public SameDiffBuilder placeHolderVarNames(Set<String> placeHolderVarNames) {
            this.placeHolderVarNames = placeHolderVarNames;
            return this;
        }

        public SameDiffBuilder workspace(MemoryWorkspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public SameDiffBuilder sameDiffFunctionDefinitionMap(Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap) {
            this.sameDiffFunctionDefinitionMap = sameDiffFunctionDefinitionMap;
            return this;
        }

        public SameDiffBuilder sameDiffFunctionInstances(Map<String, SameDiff> sameDiffFunctionInstances) {
            this.sameDiffFunctionInstances = sameDiffFunctionInstances;
            return this;
        }

        public SameDiffBuilder placeHolderFunctions(Set<String> placeHolderFunctions) {
            this.placeHolderFunctions = placeHolderFunctions;
            return this;
        }

        public SameDiffBuilder functionInstancesById(Map<String, DifferentialFunction> functionInstancesById) {
            this.functionInstancesById = functionInstancesById;
            return this;
        }

        public SameDiffBuilder fieldVariableResolutionMapping(Table<String, String, String> fieldVariableResolutionMapping) {
            this.fieldVariableResolutionMapping = fieldVariableResolutionMapping;
            return this;
        }

        public SameDiffBuilder wasRegistered(AtomicBoolean wasRegistered) {
            this.wasRegistered = wasRegistered;
            return this;
        }

        public SameDiffBuilder debugMode(boolean debugMode) {
            this.debugMode = debugMode;
            return this;
        }

        public SameDiffBuilder opsForResult(Map<int[], Op> opsForResult) {
            this.opsForResult = opsForResult;
            return this;
        }

        public SameDiffBuilder resolvedVariables(boolean resolvedVariables) {
            this.resolvedVariables = resolvedVariables;
            return this;
        }

        public SameDiffBuilder logExecution(boolean logExecution) {
            this.logExecution = logExecution;
            return this;
        }

        public SameDiffBuilder parent(SameDiff parent) {
            this.parent = parent;
            return this;
        }

        public SameDiffBuilder child(SameDiff child) {
            this.child = child;
            return this;
        }

        public SameDiffBuilder outputs(SDVariable[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public SameDiffBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public SameDiffBuilder exec_cache(Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec_cache) {
            this.exec_cache = exec_cache;
            return this;
        }

        public SameDiff build() {
            return new SameDiff(this.incomingArgsReverse, this.outgoingArgsReverse, this.permuteOrder, this.shouldBootStrap, this.importedVarName, this.baseNameForFunctionInstanceId, this.functionFactory, this.variableMap, this.variableNameToShape, this.gradients, this.forwardVarForGrad, this.variableNameToArr, this.functionsArgsFor, this.functionOutputFor, this.lists, this.localFlowPath, this.reverseMap, this.variableId, this.propertiesToResolve, this.propertiesForFunction, this.placeHolderMap, this.placeHolderOriginalShapes, this.placeHolderVarNames, this.workspace, this.sameDiffFunctionDefinitionMap, this.sameDiffFunctionInstances, this.placeHolderFunctions, this.functionInstancesById, this.fieldVariableResolutionMapping, this.wasRegistered, this.debugMode, this.opsForResult, this.resolvedVariables, this.logExecution, this.parent, this.child, this.outputs, this.inputs, this.exec_cache);
        }

        public String toString() {
            return "SameDiff.SameDiffBuilder(incomingArgsReverse=" + this.incomingArgsReverse + ", outgoingArgsReverse=" + this.outgoingArgsReverse + ", permuteOrder=" + this.permuteOrder + ", shouldBootStrap=" + this.shouldBootStrap + ", importedVarName=" + this.importedVarName + ", baseNameForFunctionInstanceId=" + this.baseNameForFunctionInstanceId + ", functionFactory=" + this.functionFactory + ", variableMap=" + this.variableMap + ", variableNameToShape=" + this.variableNameToShape + ", gradients=" + this.gradients + ", forwardVarForGrad=" + this.forwardVarForGrad + ", variableNameToArr=" + this.variableNameToArr + ", functionsArgsFor=" + this.functionsArgsFor + ", functionOutputFor=" + this.functionOutputFor + ", lists=" + this.lists + ", localFlowPath=" + this.localFlowPath + ", reverseMap=" + this.reverseMap + ", variableId=" + this.variableId + ", propertiesToResolve=" + this.propertiesToResolve + ", propertiesForFunction=" + this.propertiesForFunction + ", placeHolderMap=" + this.placeHolderMap + ", placeHolderOriginalShapes=" + this.placeHolderOriginalShapes + ", placeHolderVarNames=" + this.placeHolderVarNames + ", workspace=" + this.workspace + ", sameDiffFunctionDefinitionMap=" + this.sameDiffFunctionDefinitionMap + ", sameDiffFunctionInstances=" + this.sameDiffFunctionInstances + ", placeHolderFunctions=" + this.placeHolderFunctions + ", functionInstancesById=" + this.functionInstancesById + ", fieldVariableResolutionMapping=" + this.fieldVariableResolutionMapping + ", wasRegistered=" + this.wasRegistered + ", debugMode=" + this.debugMode + ", opsForResult=" + this.opsForResult + ", resolvedVariables=" + this.resolvedVariables + ", logExecution=" + this.logExecution + ", parent=" + this.parent + ", child=" + this.child + ", outputs=" + Arrays.deepToString(this.outputs) + ", inputs=" + Arrays.deepToString(this.inputs) + ", exec_cache=" + this.exec_cache + ")";
        }
    }
}

