/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.activations;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationCube;
import org.nd4j.linalg.activations.impl.ActivationELU;
import org.nd4j.linalg.activations.impl.ActivationHardSigmoid;
import org.nd4j.linalg.activations.impl.ActivationHardTanH;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.activations.impl.ActivationLReLU;
import org.nd4j.linalg.activations.impl.ActivationRReLU;
import org.nd4j.linalg.activations.impl.ActivationRationalTanh;
import org.nd4j.linalg.activations.impl.ActivationReLU;
import org.nd4j.linalg.activations.impl.ActivationReLU6;
import org.nd4j.linalg.activations.impl.ActivationRectifiedTanh;
import org.nd4j.linalg.activations.impl.ActivationSELU;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;
import org.nd4j.linalg.activations.impl.ActivationSoftPlus;
import org.nd4j.linalg.activations.impl.ActivationSoftSign;
import org.nd4j.linalg.activations.impl.ActivationSoftmax;
import org.nd4j.linalg.activations.impl.ActivationSwish;
import org.nd4j.linalg.activations.impl.ActivationTanH;
import org.nd4j.linalg.activations.impl.ActivationThresholdedReLU;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.impl.scalar.ScalarSet;
import org.nd4j.linalg.api.ops.impl.transforms.Cube;
import org.nd4j.linalg.api.ops.impl.transforms.ELU;
import org.nd4j.linalg.api.ops.impl.transforms.HardSigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.HardTanh;
import org.nd4j.linalg.api.ops.impl.transforms.LeakyReLU;
import org.nd4j.linalg.api.ops.impl.transforms.OldIdentity;
import org.nd4j.linalg.api.ops.impl.transforms.OldSoftMax;
import org.nd4j.linalg.api.ops.impl.transforms.RationalTanh;
import org.nd4j.linalg.api.ops.impl.transforms.RectifedLinear;
import org.nd4j.linalg.api.ops.impl.transforms.RectifiedTanh;
import org.nd4j.linalg.api.ops.impl.transforms.SELU;
import org.nd4j.linalg.api.ops.impl.transforms.Sigmoid;
import org.nd4j.linalg.api.ops.impl.transforms.SigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.SoftMaxDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.SoftPlus;
import org.nd4j.linalg.api.ops.impl.transforms.SoftSign;
import org.nd4j.linalg.api.ops.impl.transforms.Step;
import org.nd4j.linalg.api.ops.impl.transforms.Swish;
import org.nd4j.linalg.api.ops.impl.transforms.SwishDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.Tanh;
import org.nd4j.linalg.api.ops.impl.transforms.TanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.CubeDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.ELUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.HardSigmoidDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.HardTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.LeakyReLUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.RationalTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.RectifiedTanhDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SELUDerivative;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.SoftSignDerivative;

public enum Activation {
    CUBE,
    ELU,
    HARDSIGMOID,
    HARDTANH,
    IDENTITY,
    LEAKYRELU,
    RATIONALTANH,
    RELU,
    RELU6,
    RRELU,
    SIGMOID,
    SOFTMAX,
    SOFTPLUS,
    SOFTSIGN,
    TANH,
    RECTIFIEDTANH,
    SELU,
    SWISH,
    THRESHOLDEDRELU;


    public IActivation getActivationFunction() {
        switch (this) {
            case CUBE: {
                return new ActivationCube();
            }
            case ELU: {
                return new ActivationELU();
            }
            case HARDSIGMOID: {
                return new ActivationHardSigmoid();
            }
            case HARDTANH: {
                return new ActivationHardTanH();
            }
            case IDENTITY: {
                return new ActivationIdentity();
            }
            case LEAKYRELU: {
                return new ActivationLReLU();
            }
            case RATIONALTANH: {
                return new ActivationRationalTanh();
            }
            case RECTIFIEDTANH: {
                return new ActivationRectifiedTanh();
            }
            case RELU: {
                return new ActivationReLU();
            }
            case RELU6: {
                return new ActivationReLU6();
            }
            case SELU: {
                return new ActivationSELU();
            }
            case SWISH: {
                return new ActivationSwish();
            }
            case RRELU: {
                return new ActivationRReLU();
            }
            case SIGMOID: {
                return new ActivationSigmoid();
            }
            case SOFTMAX: {
                return new ActivationSoftmax();
            }
            case SOFTPLUS: {
                return new ActivationSoftPlus();
            }
            case SOFTSIGN: {
                return new ActivationSoftSign();
            }
            case TANH: {
                return new ActivationTanH();
            }
            case THRESHOLDEDRELU: {
                return new ActivationThresholdedReLU();
            }
        }
        throw new UnsupportedOperationException("Unknown or not supported activation function: " + (Object)((Object)this));
    }

    public static Activation fromString(String name) {
        return Activation.valueOf(name.toUpperCase());
    }

    public SDVariable asSameDiff(SameDiff sd, SDVariable input) {
        return this.asSameDiff(null, sd, input);
    }

    public SDVariable asSameDiff(String variableName, SameDiff sd, SDVariable input) {
        switch (this) {
            case CUBE: {
                return sd.pow(variableName, input, 3.0);
            }
            case ELU: {
                return sd.elu(variableName, input);
            }
            case HARDTANH: {
                return sd.hardTanh(variableName, input);
            }
            case IDENTITY: {
                return sd.identity(variableName, input);
            }
            case LEAKYRELU: {
                return sd.leakyRelu(variableName, input, 0.0);
            }
            case RELU: {
                return sd.relu(variableName, input, 0.0);
            }
            case SIGMOID: {
                return sd.sigmoid(variableName, input);
            }
            case SOFTMAX: {
                return sd.softmax(variableName, input);
            }
            case SOFTPLUS: {
                return sd.softplus(variableName, input);
            }
            case SOFTSIGN: {
                return sd.softsign(variableName, input);
            }
            case TANH: {
                return sd.tanh(variableName, input);
            }
        }
        throw new UnsupportedOperationException("Activation function not yet supported: " + (Object)((Object)this));
    }

    public TransformOp asTransform(INDArray in, boolean dup) {
        if (dup) {
            in = in.dup();
        }
        switch (this) {
            case CUBE: {
                return new Cube(in);
            }
            case ELU: {
                return new ELU(in);
            }
            case HARDSIGMOID: {
                return new HardSigmoid(in);
            }
            case HARDTANH: {
                return new HardTanh(in);
            }
            case IDENTITY: {
                return new OldIdentity(in);
            }
            case LEAKYRELU: {
                return new LeakyReLU(in);
            }
            case RATIONALTANH: {
                return new RationalTanh(in);
            }
            case RELU: {
                return new RectifedLinear(in);
            }
            case SIGMOID: {
                return new Sigmoid(in);
            }
            case SOFTMAX: {
                return new OldSoftMax(in);
            }
            case SOFTPLUS: {
                return new SoftPlus(in);
            }
            case SOFTSIGN: {
                return new SoftSign(in);
            }
            case TANH: {
                return new Tanh(in);
            }
            case RECTIFIEDTANH: {
                return new RectifiedTanh(in);
            }
            case SELU: {
                return new SELU(in);
            }
            case SWISH: {
                return new Swish(in);
            }
        }
        throw new UnsupportedOperationException("Not supported via this method: " + (Object)((Object)this));
    }

    public Op asTransformDerivative(INDArray in, boolean dup) {
        if (dup) {
            in = in.dup();
        }
        switch (this) {
            case CUBE: {
                return new CubeDerivative(in);
            }
            case ELU: {
                return new ELUDerivative(in);
            }
            case HARDSIGMOID: {
                return new HardSigmoidDerivative(in);
            }
            case HARDTANH: {
                return new HardTanhDerivative(in);
            }
            case LEAKYRELU: {
                return new LeakyReLUDerivative(in);
            }
            case RATIONALTANH: {
                return new RationalTanhDerivative(in);
            }
            case SIGMOID: {
                return new SigmoidDerivative(in);
            }
            case SOFTPLUS: {
                return new Sigmoid(in);
            }
            case SOFTSIGN: {
                return new SoftSignDerivative(in);
            }
            case TANH: {
                return new TanhDerivative(in);
            }
            case RECTIFIEDTANH: {
                return new RectifiedTanhDerivative(in);
            }
            case SELU: {
                return new SELUDerivative(in);
            }
            case SWISH: {
                return new SwishDerivative(in);
            }
            case SOFTMAX: {
                return new SoftMaxDerivative(in);
            }
            case IDENTITY: {
                return new ScalarSet(in, 1.0);
            }
            case RELU: {
                return new Step(in);
            }
        }
        throw new UnsupportedOperationException("Not supported via this method: " + (Object)((Object)this));
    }
}

