/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.iter;

import java.io.Serializable;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.util.ArrayUtil;

public class LinearIndexLookup
implements Serializable {
    private char ordering;
    private long[][] indexes;
    private long[] shape;
    private boolean[] exists;
    private long numIndexes;

    public LinearIndexLookup(int[] shape, char ordering) {
        this(ArrayUtil.toLongArray((int[])shape), ordering);
    }

    public LinearIndexLookup(long[] shape, char ordering) {
        this.shape = shape;
        this.ordering = ordering;
        this.numIndexes = ArrayUtil.prodLong((long[])shape);
        this.indexes = new long[(int)this.numIndexes][shape.length];
        this.exists = new boolean[(int)this.numIndexes];
    }

    public long[] lookup(int index) {
        if (this.exists[index]) {
            return this.indexes[index];
        }
        this.exists[index] = true;
        this.indexes[index] = this.ordering == 'c' ? Shape.ind2subC(this.shape, (long)index, this.numIndexes) : Shape.ind2sub(this.shape, (long)index, this.numIndexes);
        return this.indexes[index];
    }
}

