/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;

public class GRUCellConfiguration {
    private int batchSize;
    private int intSize;
    private int numUnits;
    private SDVariable xt;
    private SDVariable ht_1;
    private SDVariable Wx;
    private SDVariable Wh;
    private SDVariable b;

    public Map<String, Object> toProperties() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("batchSize", this.batchSize);
        ret.put("intSize", this.intSize);
        ret.put("numUnits", this.numUnits);
        return ret;
    }

    public int[] iArgs() {
        return new int[]{this.batchSize, this.intSize, this.numUnits};
    }

    public SDVariable[] args() {
        return new SDVariable[]{this.xt, this.ht_1, this.Wx, this.Wh, this.b};
    }

    GRUCellConfiguration(int batchSize, int intSize, int numUnits, SDVariable xt, SDVariable ht_1, SDVariable Wx, SDVariable Wh, SDVariable b) {
        this.batchSize = batchSize;
        this.intSize = intSize;
        this.numUnits = numUnits;
        this.xt = xt;
        this.ht_1 = ht_1;
        this.Wx = Wx;
        this.Wh = Wh;
        this.b = b;
    }

    public static GRUCellConfigurationBuilder builder() {
        return new GRUCellConfigurationBuilder();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getIntSize() {
        return this.intSize;
    }

    public int getNumUnits() {
        return this.numUnits;
    }

    public SDVariable getXt() {
        return this.xt;
    }

    public SDVariable getHt_1() {
        return this.ht_1;
    }

    public SDVariable getWx() {
        return this.Wx;
    }

    public SDVariable getWh() {
        return this.Wh;
    }

    public SDVariable getB() {
        return this.b;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setIntSize(int intSize) {
        this.intSize = intSize;
    }

    public void setNumUnits(int numUnits) {
        this.numUnits = numUnits;
    }

    public void setXt(SDVariable xt) {
        this.xt = xt;
    }

    public void setHt_1(SDVariable ht_1) {
        this.ht_1 = ht_1;
    }

    public void setWx(SDVariable Wx) {
        this.Wx = Wx;
    }

    public void setWh(SDVariable Wh) {
        this.Wh = Wh;
    }

    public void setB(SDVariable b) {
        this.b = b;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GRUCellConfiguration)) {
            return false;
        }
        GRUCellConfiguration other = (GRUCellConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        if (this.getIntSize() != other.getIntSize()) {
            return false;
        }
        if (this.getNumUnits() != other.getNumUnits()) {
            return false;
        }
        SDVariable this$xt = this.getXt();
        SDVariable other$xt = other.getXt();
        if (this$xt == null ? other$xt != null : !((Object)this$xt).equals(other$xt)) {
            return false;
        }
        SDVariable this$ht_1 = this.getHt_1();
        SDVariable other$ht_1 = other.getHt_1();
        if (this$ht_1 == null ? other$ht_1 != null : !((Object)this$ht_1).equals(other$ht_1)) {
            return false;
        }
        SDVariable this$Wx = this.getWx();
        SDVariable other$Wx = other.getWx();
        if (this$Wx == null ? other$Wx != null : !((Object)this$Wx).equals(other$Wx)) {
            return false;
        }
        SDVariable this$Wh = this.getWh();
        SDVariable other$Wh = other.getWh();
        if (this$Wh == null ? other$Wh != null : !((Object)this$Wh).equals(other$Wh)) {
            return false;
        }
        SDVariable this$b = this.getB();
        SDVariable other$b = other.getB();
        return !(this$b == null ? other$b != null : !((Object)this$b).equals(other$b));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GRUCellConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBatchSize();
        result = result * 59 + this.getIntSize();
        result = result * 59 + this.getNumUnits();
        SDVariable $xt = this.getXt();
        result = result * 59 + ($xt == null ? 43 : ((Object)$xt).hashCode());
        SDVariable $ht_1 = this.getHt_1();
        result = result * 59 + ($ht_1 == null ? 43 : ((Object)$ht_1).hashCode());
        SDVariable $Wx = this.getWx();
        result = result * 59 + ($Wx == null ? 43 : ((Object)$Wx).hashCode());
        SDVariable $Wh = this.getWh();
        result = result * 59 + ($Wh == null ? 43 : ((Object)$Wh).hashCode());
        SDVariable $b = this.getB();
        result = result * 59 + ($b == null ? 43 : ((Object)$b).hashCode());
        return result;
    }

    public String toString() {
        return "GRUCellConfiguration(batchSize=" + this.getBatchSize() + ", intSize=" + this.getIntSize() + ", numUnits=" + this.getNumUnits() + ", xt=" + this.getXt() + ", ht_1=" + this.getHt_1() + ", Wx=" + this.getWx() + ", Wh=" + this.getWh() + ", b=" + this.getB() + ")";
    }

    public static class GRUCellConfigurationBuilder {
        private int batchSize;
        private int intSize;
        private int numUnits;
        private SDVariable xt;
        private SDVariable ht_1;
        private SDVariable Wx;
        private SDVariable Wh;
        private SDVariable b;

        GRUCellConfigurationBuilder() {
        }

        public GRUCellConfigurationBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public GRUCellConfigurationBuilder intSize(int intSize) {
            this.intSize = intSize;
            return this;
        }

        public GRUCellConfigurationBuilder numUnits(int numUnits) {
            this.numUnits = numUnits;
            return this;
        }

        public GRUCellConfigurationBuilder xt(SDVariable xt) {
            this.xt = xt;
            return this;
        }

        public GRUCellConfigurationBuilder ht_1(SDVariable ht_1) {
            this.ht_1 = ht_1;
            return this;
        }

        public GRUCellConfigurationBuilder Wx(SDVariable Wx) {
            this.Wx = Wx;
            return this;
        }

        public GRUCellConfigurationBuilder Wh(SDVariable Wh) {
            this.Wh = Wh;
            return this;
        }

        public GRUCellConfigurationBuilder b(SDVariable b) {
            this.b = b;
            return this;
        }

        public GRUCellConfiguration build() {
            return new GRUCellConfiguration(this.batchSize, this.intSize, this.numUnits, this.xt, this.ht_1, this.Wx, this.Wh, this.b);
        }

        public String toString() {
            return "GRUCellConfiguration.GRUCellConfigurationBuilder(batchSize=" + this.batchSize + ", intSize=" + this.intSize + ", numUnits=" + this.numUnits + ", xt=" + this.xt + ", ht_1=" + this.ht_1 + ", Wx=" + this.Wx + ", Wh=" + this.Wh + ", b=" + this.b + ")";
        }
    }
}

