/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ExpandDims
extends DynamicCustomOp {
    private int axis;

    public ExpandDims() {
    }

    public ExpandDims(SameDiff sameDiff, SDVariable[] args, int axis) {
        super(null, sameDiff, args);
        if (axis == Integer.MAX_VALUE) {
            throw new ND4JIllegalArgumentException("Cannot perform ExpandDims with axis == Integer.MAX_VALUE");
        }
        this.axis = axis;
        this.addIArgument(this.axis);
    }

    public ExpandDims(SameDiff sameDiff, SDVariable[] args) {
        super(null, sameDiff, args);
    }

    public ExpandDims(INDArray[] inputs, INDArray[] outputs) {
        super(null, inputs, outputs);
    }

    public ExpandDims(SameDiff sameDiff, SDVariable[] args, boolean inPlace) {
        super(null, sameDiff, args, inPlace);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        NodeDef targetNode = TFGraphMapper.getInstance().getNodeWithNameFromGraph(graph, nodeDef.getInput(1));
        INDArray dimArr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", targetNode, graph);
        if (dimArr != null) {
            int axis;
            this.axis = axis = dimArr.data().asInt()[0];
            this.addIArgument(this.axis);
        } else {
            this.axis = Integer.MAX_VALUE;
            this.addIArgument(this.axis);
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("axis", this.axis);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        PropertyMapping axisMapping = PropertyMapping.builder().tfInputPosition(1).propertyNames(new String[]{"axis"}).build();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        map.put("axis", axisMapping);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void assertValidForExecution() {
        CustomOpDescriptor descriptor = this.getDescriptor();
        if (descriptor.getNumInputs() > 0 && this.numInputArguments() > 2 || this.numInputArguments() < 1) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numInputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumOutputs() > 0 && this.numOutputArguments() != descriptor.getNumOutputs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of outputs is invalid for execution. Specified " + this.numOutputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumIArgs() >= 0 && this.numIArguments() != descriptor.getNumIArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of integer arguments is invalid for execution. Specified " + this.numIArguments() + " but should be " + descriptor.getNumIArgs());
        }
        if (descriptor.getNumTArgs() >= 0 && this.numTArguments() != descriptor.getNumTArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numTArguments() + " but should be " + descriptor.getNumTArgs());
        }
    }

    @Override
    public String opName() {
        return "expand_dims";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "ExpandDims";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable ret = this.sameDiff.squeeze(i_v.get(0), this.axis);
        return Arrays.asList(ret);
    }
}

