/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.ArrayUtil;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Gather
extends DynamicCustomOp {
    protected int[] indices;
    protected int axis = 0;

    public Gather(SameDiff sameDiff, SDVariable input, int[] indices, int axis, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{input}, inPlace);
        this.addIArgument(axis);
        this.addIArgument(indices);
        this.axis = axis;
        this.indices = indices;
    }

    public Gather(SameDiff sameDiff, SDVariable input, SDVariable indices, int axis, boolean inPlace) {
        super(null, sameDiff, new SDVariable[]{input, indices}, inPlace);
        this.addIArgument(axis);
        this.axis = axis;
    }

    @Override
    public String onnxName() {
        return "Gather";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Gather", "GatherV2"};
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        OnnxGraphMapper.getInstance().initFunctionFromProperties(node.getOpType(), this, attributesForNode, node, graph);
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        super.resolvePropertiesFromSameDiffBeforeExecution();
        if (this.indices != null && this.numInputArguments() < 2) {
            if (this.numInputArguments() == 0) {
                INDArray a = Nd4j.create(ArrayUtil.toFloats((int[])this.indices));
                a = this.indices.length > 1 ? a.reshape(this.indices.length) : a.reshape(new int[0]);
                this.addInputArgument(this.args()[0].getArr(), a);
            } else if (this.numInputArguments() == 1) {
                this.addInputArgument(Nd4j.create(ArrayUtil.toFloats((int[])this.indices)));
            }
        }
        if (this.numIArguments() < 1) {
            this.addIArgument(this.axis);
        }
        if (this.numOutputArguments() < this.getDescriptor().getNumOutputs()) {
            SDVariable[] outputs;
            for (SDVariable v : outputs = this.outputVariables()) {
                if (v.getArr() != null) continue;
                return;
            }
            for (int i = 0; i < outputs.length; ++i) {
                INDArray output = outputs[i].getArr();
                this.addOutputArgument(output);
            }
        }
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping broadcast = PropertyMapping.builder().onnxAttrName("indices").tfInputPosition(1).propertyNames(new String[]{"indices"}).build();
        map.put("indices", broadcast);
        ret.put(this.tensorflowNames()[0], map);
        ret.put(this.onnxName(), map);
        HashMap<String, PropertyMapping> map2 = new HashMap<String, PropertyMapping>();
        PropertyMapping broadcast2 = PropertyMapping.builder().tfInputPosition(1).propertyNames(new String[]{"indices"}).build();
        map2.put("indices", broadcast2);
        PropertyMapping axis2 = PropertyMapping.builder().tfInputPosition(2).propertyNames(new String[]{"axis"}).build();
        map2.put("axis", axis2);
        ret.put("GatherV2", map2);
        return ret;
    }

    @Override
    public String opName() {
        return "gather";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable indicesGrad = this.sameDiff.zerosLike(this.arg(1));
        SDVariable inputGrad = this.sameDiff.zerosLike(this.arg(0));
        int ndim = this.arg(0).getShape().length;
        int a = this.axis;
        if (a < 0) {
            a += ndim;
        }
        if (a == 0) {
            inputGrad = this.sameDiff.scatterAdd(inputGrad, this.arg(1), i_v.get(0));
        } else {
            int i;
            int[] permDims = new int[ndim];
            permDims[0] = a;
            for (i = 0; i < a; ++i) {
                permDims[i + 1] = i;
            }
            for (i = a + 1; i < ndim; ++i) {
                permDims[i] = i;
            }
            inputGrad = this.sameDiff.permute(inputGrad, permDims);
            SDVariable i_v_transposed = this.sameDiff.permute(i_v.get(0), permDims);
            inputGrad = this.sameDiff.scatterAdd(inputGrad, this.arg(1), i_v_transposed);
            int[] reverseDims = new int[ndim];
            for (int i2 = 0; i2 < ndim; ++i2) {
                reverseDims[permDims[i2]] = i2;
            }
            inputGrad = this.sameDiff.permute(inputGrad, reverseDims);
        }
        return Arrays.asList(inputGrad, indicesGrad);
    }

    public Gather() {
    }
}

