/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DynamicStitch
extends DynamicCustomOp {
    private int numPartitions;
    private SDVariable[] indices;

    public DynamicStitch() {
    }

    public DynamicStitch(SameDiff sameDiff, SDVariable[] indices, SDVariable[] inputs) {
        super(null, sameDiff, (SDVariable[])ArrayUtils.addAll((Object[])indices, (Object[])inputs), false);
        this.indices = indices;
        this.numPartitions = inputs.length;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable gradient = i_v.get(0);
        SDVariable[] partitionData = new SDVariable[this.indices.length];
        for (int i = 0; i < this.indices.length; ++i) {
            partitionData[i] = this.sameDiff.onesLike(this.indices[i]).mul(i);
        }
        SDVariable partitions = this.sameDiff.dynamicStitch(this.indices, partitionData);
        SDVariable[] partition = this.sameDiff.dynamicPartition(gradient, partitions, this.numPartitions);
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        for (SDVariable i : this.indices) {
            ret.add(this.f().zerosLike(i));
        }
        Collections.addAll(ret, partition);
        return ret;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
    }

    @Override
    public String opName() {
        return "dynamic_stitch";
    }

    @Override
    public String tensorflowName() {
        return "DynamicStitch";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx name found for shape " + this.opName());
    }
}

