/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.util.Arrays;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JIllegalStateException;

public class LinAlgExceptions {
    public static void assertSameLength(INDArray x, INDArray z) {
        long lengthZ;
        long lengthX = x.length();
        if (lengthX != (lengthZ = z.length()) && lengthX != 1L && lengthZ != 1L) {
            throw new IllegalStateException("Mis matched lengths: [" + x.length() + "] != [" + z.length() + "] - Array 1 shape: " + Arrays.toString(x.shape()) + ", array 2 shape: " + Arrays.toString(z.shape()));
        }
    }

    public static void assertSameLength(INDArray x, INDArray y, INDArray z) {
        long lengthX = x.length();
        long lengthY = y.length();
        long lengthZ = z.length();
        if (lengthX != lengthY && lengthX != lengthZ && lengthX != 1L && lengthY != 1L && lengthZ != 1L) {
            throw new IllegalStateException("Mis matched lengths: [" + lengthX + "] != [" + lengthY + "] != [" + lengthZ + "] - Array 1 shape: " + Arrays.toString(x.shape()) + ", array 2 shape: " + Arrays.toString(y.shape()) + ", array 3 shape: " + Arrays.toString(z.shape()));
        }
    }

    public static void assertSameShape(INDArray n, INDArray n2) {
        if (!Shape.shapeEquals(n.shape(), n2.shape())) {
            throw new IllegalStateException("Mis matched shapes: " + Arrays.toString(n.shape()) + ", " + Arrays.toString(n2.shape()));
        }
    }

    public static void assertRows(INDArray n, INDArray n2) {
        if (n.rows() != n2.rows()) {
            throw new IllegalStateException("Mis matched rows: " + n.rows() + " != " + n2.rows());
        }
    }

    public static void assertVector(INDArray ... arr) {
        for (INDArray a1 : arr) {
            LinAlgExceptions.assertVector(a1);
        }
    }

    public static void assertMatrix(INDArray ... arr) {
        for (INDArray a1 : arr) {
            LinAlgExceptions.assertMatrix(a1);
        }
    }

    public static void assertVector(INDArray arr) {
        if (!arr.isVector()) {
            throw new IllegalArgumentException("Array must be a vector. Array has shape: " + Arrays.toString(arr.shape()));
        }
    }

    public static void assertMatrix(INDArray arr) {
        if (arr.shape().length > 2) {
            throw new IllegalArgumentException("Array must be a matrix. Array has shape: " + Arrays.toString(arr.shape()));
        }
    }

    public static void assertMultiplies(INDArray nd1, INDArray nd2) {
        if (nd1.rank() == 2 && nd2.rank() == 2 && nd1.columns() == nd2.rows()) {
            return;
        }
        if (nd1.rank() == 2 && nd2.rank() == 1 && (long)nd1.columns() == nd2.length()) {
            return;
        }
        throw new ND4JIllegalStateException("Cannot execute matrix multiplication: " + Arrays.toString(nd1.shape()) + "x" + Arrays.toString(nd2.shape()) + (nd1.rank() != 2 || nd2.rank() != 2 ? ": inputs are not matrices" : ": Column of left array " + nd1.columns() + " != rows of right " + nd2.rows()));
    }

    public static void assertColumns(INDArray n, INDArray n2) {
        if (n.columns() != n2.columns()) {
            throw new IllegalStateException("Mis matched columns: " + n.columns() + " != " + n2.columns());
        }
    }

    public static void assertValidNum(INDArray n) {
        INDArray linear = n.linearView();
        int i = 0;
        while ((long)i < linear.length()) {
            double d = linear.getDouble((long)i);
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new IllegalStateException("Found infinite or nan");
            }
            ++i;
        }
    }
}

