/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.util;

import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.api.buffer.DataBuffer;

public class DataTypeUtil {
    public static DataBuffer.Type getDtypeFromContext(String dType) {
        switch (dType) {
            case "double": {
                return DataBuffer.Type.DOUBLE;
            }
            case "float": {
                return DataBuffer.Type.FLOAT;
            }
            case "int": {
                return DataBuffer.Type.INT;
            }
        }
        return DataBuffer.Type.FLOAT;
    }

    public static String getDTypeForName(DataBuffer.Type allocationMode) {
        switch (allocationMode) {
            case DOUBLE: {
                return "double";
            }
            case FLOAT: {
                return "float";
            }
            case INT: {
                return "int";
            }
        }
        return "float";
    }

    public static DataBuffer.Type getDtypeFromContext() {
        return DataTypeUtil.getDtypeFromContext(Nd4jContext.getInstance().getConf().getProperty("dtype"));
    }

    public static void setDTypeForContext(DataBuffer.Type allocationModeForContext) {
        DataTypeUtil.setDTypeForContext(DataTypeUtil.getDTypeForName(allocationModeForContext));
    }

    public static void setDTypeForContext(String allocationModeForContext) {
        if (!(allocationModeForContext.equals("double") || allocationModeForContext.equals("float") || allocationModeForContext.equals("int"))) {
            throw new IllegalArgumentException("Allocation mode must be one of: double,float, or int");
        }
        Nd4jContext.getInstance().getConf().put("dtype", allocationModeForContext);
    }
}

