/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.buffer.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import org.nd4j.linalg.io.ClassPathResource;

public final class LibUtils {
    public static void loadJavaCpp(Class<?> clazz) {
        LibUtils.loadLibrary("jni" + clazz.getSimpleName());
    }

    public static void loadLibrary(String baseName) {
        String libName = LibUtils.createLibName(baseName);
        Throwable throwable = null;
        try {
            LibUtils.loadLibraryResource(libName);
            return;
        }
        catch (Throwable t) {
            throwable = t;
            try {
                System.loadLibrary(libName);
                return;
            }
            catch (Throwable t2) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println("Error while loading native library \"" + libName + "\" with base name \"" + baseName + "\"");
                pw.println("Operating system name: " + System.getProperty("os.name"));
                pw.println("Architecture         : " + System.getProperty("os.arch"));
                pw.println("Architecture bit size: " + System.getProperty("sun.arch.data.model"));
                if (throwable != null) {
                    pw.println("Stack trace from the attempt to load the library as a resource:");
                    throwable.printStackTrace(pw);
                }
                pw.println("Stack trace from the attempt to load the library as a file:");
                t2.printStackTrace(pw);
                pw.flush();
                pw.close();
                throw new UnsatisfiedLinkError("Could not load the native library.\n" + sw.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTempBinaryFile(String libName) throws Exception {
        String libPrefix = LibUtils.createLibPrefix();
        String libExtension = LibUtils.createLibExtension();
        String fullName = libPrefix + libName;
        String resourceName = fullName + "." + libExtension;
        ClassPathResource resource = new ClassPathResource(resourceName);
        InputStream inputStream = resource.getInputStream();
        if (inputStream == null) {
            throw new NullPointerException("No resource found with name '" + resourceName + "'");
        }
        File tempFile = new File(System.getProperty("java.io.tmpdir"), fullName + "." + libExtension);
        tempFile.deleteOnExit();
        try (FileOutputStream outputStream = null;){
            int read;
            outputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
            outputStream = null;
            System.load(tempFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadTempBinaryFile(Class<?> libName) throws Exception {
        String os = LibUtils.getOsName();
        String arch = LibUtils.getArchName();
        String resourceFolder = os + "-" + arch;
        String libPrefix = LibUtils.createLibPrefix();
        String libExtension = LibUtils.createLibExtension();
        StringBuilder sb = new StringBuilder().append(libName.getPackage().getName().replace(".", "/") + "/").append(resourceFolder).append("/").append(libPrefix).append("jni" + libName.getSimpleName() + ".").append(libExtension);
        String resourceName = sb.toString();
        ClassPathResource resource = new ClassPathResource(resourceName);
        InputStream inputStream = resource.getInputStream();
        if (inputStream == null) {
            throw new NullPointerException("No resource found with name '" + resourceName + "'");
        }
        String fullName = libPrefix + "jni" + libName.getSimpleName() + "." + libExtension;
        File tempFile = new File(System.getProperty("java.io.tmpdir"), fullName);
        tempFile.deleteOnExit();
        try (FileOutputStream outputStream = null;){
            int read;
            outputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
            outputStream = null;
            System.load(tempFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadJavaCppResource(String libName) throws Throwable {
        String libPrefix = LibUtils.createLibPrefix();
        String libExtension = LibUtils.createLibExtension();
        String fullName = libPrefix + libName;
        String resourceName = fullName + "." + libExtension;
        ClassPathResource resource = new ClassPathResource(resourceName);
        InputStream inputStream = resource.getInputStream();
        if (inputStream == null) {
            throw new NullPointerException("No resource found with name '" + resourceName + "'");
        }
        File tempFile = File.createTempFile(fullName, "." + libExtension);
        tempFile.deleteOnExit();
        try (FileOutputStream outputStream = null;){
            int read;
            outputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
            outputStream = null;
            System.load(tempFile.toString());
        }
    }

    public static void addLibraryPath(String pathToAdd) throws Exception {
        String[] paths;
        Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        usrPathsField.setAccessible(true);
        for (String path : paths = (String[])usrPathsField.get(null)) {
            if (!path.equals(pathToAdd)) continue;
            return;
        }
        String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
        newPaths[newPaths.length - 1] = pathToAdd;
        usrPathsField.set(null, newPaths);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryResource(String libName) throws Throwable {
        String libPrefix = LibUtils.createLibPrefix();
        String libExtension = LibUtils.createLibExtension();
        String fullName = libPrefix + libName;
        String resourceName = "/lib/" + fullName + "." + libExtension;
        InputStream inputStream = LibUtils.class.getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw new NullPointerException("No resource found with name '" + resourceName + "'");
        }
        File tempFile = File.createTempFile(fullName, "." + libExtension);
        tempFile.deleteOnExit();
        try (FileOutputStream outputStream = null;){
            int read;
            outputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
            outputStream = null;
            System.load(tempFile.toString());
        }
    }

    public static String getOsName() {
        OSType osType = LibUtils.calculateOS();
        switch (osType) {
            case APPLE: {
                return "macosx";
            }
            case LINUX: {
                return "linux";
            }
            case SUN: {
                return "sun";
            }
            case WINDOWS: {
                return "windows";
            }
        }
        return "";
    }

    public static String getArchName() {
        ARCHType archType = LibUtils.calculateArch();
        switch (archType) {
            case X86: {
                return "x86";
            }
            case X86_64: {
                return "x86_64";
            }
            case ARM: {
                return "arm";
            }
            case PPC: {
                return "ppc";
            }
            case PPC_64: {
                return "ppc64";
            }
            case RISC: {
                return "risc";
            }
        }
        return "unknown";
    }

    private static String createLibExtension() {
        OSType osType = LibUtils.calculateOS();
        switch (osType) {
            case APPLE: {
                return "dylib";
            }
            case LINUX: {
                return "so";
            }
            case SUN: {
                return "so";
            }
            case WINDOWS: {
                return "dll";
            }
        }
        return "";
    }

    private static String createLibPrefix() {
        OSType osType = LibUtils.calculateOS();
        switch (osType) {
            case APPLE: 
            case LINUX: 
            case SUN: {
                return "lib";
            }
            case WINDOWS: {
                return "";
            }
        }
        return "";
    }

    public static String createLibName(String baseName) {
        OSType osType = LibUtils.calculateOS();
        ARCHType archType = LibUtils.calculateArch();
        String libName = baseName;
        libName = libName + "-" + osType.toString().toLowerCase(Locale.ENGLISH);
        libName = libName + "-" + archType.toString().toLowerCase(Locale.ENGLISH);
        return libName;
    }

    public static OSType calculateOS() {
        String osName = System.getProperty("os.name");
        if ((osName = osName.toLowerCase(Locale.ENGLISH)).startsWith("mac os")) {
            return OSType.APPLE;
        }
        if (osName.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (osName.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osName.startsWith("sun")) {
            return OSType.SUN;
        }
        return OSType.UNKNOWN;
    }

    public static ARCHType calculateArch() {
        String osArch = System.getProperty("os.arch");
        if ((osArch = osArch.toLowerCase(Locale.ENGLISH)).equals("i386") || osArch.equals("x86") || osArch.equals("i686")) {
            return ARCHType.X86;
        }
        if (osArch.startsWith("amd64") || osArch.startsWith("x86_64")) {
            return ARCHType.X86_64;
        }
        if (osArch.equals("ppc") || osArch.equals("powerpc")) {
            return ARCHType.PPC;
        }
        if (osArch.startsWith("ppc")) {
            return ARCHType.PPC_64;
        }
        if (osArch.startsWith("sparc")) {
            return ARCHType.SPARC;
        }
        if (osArch.startsWith("arm")) {
            return ARCHType.ARM;
        }
        if (osArch.startsWith("mips")) {
            return ARCHType.MIPS;
        }
        if (osArch.contains("risc")) {
            return ARCHType.RISC;
        }
        return ARCHType.UNKNOWN;
    }

    private LibUtils() {
    }

    public static enum ARCHType {
        PPC,
        PPC_64,
        SPARC,
        X86,
        X86_64,
        ARM,
        MIPS,
        RISC,
        UNKNOWN;

    }

    public static enum OSType {
        APPLE,
        LINUX,
        SUN,
        WINDOWS,
        UNKNOWN;

    }
}

