/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.bytebuddy.arithmetic;

import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.jar.asm.MethodVisitor;
import org.nd4j.bytebuddy.arithmetic.IntegerArithmeticByteCodeAppender;

public class ByteBuddyIntArithmetic
implements Implementation {
    private int val1;
    private int val2;
    private Operation op;

    public ByteBuddyIntArithmetic(int val1, int val2, Operation op) {
        this.val1 = val1;
        this.val2 = val2;
        this.op = op;
    }

    public static StackManipulation opFor(Operation operation) {
        switch (operation) {
            case ADD: {
                return IntegerAddition.INSTANCE;
            }
            case SUB: {
                return IntegerSubtraction.INSTANCE;
            }
            case MUL: {
                return IntegerMultiplication.INSTANCE;
            }
            case DIV: {
                return IntegerDivision.INSTANCE;
            }
            case MOD: {
                return IntegerMod.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Illegal type of operation ");
    }

    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new IntegerArithmeticByteCodeAppender(this.val1, this.val2, this.op);
    }

    public static StackManipulation[] mod(int val1, int val2) {
        return new StackManipulation[]{IntegerConstant.forValue((int)val1), IntegerConstant.forValue((int)val2), IntegerMod.INSTANCE, MethodReturn.INTEGER};
    }

    public static StackManipulation[] div(int val1, int val2) {
        return new StackManipulation[]{IntegerConstant.forValue((int)val1), IntegerConstant.forValue((int)val2), IntegerDivision.INSTANCE, MethodReturn.INTEGER};
    }

    public static StackManipulation[] times(int val1, int val2) {
        return new StackManipulation[]{IntegerConstant.forValue((int)val1), IntegerConstant.forValue((int)val2), IntegerMultiplication.INSTANCE, MethodReturn.INTEGER};
    }

    public static enum IntegerMod implements StackManipulation
    {
        INSTANCE;


        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(112);
            return new StackManipulation.Size(-1, 0);
        }
    }

    public static enum IntegerDivision implements StackManipulation
    {
        INSTANCE;


        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(108);
            return new StackManipulation.Size(-1, 0);
        }
    }

    public static enum IntegerMultiplication implements StackManipulation
    {
        INSTANCE;


        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(104);
            return new StackManipulation.Size(-1, 0);
        }
    }

    public static enum IntegerAddition implements StackManipulation
    {
        INSTANCE;


        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(96);
            return new StackManipulation.Size(-1, 0);
        }
    }

    public static enum IntegerSubtraction implements StackManipulation
    {
        INSTANCE;


        public boolean isValid() {
            return true;
        }

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitInsn(100);
            return new StackManipulation.Size(-1, 0);
        }
    }

    public static enum Operation {
        ADD,
        SUB,
        MUL,
        DIV,
        MOD;

    }
}

