/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.bytebuddy.arrays.create;

import java.util.ArrayList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.pool.TypePool;
import org.nd4j.bytebuddy.arrays.create.CreateArrayByteCodeAppender;

public class IntArrayCreation
implements Implementation {
    private int length = 0;
    private static TypePool typePool = TypePool.Default.ofClassPath();
    private static ArrayFactory factory = ArrayFactory.forType((TypeDescription)typePool.describe("int").resolve());

    public IntArrayCreation(int length) {
        this.length = length;
    }

    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new CreateArrayByteCodeAppender(this.length);
    }

    public static StackManipulation intCreationOfLength(int length) {
        ArrayList<StackManipulation> manipulations = new ArrayList<StackManipulation>();
        for (int i = 0; i < length; ++i) {
            manipulations.add(IntegerConstant.forValue((int)0));
        }
        StackManipulation createArray = factory.withValues(manipulations);
        return createArray;
    }
}

