/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.bytebuddy.arrays.assign.relative.withvalue;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.pool.TypePool;

public class RelativeArrayAssignWithValueValueAppender
implements ByteCodeAppender {
    private int index;
    private int newVal;
    private static TypePool typePool = TypePool.Default.ofClassPath();

    public RelativeArrayAssignWithValueValueAppender(int index, int newVal) {
        this.index = index;
        this.newVal = newVal;
    }

    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        StackManipulation compound = this.assignOperation();
        StackManipulation.Size size = compound.apply(methodVisitor, implementationContext);
        StackManipulation store = ArrayAccess.of((TypeDescription)typePool.describe("int").resolve()).store();
        size = size.aggregate(store.apply(methodVisitor, implementationContext));
        return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public StackManipulation assignOperation() {
        StackManipulation val = IntegerConstant.forValue((int)this.newVal);
        StackManipulation indexToAssign = IntegerConstant.forValue((int)this.index);
        StackManipulation.Compound compound = new StackManipulation.Compound(new StackManipulation[]{indexToAssign, val});
        return compound;
    }
}

