/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class NioUtil {
    public static void copyAtStride(int n, BufferType bufferType, ByteBuffer from, int fromOffset, int fromStride, ByteBuffer to, int toOffset, int toStride) {
        ByteBuffer fromView = from;
        ByteBuffer toView = to;
        fromView.order(ByteOrder.nativeOrder());
        toView.order(ByteOrder.nativeOrder());
        switch (bufferType) {
            case INT: {
                IntBuffer fromInt = fromView.asIntBuffer();
                IntBuffer toInt = toView.asIntBuffer();
                for (int i = 0; i < n; ++i) {
                    int put = fromInt.get(fromOffset + i * fromStride);
                    toInt.put(toOffset + i * toStride, put);
                }
                break;
            }
            case FLOAT: {
                FloatBuffer fromFloat = fromView.asFloatBuffer();
                FloatBuffer toFloat = toView.asFloatBuffer();
                for (int i = 0; i < n; ++i) {
                    float put = fromFloat.get(fromOffset + i * fromStride);
                    toFloat.put(toOffset + i * toStride, put);
                }
                break;
            }
            case DOUBLE: {
                DoubleBuffer fromDouble = fromView.asDoubleBuffer();
                DoubleBuffer toDouble = toView.asDoubleBuffer();
                for (int i = 0; i < n; ++i) {
                    toDouble.put(toOffset + i * toStride, fromDouble.get(fromOffset + i * fromStride));
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only floats and double supported");
            }
        }
    }

    public static enum BufferType {
        INT,
        FLOAT,
        DOUBLE;

    }
}

