/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.primitives;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nd4j.linalg.primitives.AtomicDouble;
import org.nd4j.linalg.primitives.Counter;
import org.nd4j.linalg.primitives.Pair;

public class CounterMap<F, S>
implements Serializable {
    private static final long serialVersionUID = 119L;
    protected Map<F, Counter<S>> maps = new ConcurrentHashMap<F, Counter<S>>();

    public boolean isEmpty() {
        return this.maps.isEmpty();
    }

    public boolean isEmpty(F element) {
        if (this.isEmpty()) {
            return true;
        }
        Counter<S> m = this.maps.get(element);
        if (m == null) {
            return true;
        }
        return m.isEmpty();
    }

    public void incrementAll(CounterMap<F, S> other) {
        for (Map.Entry<F, Counter<S>> entry : other.maps.entrySet()) {
            F key = entry.getKey();
            Counter<S> innerCounter = entry.getValue();
            for (Map.Entry<S, AtomicDouble> innerEntry : innerCounter.entrySet()) {
                S value = innerEntry.getKey();
                this.incrementCount(key, value, innerEntry.getValue().get());
            }
        }
    }

    public void incrementCount(F first, S second, double inc) {
        Counter<Object> counter = this.maps.get(first);
        if (counter == null) {
            counter = new Counter();
            this.maps.put(first, counter);
        }
        counter.incrementCount(second, inc);
    }

    public double getCount(F first, S second) {
        Counter<S> counter = this.maps.get(first);
        if (counter == null) {
            return 0.0;
        }
        return counter.getCount(second);
    }

    public double setCount(F first, S second, double value) {
        Counter<Object> counter = this.maps.get(first);
        if (counter == null) {
            counter = new Counter();
            this.maps.put(first, counter);
        }
        return counter.setCount(second, value);
    }

    public Pair<F, S> argMax() {
        Double maxCount = -1.7976931348623157E308;
        Pair<F, S> maxKey = null;
        for (Map.Entry<F, Counter<S>> entry : this.maps.entrySet()) {
            S localMax;
            Counter<S> counter = entry.getValue();
            if (!(counter.getCount(localMax = counter.argMax()) > maxCount) && maxKey != null) continue;
            maxKey = new Pair<F, S>(entry.getKey(), localMax);
            maxCount = counter.getCount(localMax);
        }
        return maxKey;
    }

    public void clear() {
        this.maps.clear();
    }

    public void clear(F element) {
        Counter<S> s = this.maps.get(element);
        if (s != null) {
            s.clear();
        }
    }

    public Set<F> keySet() {
        return this.maps.keySet();
    }

    public Counter<S> getCounter(F first) {
        return this.maps.get(first);
    }

    public Iterator<Pair<F, S>> getIterator() {
        return new Iterator<Pair<F, S>>(){
            Iterator<F> outerIt;
            Iterator<S> innerIt;
            F curKey;
            {
                this.outerIt = CounterMap.this.keySet().iterator();
            }

            private boolean hasInside() {
                if (this.innerIt == null || !this.innerIt.hasNext()) {
                    if (!this.outerIt.hasNext()) {
                        return false;
                    }
                    this.curKey = this.outerIt.next();
                    this.innerIt = CounterMap.this.getCounter(this.curKey).keySet().iterator();
                }
                return true;
            }

            @Override
            public boolean hasNext() {
                return this.hasInside();
            }

            @Override
            public Pair<F, S> next() {
                this.hasInside();
                if (this.curKey == null) {
                    throw new RuntimeException("Outer element can't be null");
                }
                return Pair.makePair(this.curKey, this.innerIt.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    public int size() {
        return this.maps.size();
    }

    public int totalSize() {
        int size = 0;
        for (F first : this.keySet()) {
            size += this.getCounter(first).size();
        }
        return size;
    }
}

