/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.constant;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.nd4j.jita.conf.CudaEnvironment;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.shape.ShapeDescriptor;

public class ConstantProtector {
    private static ConstantProtector ourInstance = new ConstantProtector();
    private List<DataBuffer> protector = new CopyOnWriteArrayList<DataBuffer>();
    private List<Map<ShapeDescriptor, DataBuffer>> deviceCache = new ArrayList<Map<ShapeDescriptor, DataBuffer>>();

    public static ConstantProtector getInstance() {
        return ourInstance;
    }

    private ConstantProtector() {
        int numDevices = CudaEnvironment.getInstance().getConfiguration().getAvailableDevices().size();
        for (int i = 0; i < numDevices; ++i) {
            this.deviceCache.add(i, new ConcurrentHashMap());
        }
    }

    public void persistDataBuffer(DataBuffer buffer) {
        this.protector.add(buffer);
    }

    public void persistDataBuffer(int deviceId, ShapeDescriptor descriptor, DataBuffer buffer) {
        this.deviceCache.get(deviceId).put(descriptor, buffer);
    }

    public DataBuffer getDataBuffer(int deviceId, ShapeDescriptor descriptor) {
        return this.deviceCache.get(deviceId).get(descriptor);
    }

    public boolean containsDataBuffer(int deviceId, ShapeDescriptor descriptor) {
        return this.deviceCache.get(deviceId).containsKey(descriptor);
    }
}

