/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas;

import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.util.Pair;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.utils.AllocationUtils;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.cache.TADManager;
import org.nd4j.linalg.factory.BaseNDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.JCublasNDArray;
import org.nd4j.linalg.jcublas.blas.JcublasLapack;
import org.nd4j.linalg.jcublas.blas.JcublasLevel1;
import org.nd4j.linalg.jcublas.blas.JcublasLevel2;
import org.nd4j.linalg.jcublas.blas.JcublasLevel3;
import org.nd4j.linalg.jcublas.buffer.AddressRetriever;
import org.nd4j.linalg.jcublas.buffer.CudaDoubleDataBuffer;
import org.nd4j.linalg.jcublas.buffer.CudaFloatDataBuffer;
import org.nd4j.linalg.jcublas.complex.ComplexDouble;
import org.nd4j.linalg.jcublas.complex.ComplexFloat;
import org.nd4j.linalg.jcublas.complex.JCublasComplexNDArray;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.jcublas.ops.executioner.JCudaExecutioner;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;

public class JCublasNDArrayFactory
extends BaseNDArrayFactory {
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();

    public JCublasNDArrayFactory() {
    }

    public JCublasNDArrayFactory(DataBuffer.Type dtype, Character order) {
        super(dtype, order);
    }

    public JCublasNDArrayFactory(DataBuffer.Type dtype, char order) {
        super(dtype, order);
    }

    public void createLevel1() {
        this.level1 = new JcublasLevel1();
    }

    public void createLevel2() {
        this.level2 = new JcublasLevel2();
    }

    public void createLevel3() {
        this.level3 = new JcublasLevel3();
    }

    public void createLapack() {
        this.lapack = new JcublasLapack();
    }

    public INDArray create(int[] shape, DataBuffer buffer) {
        return new JCublasNDArray(shape, buffer);
    }

    public IComplexFloat createFloat(float real, float imag) {
        return new ComplexFloat(real, imag);
    }

    public IComplexDouble createDouble(double real, double imag) {
        return new ComplexDouble(real, imag);
    }

    public INDArray create(double[][] data) {
        return new JCublasNDArray(data);
    }

    public INDArray create(double[][] data, char ordering) {
        return new JCublasNDArray(data, ordering);
    }

    public IComplexNDArray createComplex(INDArray arr) {
        return new JCublasComplexNDArray(arr);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape) {
        return new JCublasComplexNDArray(data, shape, Nd4j.getComplexStrides((int[])shape, (char)Nd4j.order().charValue()));
    }

    public IComplexNDArray createComplex(List<IComplexNDArray> arrs, int[] shape) {
        return new JCublasComplexNDArray(arrs, shape);
    }

    public INDArray create(DataBuffer data) {
        return new JCublasNDArray(data);
    }

    public IComplexNDArray createComplex(DataBuffer data) {
        return new JCublasComplexNDArray(data);
    }

    public IComplexNDArray createComplex(DataBuffer data, int rows, int columns, int[] stride, int offset) {
        return new JCublasComplexNDArray(data, new int[]{rows, columns}, stride, offset);
    }

    public INDArray create(DataBuffer data, int rows, int columns, int[] stride, int offset) {
        return new JCublasNDArray(data, new int[]{rows, columns}, stride, offset);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] stride, int offset) {
        return new JCublasComplexNDArray(data, shape, stride, offset);
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset) {
        return new JCublasComplexNDArray(data, shape, stride, offset);
    }

    public INDArray create(int[] shape, char ordering) {
        return new JCublasNDArray(shape, ordering);
    }

    public INDArray createUninitialized(int[] shape, char ordering) {
        return new JCublasNDArray(shape, Nd4j.getStrides((int[])shape, (char)ordering), 0, ordering, false);
    }

    public INDArray create(DataBuffer data, int[] newShape, int[] newStride, int offset, char ordering) {
        return new JCublasNDArray(data, newShape, newStride, offset, ordering);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] newDims, int[] newStrides, int offset, char ordering) {
        return new JCublasComplexNDArray(data, newDims, newStrides, offset, ordering);
    }

    public IComplexNDArray createComplex(float[] data, Character order) {
        return new JCublasComplexNDArray(data, order);
    }

    public INDArray create(float[] data, int[] shape, int offset, Character order) {
        return new JCublasNDArray(data, shape, offset, order.charValue());
    }

    public INDArray create(float[] data, int rows, int columns, int[] stride, int offset, char ordering) {
        return new JCublasNDArray(data, new int[]{rows, columns}, stride, offset, ordering);
    }

    public INDArray create(double[] data, int[] shape, char ordering) {
        return new JCublasNDArray(data, shape, ordering);
    }

    public INDArray create(List<INDArray> list, int[] shape, char ordering) {
        return new JCublasNDArray(list, shape, ordering);
    }

    public INDArray create(double[] data, int[] shape, int offset) {
        return new JCublasNDArray(data, shape, (char)offset);
    }

    public INDArray create(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new JCublasNDArray(data, shape, stride, offset, ordering);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, int offset) {
        return new JCublasComplexNDArray(data, shape, stride, offset);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new JCublasComplexNDArray(data, shape, stride, offset, ordering);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int[] stride, char ordering) {
        return new JCublasComplexNDArray(data, shape, stride, (int)ordering);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, int offset, char ordering) {
        return new JCublasComplexNDArray(data, shape, offset, ordering);
    }

    public IComplexNDArray createComplex(IComplexNumber[] data, int[] shape, char ordering) {
        return new JCublasComplexNDArray(data, shape, ordering);
    }

    public INDArray create(float[] data, int[] shape, int[] stride, int offset) {
        return new JCublasNDArray(data, shape, stride, offset);
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset) {
        return new JCublasComplexNDArray(ArrayUtil.floatCopyOf((double[])data), shape, stride, offset);
    }

    public INDArray create(double[] data, int[] shape, int[] stride, int offset) {
        return new JCublasNDArray(data, shape, stride, offset);
    }

    public INDArray create(DataBuffer data, int[] shape) {
        return new JCublasNDArray(data, shape);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape) {
        return new JCublasComplexNDArray(data, shape);
    }

    public IComplexNDArray createComplex(DataBuffer data, int[] shape, int[] stride) {
        return new JCublasComplexNDArray(data, shape, stride);
    }

    public INDArray create(DataBuffer data, int[] shape, int[] stride, int offset) {
        return new JCublasNDArray(data, shape, stride, offset);
    }

    public INDArray create(List<INDArray> list, int[] shape) {
        if (this.order == 'f') {
            return new JCublasNDArray(list, shape, ArrayUtil.calcStridesFortran((int[])shape));
        }
        return new JCublasNDArray(list, shape);
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new JCublasComplexNDArray(ArrayUtil.floatCopyOf((double[])data), shape, stride, offset, ordering);
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int offset, char ordering) {
        return new JCublasComplexNDArray(ArrayUtil.floatCopyOf((double[])data), shape, offset, ordering);
    }

    public IComplexNDArray createComplex(DataBuffer buffer, int[] shape, int offset, char ordering) {
        return new JCublasComplexNDArray(buffer, shape, offset, ordering);
    }

    public IComplexNDArray createComplex(double[] data, int[] shape, int offset) {
        return new JCublasComplexNDArray(ArrayUtil.floatCopyOf((double[])data), shape, offset);
    }

    public IComplexNDArray createComplex(DataBuffer buffer, int[] shape, int offset) {
        return new JCublasComplexNDArray(buffer, shape, offset);
    }

    public INDArray create(float[] data, int[] shape, int offset) {
        return new JCublasNDArray(data, shape, offset);
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int offset, char ordering) {
        return new JCublasComplexNDArray(data, shape, Nd4j.getComplexStrides((int[])shape, (char)ordering), offset, ordering);
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int offset) {
        return new JCublasComplexNDArray(data, shape, offset);
    }

    public IComplexNDArray createComplex(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new JCublasComplexNDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(float[][] floats) {
        return new JCublasNDArray(floats);
    }

    public INDArray create(float[][] data, char ordering) {
        return new JCublasNDArray(data, ordering);
    }

    public IComplexNDArray createComplex(float[] dim) {
        if (dim.length % 2 != 0) {
            throw new IllegalArgumentException("Complex nd array buffers must have an even number of elements");
        }
        IComplexNDArray ret = Nd4j.createComplex((int)(dim.length / 2));
        int count = 0;
        for (int i = 0; i < dim.length - 1; i += 2) {
            ret.putScalar(count++, (IComplexNumber)Nd4j.createDouble((double)dim[i], (double)dim[i + 1]));
        }
        return ret;
    }

    public INDArray create(float[] data, int[] shape, int[] stride, int offset, char ordering) {
        return new JCublasNDArray(data, shape, stride, offset, ordering);
    }

    public INDArray create(DataBuffer buffer, int[] shape, int offset) {
        return new JCublasNDArray(buffer, shape, offset);
    }

    public INDArray toFlattened(Collection<INDArray> matrices) {
        return this.toFlattened(this.order(), matrices);
    }

    public INDArray toFlattened(char order, Collection<INDArray> matrices) {
        int length = 0;
        for (INDArray m : matrices) {
            length += m.length();
        }
        INDArray ret = Nd4j.create((int[])new int[]{1, length}, (char)order);
        int linearIndex = 0;
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        for (INDArray m : matrices) {
            CudaContext context = allocator.getFlowController().prepareAction(ret, m);
            if (m.ordering() == order && ret.elementWiseStride() == m.elementWiseStride() && ret.elementWiseStride() == 1) {
                allocator.memcpyAsync(ret.data(), new CudaPointer(allocator.getHostPointer(m).address()), AllocationUtils.getRequiredMemory(AllocationUtils.buildAllocationShape(m)), linearIndex * (m.data().dataType() == DataBuffer.Type.DOUBLE ? 8 : 4));
                linearIndex += m.length();
            } else {
                Pointer hostYShapeInfo = AddressRetriever.retrieveHostPointer(m.shapeInfoDataBuffer());
                PointerPointer extras = new PointerPointer(new Pointer[]{AddressRetriever.retrieveHostPointer(ret.shapeInfoDataBuffer()), context.getOldStream(), allocator.getDeviceIdPointer(), context.getBufferAllocation(), context.getBufferReduction(), context.getBufferScalar(), context.getBufferSpecial(), hostYShapeInfo, AddressRetriever.retrieveHostPointer(ret.shapeInfoDataBuffer())});
                if (m.data().dataType() == DataBuffer.Type.DOUBLE) {
                    this.nativeOps.flattenDouble(extras, linearIndex, order, allocator.getPointer(ret, context), allocator.getPointer(ret.shapeInfoDataBuffer(), context), allocator.getPointer(m, context), allocator.getPointer(m.shapeInfoDataBuffer(), context));
                } else if (m.data().dataType() == DataBuffer.Type.FLOAT) {
                    this.nativeOps.flattenFloat(extras, linearIndex, order, allocator.getPointer(ret, context), allocator.getPointer(ret.shapeInfoDataBuffer(), context), allocator.getPointer(m, context), allocator.getPointer(m.shapeInfoDataBuffer(), context));
                } else {
                    throw new UnsupportedOperationException("Illegal data type for copy");
                }
                linearIndex += m.length();
            }
            if (ret == null) continue;
            allocator.registerAction(context, ret, m);
        }
        return ret;
    }

    public INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        int sumAlongDim = 0;
        for (int i = 0; i < toConcat.length; ++i) {
            sumAlongDim += toConcat[i].size(dimension);
        }
        int[] outputShape = ArrayUtil.copy((int[])toConcat[0].shape());
        outputShape[dimension] = sumAlongDim;
        INDArray ret = Nd4j.createUninitialized((int[])outputShape, (char)Nd4j.order().charValue());
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareAction(ret, toConcat);
        long[] shapeInfoPointers = new long[toConcat.length];
        long[] dataPointers = new long[toConcat.length];
        long[] tadPointers = new long[toConcat.length];
        long[] offsetsPointers = new long[toConcat.length];
        long[] hostShapeInfoPointers = new long[toConcat.length];
        JCudaExecutioner cfr_ignored_0 = (JCudaExecutioner)Nd4j.getExecutioner();
        TADManager tadManager = JCudaExecutioner.getTadManager();
        for (int i = 0; i < toConcat.length; ++i) {
            shapeInfoPointers[i] = AddressRetriever.retrieveDeviceAddress(toConcat[i].shapeInfoDataBuffer(), context);
            dataPointers[i] = AtomicAllocator.getInstance().getPointer(toConcat[i], context).address();
            hostShapeInfoPointers[i] = AtomicAllocator.getInstance().getHostPointer(toConcat[i].shapeInfoDataBuffer()).address();
            sumAlongDim += toConcat[i].size(dimension);
            for (int j = 0; j < toConcat[i].rank(); ++j) {
                if (j == dimension || toConcat[i].size(j) == outputShape[j]) continue;
                throw new IllegalArgumentException("Illegal concatneation at array " + i + " and shape element " + j);
            }
            Pair tadBuffers = tadManager.getTADOnlyShapeInfo(toConcat[i], new int[]{dimension});
            long devTadShapeInfo = AtomicAllocator.getInstance().getPointer((DataBuffer)tadBuffers.getFirst(), context).address();
            DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
            long devTadOffsets = AtomicAllocator.getInstance().getPointer(offsets, context).address();
            tadPointers[i] = devTadShapeInfo;
            offsetsPointers[i] = devTadOffsets;
        }
        Pointer dZ = AtomicAllocator.getInstance().getPointer(ret, context);
        Pointer dZShapeInfo = AddressRetriever.retrieveDevicePointer(ret.shapeInfoDataBuffer(), context);
        CudaDoubleDataBuffer tempData = new CudaDoubleDataBuffer(toConcat.length);
        CudaDoubleDataBuffer tempShapes = new CudaDoubleDataBuffer(toConcat.length);
        CudaDoubleDataBuffer tempTAD = new CudaDoubleDataBuffer(toConcat.length);
        CudaDoubleDataBuffer tempOffsets = new CudaDoubleDataBuffer(toConcat.length);
        AtomicAllocator.getInstance().memcpyBlocking(tempData, (Pointer)new LongPointer(dataPointers), dataPointers.length * 8, 0L);
        AtomicAllocator.getInstance().memcpyBlocking(tempShapes, (Pointer)new LongPointer(shapeInfoPointers), shapeInfoPointers.length * 8, 0L);
        AtomicAllocator.getInstance().memcpyBlocking(tempTAD, (Pointer)new LongPointer(tadPointers), tadPointers.length * 8, 0L);
        AtomicAllocator.getInstance().memcpyBlocking(tempOffsets, (Pointer)new LongPointer(offsetsPointers), offsetsPointers.length * 8, 0L);
        Pointer dataPointer = AtomicAllocator.getInstance().getPointer(tempData, context);
        Pointer shapesPointer = AtomicAllocator.getInstance().getPointer(tempShapes, context);
        Pointer tadPointer = AtomicAllocator.getInstance().getPointer(tempTAD, context);
        Pointer offsetPointer = AtomicAllocator.getInstance().getPointer(tempOffsets, context);
        PointerPointer extras = new PointerPointer(new Pointer[]{AddressRetriever.retrieveHostPointer(ret.shapeInfoDataBuffer()), context.getOldStream(), allocator.getDeviceIdPointer(), context.getBufferAllocation(), context.getBufferReduction(), context.getBufferScalar(), context.getBufferSpecial(), AddressRetriever.retrieveHostPointer(toConcat[0].shapeInfoDataBuffer()), AddressRetriever.retrieveHostPointer(ret.shapeInfoDataBuffer()), new LongPointer(hostShapeInfoPointers)});
        if (ret.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.concatDouble(extras, dimension, toConcat.length, new PointerPointer(new Pointer[]{dataPointer}), new PointerPointer(new Pointer[]{shapesPointer}), dZ, dZShapeInfo, new PointerPointer(new Pointer[]{tadPointer}), new PointerPointer(new Pointer[]{offsetPointer}));
        } else {
            this.nativeOps.concatFloat(extras, dimension, toConcat.length, new PointerPointer(new Pointer[]{dataPointer}), new PointerPointer(new Pointer[]{shapesPointer}), dZ, dZShapeInfo, new PointerPointer(new Pointer[]{tadPointer}), new PointerPointer(new Pointer[]{offsetPointer}));
        }
        allocator.registerAction(context, ret, toConcat);
        return ret;
    }

    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        int vectorLength = source.shape()[sourceDimension];
        INDArray ret = Nd4j.createUninitialized((int[])new int[]{indexes.length, vectorLength}, (char)this.order());
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareAction(ret, source);
        Pointer x = AtomicAllocator.getInstance().getPointer(source, context);
        Pointer xShape = AtomicAllocator.getInstance().getPointer(source.shapeInfoDataBuffer(), context);
        Pointer z = AtomicAllocator.getInstance().getPointer(ret, context);
        Pointer zShape = AtomicAllocator.getInstance().getPointer(ret.shapeInfoDataBuffer(), context);
        PointerPointer extras = new PointerPointer(new Pointer[]{AddressRetriever.retrieveHostPointer(ret.shapeInfoDataBuffer()), context.getOldStream(), allocator.getDeviceIdPointer()});
        CudaFloatDataBuffer tempIndexes = new CudaFloatDataBuffer(indexes.length);
        AtomicAllocator.getInstance().memcpyBlocking(tempIndexes, (Pointer)new IntPointer(indexes), indexes.length * 4, 0L);
        Pointer pIndex = AtomicAllocator.getInstance().getPointer(tempIndexes, context);
        JCudaExecutioner cfr_ignored_0 = (JCudaExecutioner)Nd4j.getExecutioner();
        TADManager tadManager = JCudaExecutioner.getTadManager();
        Pair tadBuffers = tadManager.getTADOnlyShapeInfo(source, new int[]{sourceDimension});
        Pointer tadShapeInfo = AtomicAllocator.getInstance().getPointer((DataBuffer)tadBuffers.getFirst(), context);
        DataBuffer offsets = (DataBuffer)tadBuffers.getSecond();
        Pointer tadOffsets = AtomicAllocator.getInstance().getPointer(offsets, context);
        if (ret.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.nativeOps.pullRowsDouble(extras, x, xShape, z, zShape, indexes.length, pIndex, tadShapeInfo, tadOffsets);
        } else if (ret.data().dataType() == DataBuffer.Type.FLOAT) {
            this.nativeOps.pullRowsFloat(extras, x, xShape, z, zShape, indexes.length, pIndex, tadShapeInfo, tadOffsets);
        }
        allocator.registerAction(context, ret, source);
        return ret;
    }
}

