/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.blas;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.nd4j.jita.allocator.Allocator;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t;
import org.nd4j.linalg.api.blas.impl.BaseLevel3;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.DataTypeValidation;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.nd4j.nativeblas.Nd4jBlas;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcublasLevel3
extends BaseLevel3 {
    private Allocator allocator = AtomicAllocator.getInstance();
    private Nd4jBlas nd4jBlas = new Nd4jBlas();
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private static Logger log = LoggerFactory.getLogger(JcublasLevel3.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sgemm(char Order, char TransA, char TransB, int M, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer cAPointer = new CublasPointer(A, ctx);
        CublasPointer cBPointer = new CublasPointer(B, ctx);
        CublasPointer cCPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.sgemm(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)TransA, (int)TransB, M, N, K, alpha, cAPointer.getDevicePointer(), lda, cBPointer.getDevicePointer(), ldb, beta, cCPointer.getDevicePointer(), ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ssymm(char Order, char Side, char Uplo, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.ssymm(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Side, (int)Uplo, M, N, alpha, aPointer.getDevicePointer(), lda, bPointer.getDevicePointer(), ldb, beta, cPointer.getDevicePointer(), ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ssyrk(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, float beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.ssyrk(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Uplo, (int)Trans, N, K, alpha, aPointer.getDevicePointer(), lda, beta, cPointer.getDevicePointer(), ldc);
        }
        this.allocator.registerAction(ctx, C, A);
    }

    protected void ssyr2k(char Order, char Uplo, char Trans, int N, int K, float alpha, INDArray A, int lda, INDArray B, int ldb, float beta, INDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void strmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void strsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, float alpha, INDArray A, int lda, INDArray B, int ldb) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(B, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.strsm(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Side, (int)Uplo, (int)TransA, (int)Diag, M, N, alpha, aPointer.getDevicePointer(), lda, bPointer.getDevicePointer(), ldb);
        }
        this.allocator.registerAction(ctx, B, A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dgemm(char Order, char TransA, char TransB, int M, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        DataTypeValidation.assertDouble((INDArray[])new INDArray[]{A, B, C});
        CublasPointer cAPointer = new CublasPointer(A, ctx);
        CublasPointer cBPointer = new CublasPointer(B, ctx);
        CublasPointer cCPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.dgemm(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)TransA, (int)TransB, M, N, K, alpha, cAPointer.getDevicePointer(), lda, cBPointer.getDevicePointer(), ldb, beta, cCPointer.getDevicePointer(), ldc);
            ctx.syncOldStream();
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dsymm(char Order, char Side, char Uplo, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.dsymm(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Side, (int)Uplo, M, N, alpha, aPointer.getDevicePointer(), lda, bPointer.getDevicePointer(), ldb, beta, cPointer.getDevicePointer(), ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dsyrk(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.dsyrk(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Uplo, (int)Trans, N, K, alpha, aPointer.getDevicePointer(), lda, beta, cPointer.getDevicePointer(), ldc);
        }
        this.allocator.registerAction(ctx, C, A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dsyr2k(char Order, char Uplo, char Trans, int N, int K, double alpha, INDArray A, int lda, INDArray B, int ldb, double beta, INDArray C, int ldc) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(C, A, B);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        CublasPointer cPointer = new CublasPointer(C, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.dsyr2k(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Uplo, (int)Trans, N, K, alpha, aPointer.getDevicePointer(), lda, bPointer.getDevicePointer(), ldb, beta, cPointer.getDevicePointer(), ldc);
        }
        this.allocator.registerAction(ctx, C, A, B);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dtrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(B, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.dtrmm(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Side, (int)Uplo, (int)TransA, (int)Diag, M, N, alpha, aPointer.getDevicePointer(), lda, bPointer.getDevicePointer(), ldb);
        }
        this.allocator.registerAction(ctx, B, A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dtrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, double alpha, INDArray A, int lda, INDArray B, int ldb) {
        cublasHandle_t handle;
        CudaContext ctx = this.allocator.getFlowController().prepareAction(B, A);
        CublasPointer aPointer = new CublasPointer(A, ctx);
        CublasPointer bPointer = new CublasPointer(B, ctx);
        cublasHandle_t cublasHandle_t2 = handle = ctx.getHandle();
        synchronized (cublasHandle_t2) {
            this.nativeOps.setBlasStream((Pointer)handle, (Pointer)ctx.getOldStream());
            this.nd4jBlas.dtrsm(new PointerPointer(new Pointer[]{ctx.getHandle()}), (int)Order, (int)Side, (int)Uplo, (int)TransA, (int)Diag, M, N, alpha, aPointer.getDevicePointer(), lda, bPointer.getDevicePointer(), ldb);
        }
        this.allocator.registerAction(ctx, B, A);
    }

    protected void cgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csymm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyrk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void csyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ctrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
    }

    protected void zgemm(char Order, char TransA, char TransB, int M, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsymm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyrk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zsyr2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrmm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void ztrsm(char Order, char Side, char Uplo, char TransA, char Diag, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb) {
        throw new UnsupportedOperationException();
    }

    protected void chemm(char Order, char Side, char Uplo, int M, int N, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cherk(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void cher2k(char Order, char Uplo, char Trans, int N, int K, IComplexFloat alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexFloat beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zhemm(char Order, char Side, char Uplo, int M, int N, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zherk(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }

    protected void zher2k(char Order, char Uplo, char Trans, int N, int K, IComplexDouble alpha, IComplexNDArray A, int lda, IComplexNDArray B, int ldb, IComplexDouble beta, IComplexNDArray C, int ldc) {
        throw new UnsupportedOperationException();
    }
}

