/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.context;

import java.util.concurrent.atomic.AtomicBoolean;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.garbage.GarbageResourceReference;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.cuda.cublasHandle_t;
import org.nd4j.jita.allocator.pointers.cuda.cudaStream_t;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;

public class CudaContext {
    private cudaStream_t oldStream;
    private cudaStream_t cublasStream;
    private cudaStream_t specialStream;
    private cublasHandle_t handle;
    private CublasPointer resultPointer;
    private AtomicBoolean oldStreamReturned = new AtomicBoolean(false);
    private AtomicBoolean handleReturned = new AtomicBoolean(false);
    private AtomicBoolean streamReturned = new AtomicBoolean(false);
    private boolean streamFromPool = true;
    private boolean handleFromPool = true;
    private boolean oldStreamFromPool = true;
    private boolean free = true;
    private boolean oldEventDestroyed = true;
    private boolean eventDestroyed = true;
    private Pointer bufferReduction;
    private Pointer bufferAllocation;
    private Pointer bufferScalar;
    private Pointer bufferSpecial;
    private GarbageResourceReference reference;
    private int laneId = 0;
    private static NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();

    public CudaContext(boolean free) {
        this();
        this.free = free;
    }

    public void attachReference(GarbageResourceReference ref) {
        this.reference = ref;
    }

    public CudaContext() {
    }

    public void syncStream() {
    }

    public void syncOldStream() {
        this.syncOldStream(false);
    }

    public void syncSpecialStream() {
        nativeOps.streamSynchronize((Pointer)this.specialStream);
    }

    public void syncOldStream(boolean syncCuBlas) {
        nativeOps.streamSynchronize((Pointer)this.oldStream);
        if (syncCuBlas) {
            this.syncCublasStream();
        }
    }

    public void syncCublasStream() {
        if (this.cublasStream == null) {
            throw new IllegalStateException("cuBLAS stream isnt set");
        }
        nativeOps.streamSynchronize((Pointer)this.cublasStream);
    }

    public synchronized void associateHandle() {
    }

    public void initStream() {
    }

    public void initOldStream() {
        if (this.oldStream == null) {
            this.oldStreamFromPool = false;
            this.oldStream = new cudaStream_t(nativeOps.createStream());
            this.specialStream = new cudaStream_t(nativeOps.createStream());
        }
    }

    public void initHandle() {
    }

    @Deprecated
    public void destroy(CublasPointer resultPointer, boolean freeIfNotEqual) {
    }

    @Deprecated
    public void destroy() {
    }

    public void finishBlasOperation() {
    }

    public static CudaContext getBlasContext() {
        CudaContext context = (CudaContext)AtomicAllocator.getInstance().getDeviceContext().getContext();
        return context;
    }

    public cudaStream_t getOldStream() {
        return this.oldStream;
    }

    public cudaStream_t getCublasStream() {
        return this.cublasStream;
    }

    public cudaStream_t getSpecialStream() {
        return this.specialStream;
    }

    public cublasHandle_t getHandle() {
        return this.handle;
    }

    public CublasPointer getResultPointer() {
        return this.resultPointer;
    }

    public AtomicBoolean getOldStreamReturned() {
        return this.oldStreamReturned;
    }

    public AtomicBoolean getHandleReturned() {
        return this.handleReturned;
    }

    public AtomicBoolean getStreamReturned() {
        return this.streamReturned;
    }

    public boolean isStreamFromPool() {
        return this.streamFromPool;
    }

    public boolean isHandleFromPool() {
        return this.handleFromPool;
    }

    public boolean isOldStreamFromPool() {
        return this.oldStreamFromPool;
    }

    public boolean isFree() {
        return this.free;
    }

    public boolean isOldEventDestroyed() {
        return this.oldEventDestroyed;
    }

    public boolean isEventDestroyed() {
        return this.eventDestroyed;
    }

    public Pointer getBufferReduction() {
        return this.bufferReduction;
    }

    public Pointer getBufferAllocation() {
        return this.bufferAllocation;
    }

    public Pointer getBufferScalar() {
        return this.bufferScalar;
    }

    public Pointer getBufferSpecial() {
        return this.bufferSpecial;
    }

    public GarbageResourceReference getReference() {
        return this.reference;
    }

    public int getLaneId() {
        return this.laneId;
    }

    public void setOldStream(cudaStream_t oldStream) {
        this.oldStream = oldStream;
    }

    public void setCublasStream(cudaStream_t cublasStream) {
        this.cublasStream = cublasStream;
    }

    public void setSpecialStream(cudaStream_t specialStream) {
        this.specialStream = specialStream;
    }

    public void setHandle(cublasHandle_t handle) {
        this.handle = handle;
    }

    public void setResultPointer(CublasPointer resultPointer) {
        this.resultPointer = resultPointer;
    }

    public void setOldStreamReturned(AtomicBoolean oldStreamReturned) {
        this.oldStreamReturned = oldStreamReturned;
    }

    public void setHandleReturned(AtomicBoolean handleReturned) {
        this.handleReturned = handleReturned;
    }

    public void setStreamReturned(AtomicBoolean streamReturned) {
        this.streamReturned = streamReturned;
    }

    public void setStreamFromPool(boolean streamFromPool) {
        this.streamFromPool = streamFromPool;
    }

    public void setHandleFromPool(boolean handleFromPool) {
        this.handleFromPool = handleFromPool;
    }

    public void setOldStreamFromPool(boolean oldStreamFromPool) {
        this.oldStreamFromPool = oldStreamFromPool;
    }

    public void setFree(boolean free) {
        this.free = free;
    }

    public void setOldEventDestroyed(boolean oldEventDestroyed) {
        this.oldEventDestroyed = oldEventDestroyed;
    }

    public void setEventDestroyed(boolean eventDestroyed) {
        this.eventDestroyed = eventDestroyed;
    }

    public void setBufferReduction(Pointer bufferReduction) {
        this.bufferReduction = bufferReduction;
    }

    public void setBufferAllocation(Pointer bufferAllocation) {
        this.bufferAllocation = bufferAllocation;
    }

    public void setBufferScalar(Pointer bufferScalar) {
        this.bufferScalar = bufferScalar;
    }

    public void setBufferSpecial(Pointer bufferSpecial) {
        this.bufferSpecial = bufferSpecial;
    }

    public void setReference(GarbageResourceReference reference) {
        this.reference = reference;
    }

    public void setLaneId(int laneId) {
        this.laneId = laneId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CudaContext)) {
            return false;
        }
        CudaContext other = (CudaContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        cudaStream_t this$oldStream = this.getOldStream();
        cudaStream_t other$oldStream = other.getOldStream();
        if (this$oldStream == null ? other$oldStream != null : !((Object)((Object)this$oldStream)).equals((Object)other$oldStream)) {
            return false;
        }
        cudaStream_t this$cublasStream = this.getCublasStream();
        cudaStream_t other$cublasStream = other.getCublasStream();
        if (this$cublasStream == null ? other$cublasStream != null : !((Object)((Object)this$cublasStream)).equals((Object)other$cublasStream)) {
            return false;
        }
        cudaStream_t this$specialStream = this.getSpecialStream();
        cudaStream_t other$specialStream = other.getSpecialStream();
        if (this$specialStream == null ? other$specialStream != null : !((Object)((Object)this$specialStream)).equals((Object)other$specialStream)) {
            return false;
        }
        cublasHandle_t this$handle = this.getHandle();
        cublasHandle_t other$handle = other.getHandle();
        if (this$handle == null ? other$handle != null : !((Object)((Object)this$handle)).equals((Object)other$handle)) {
            return false;
        }
        CublasPointer this$resultPointer = this.getResultPointer();
        CublasPointer other$resultPointer = other.getResultPointer();
        if (this$resultPointer == null ? other$resultPointer != null : !this$resultPointer.equals(other$resultPointer)) {
            return false;
        }
        AtomicBoolean this$oldStreamReturned = this.getOldStreamReturned();
        AtomicBoolean other$oldStreamReturned = other.getOldStreamReturned();
        if (this$oldStreamReturned == null ? other$oldStreamReturned != null : !this$oldStreamReturned.equals(other$oldStreamReturned)) {
            return false;
        }
        AtomicBoolean this$handleReturned = this.getHandleReturned();
        AtomicBoolean other$handleReturned = other.getHandleReturned();
        if (this$handleReturned == null ? other$handleReturned != null : !this$handleReturned.equals(other$handleReturned)) {
            return false;
        }
        AtomicBoolean this$streamReturned = this.getStreamReturned();
        AtomicBoolean other$streamReturned = other.getStreamReturned();
        if (this$streamReturned == null ? other$streamReturned != null : !this$streamReturned.equals(other$streamReturned)) {
            return false;
        }
        if (this.isStreamFromPool() != other.isStreamFromPool()) {
            return false;
        }
        if (this.isHandleFromPool() != other.isHandleFromPool()) {
            return false;
        }
        if (this.isOldStreamFromPool() != other.isOldStreamFromPool()) {
            return false;
        }
        if (this.isFree() != other.isFree()) {
            return false;
        }
        if (this.isOldEventDestroyed() != other.isOldEventDestroyed()) {
            return false;
        }
        if (this.isEventDestroyed() != other.isEventDestroyed()) {
            return false;
        }
        Pointer this$bufferReduction = this.getBufferReduction();
        Pointer other$bufferReduction = other.getBufferReduction();
        if (this$bufferReduction == null ? other$bufferReduction != null : !this$bufferReduction.equals(other$bufferReduction)) {
            return false;
        }
        Pointer this$bufferAllocation = this.getBufferAllocation();
        Pointer other$bufferAllocation = other.getBufferAllocation();
        if (this$bufferAllocation == null ? other$bufferAllocation != null : !this$bufferAllocation.equals(other$bufferAllocation)) {
            return false;
        }
        Pointer this$bufferScalar = this.getBufferScalar();
        Pointer other$bufferScalar = other.getBufferScalar();
        if (this$bufferScalar == null ? other$bufferScalar != null : !this$bufferScalar.equals(other$bufferScalar)) {
            return false;
        }
        Pointer this$bufferSpecial = this.getBufferSpecial();
        Pointer other$bufferSpecial = other.getBufferSpecial();
        if (this$bufferSpecial == null ? other$bufferSpecial != null : !this$bufferSpecial.equals(other$bufferSpecial)) {
            return false;
        }
        GarbageResourceReference this$reference = this.getReference();
        GarbageResourceReference other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        return this.getLaneId() == other.getLaneId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CudaContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        cudaStream_t $oldStream = this.getOldStream();
        result = result * 59 + ($oldStream == null ? 0 : ((Object)((Object)$oldStream)).hashCode());
        cudaStream_t $cublasStream = this.getCublasStream();
        result = result * 59 + ($cublasStream == null ? 0 : ((Object)((Object)$cublasStream)).hashCode());
        cudaStream_t $specialStream = this.getSpecialStream();
        result = result * 59 + ($specialStream == null ? 0 : ((Object)((Object)$specialStream)).hashCode());
        cublasHandle_t $handle = this.getHandle();
        result = result * 59 + ($handle == null ? 0 : ((Object)((Object)$handle)).hashCode());
        CublasPointer $resultPointer = this.getResultPointer();
        result = result * 59 + ($resultPointer == null ? 0 : $resultPointer.hashCode());
        AtomicBoolean $oldStreamReturned = this.getOldStreamReturned();
        result = result * 59 + ($oldStreamReturned == null ? 0 : $oldStreamReturned.hashCode());
        AtomicBoolean $handleReturned = this.getHandleReturned();
        result = result * 59 + ($handleReturned == null ? 0 : $handleReturned.hashCode());
        AtomicBoolean $streamReturned = this.getStreamReturned();
        result = result * 59 + ($streamReturned == null ? 0 : $streamReturned.hashCode());
        result = result * 59 + (this.isStreamFromPool() ? 79 : 97);
        result = result * 59 + (this.isHandleFromPool() ? 79 : 97);
        result = result * 59 + (this.isOldStreamFromPool() ? 79 : 97);
        result = result * 59 + (this.isFree() ? 79 : 97);
        result = result * 59 + (this.isOldEventDestroyed() ? 79 : 97);
        result = result * 59 + (this.isEventDestroyed() ? 79 : 97);
        Pointer $bufferReduction = this.getBufferReduction();
        result = result * 59 + ($bufferReduction == null ? 0 : $bufferReduction.hashCode());
        Pointer $bufferAllocation = this.getBufferAllocation();
        result = result * 59 + ($bufferAllocation == null ? 0 : $bufferAllocation.hashCode());
        Pointer $bufferScalar = this.getBufferScalar();
        result = result * 59 + ($bufferScalar == null ? 0 : $bufferScalar.hashCode());
        Pointer $bufferSpecial = this.getBufferSpecial();
        result = result * 59 + ($bufferSpecial == null ? 0 : $bufferSpecial.hashCode());
        GarbageResourceReference $reference = this.getReference();
        result = result * 59 + ($reference == null ? 0 : $reference.hashCode());
        result = result * 59 + this.getLaneId();
        return result;
    }

    public String toString() {
        return "CudaContext(oldStream=" + (Object)((Object)this.getOldStream()) + ", cublasStream=" + (Object)((Object)this.getCublasStream()) + ", specialStream=" + (Object)((Object)this.getSpecialStream()) + ", handle=" + (Object)((Object)this.getHandle()) + ", resultPointer=" + this.getResultPointer() + ", oldStreamReturned=" + this.getOldStreamReturned() + ", handleReturned=" + this.getHandleReturned() + ", streamReturned=" + this.getStreamReturned() + ", streamFromPool=" + this.isStreamFromPool() + ", handleFromPool=" + this.isHandleFromPool() + ", oldStreamFromPool=" + this.isOldStreamFromPool() + ", free=" + this.isFree() + ", oldEventDestroyed=" + this.isOldEventDestroyed() + ", eventDestroyed=" + this.isEventDestroyed() + ", bufferReduction=" + this.getBufferReduction() + ", bufferAllocation=" + this.getBufferAllocation() + ", bufferScalar=" + this.getBufferScalar() + ", bufferSpecial=" + this.getBufferSpecial() + ", reference=" + this.getReference() + ", laneId=" + this.getLaneId() + ")";
    }
}

