/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.allocator.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.jita.allocator.garbage.GarbageBufferReference;
import org.nd4j.jita.allocator.impl.AllocationShape;
import org.nd4j.jita.allocator.pointers.PointersPair;
import org.nd4j.jita.allocator.pointers.cuda.cudaEvent_t;
import org.nd4j.jita.allocator.time.TimeProvider;
import org.nd4j.jita.allocator.time.providers.MillisecondsProvider;
import org.nd4j.jita.allocator.time.providers.OperativeProvider;
import org.nd4j.linalg.api.buffer.BaseDataBuffer;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocationPoint {
    private static Logger log = LoggerFactory.getLogger(AllocationPoint.class);
    private volatile PointersPair pointerInfo;
    private Long objectId;
    private Long bucketId;
    private volatile AllocationStatus allocationStatus = AllocationStatus.UNDEFINED;
    private transient TimeProvider timeProvider = new OperativeProvider();
    private transient TimeProvider realTimeProvider = new MillisecondsProvider();
    private final AtomicLong accessHostRead = new AtomicLong(0L);
    private final AtomicLong accessDeviceRead = new AtomicLong(0L);
    private final AtomicLong accessHostWrite = new AtomicLong(0L);
    private final AtomicLong accessDeviceWrite = new AtomicLong(0L);
    private final List<Long> threadsTrace = new ArrayList<Long>();
    private final AtomicLong deviceAccessTime = new AtomicLong(0L);
    protected static final NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    protected volatile cudaEvent_t writeLane;
    protected Queue<cudaEvent_t> readLane = new ConcurrentLinkedQueue<cudaEvent_t>();
    private boolean constant;
    private volatile int deviceId;
    private volatile ReentrantLock lock = new ReentrantLock();
    private AllocationShape shape;
    private AtomicLong deviceTicks = new AtomicLong(0L);
    private volatile WeakReference<BaseDataBuffer> originalDataBufferReference;
    private volatile GarbageBufferReference garbageBufferReference;
    private AtomicBoolean enqueued = new AtomicBoolean(false);
    private cudaEvent_t lastWriteEvent;
    private cudaEvent_t lastReadEvent;
    private cudaEvent_t lastEvent;
    private volatile CudaContext currentContext;

    public void acquireLock() {
    }

    public void releaseLock() {
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public boolean isEnqueued() {
        return this.enqueued.get();
    }

    public void markEnqueued(boolean reallyEnqueued) {
        this.enqueued.set(reallyEnqueued);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CudaContext getCurrentContext() {
        AllocationPoint allocationPoint = this;
        synchronized (allocationPoint) {
            return this.currentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentContext(CudaContext context) {
        AllocationPoint allocationPoint = this;
        synchronized (allocationPoint) {
            this.currentContext = context;
        }
    }

    public void addReadLane(cudaEvent_t event) {
        this.readLane.add(event);
    }

    public void setLastEvent(cudaEvent_t event) {
        if (event != null && this.lastEvent != null) {
            nativeOps.destroyEvent((Pointer)this.lastEvent);
        }
        this.lastEvent = event;
    }

    public List<Long> getThreadsTrace() {
        return this.threadsTrace;
    }

    public void addThreadToTrace(Long threadId) {
        if (!this.threadsTrace.contains(threadId)) {
            this.threadsTrace.add(threadId);
        }
    }

    public cudaEvent_t getLastEvent() {
        return this.lastEvent;
    }

    public void attachBuffer(@NonNull BaseDataBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.originalDataBufferReference = new WeakReference<BaseDataBuffer>(buffer);
    }

    public void attachReference(GarbageBufferReference reference) {
        this.garbageBufferReference = reference;
    }

    public DataBuffer getBuffer() {
        if (this.originalDataBufferReference != null) {
            return (DataBuffer)this.originalDataBufferReference.get();
        }
        return null;
    }

    public AllocationStatus getAllocationStatus() {
        return this.allocationStatus;
    }

    public void setAllocationStatus(@NonNull AllocationStatus status) {
        if (status == null) {
            throw new NullPointerException("status");
        }
        this.allocationStatus = status;
    }

    public Pointer getDevicePointer() {
        if (this.pointerInfo == null) {
            log.info("pointerInfo is null");
            return null;
        }
        return this.pointerInfo.getDevicePointer();
    }

    public Pointer getHostPointer() {
        if (this.pointerInfo == null) {
            return null;
        }
        return this.pointerInfo.getHostPointer();
    }

    public void setPointers(@NonNull PointersPair pointerInfo) {
        if (pointerInfo == null) {
            throw new NullPointerException("pointerInfo");
        }
        this.pointerInfo = pointerInfo;
    }

    public PointersPair getPointers() {
        return this.pointerInfo;
    }

    public long getDeviceTicks() {
        return this.deviceTicks.get();
    }

    public void tickDeviceRead() {
        this.accessDeviceRead.set(this.timeProvider.getCurrentTime());
    }

    public void tackDevice() {
        this.accessDeviceRead.set(this.timeProvider.getCurrentTime());
        this.deviceAccessTime.set(this.realTimeProvider.getCurrentTime());
    }

    public long getHostReadTime() {
        return this.accessHostRead.get();
    }

    public long getHostWriteTime() {
        return this.accessHostWrite.get();
    }

    public long getRealDeviceAccessTime() {
        return this.deviceAccessTime.get();
    }

    public long getDeviceAccessTime() {
        return this.accessDeviceRead.get();
    }

    public long getDeviceWriteTime() {
        return this.accessDeviceWrite.get();
    }

    public void tickHostRead() {
        this.accessHostRead.set(this.timeProvider.getCurrentTime());
    }

    public void tickDeviceWrite() {
        this.tickDeviceRead();
        this.accessDeviceWrite.set(this.timeProvider.getCurrentTime());
    }

    public void tickHostWrite() {
        this.tickHostRead();
        this.accessHostWrite.set(this.timeProvider.getCurrentTime());
    }

    public boolean isActualOnHostSide() {
        boolean result = this.accessHostWrite.get() >= this.accessDeviceWrite.get() || this.accessHostRead.get() >= this.accessDeviceWrite.get();
        return result;
    }

    public boolean isActualOnDeviceSide() {
        boolean result = this.accessDeviceWrite.get() >= this.accessHostWrite.get() || this.accessDeviceRead.get() >= this.accessHostWrite.get();
        return result;
    }

    public void tickDeviceToHost() {
        this.accessDeviceRead.set(this.accessHostRead.get());
        this.deviceAccessTime.set(this.realTimeProvider.getCurrentTime());
    }

    public String toString() {
        return "AllocationPoint{deviceId=" + this.deviceId + ", objectId=" + this.objectId + ", shape=" + this.shape + '}';
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public Long getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(Long bucketId) {
        this.bucketId = bucketId;
    }

    public cudaEvent_t getWriteLane() {
        return this.writeLane;
    }

    public void setWriteLane(cudaEvent_t writeLane) {
        this.writeLane = writeLane;
    }

    public Queue<cudaEvent_t> getReadLane() {
        return this.readLane;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public AllocationShape getShape() {
        return this.shape;
    }

    public void setShape(AllocationShape shape) {
        this.shape = shape;
    }

    public cudaEvent_t getLastWriteEvent() {
        return this.lastWriteEvent;
    }

    public void setLastWriteEvent(cudaEvent_t lastWriteEvent) {
        this.lastWriteEvent = lastWriteEvent;
    }

    public cudaEvent_t getLastReadEvent() {
        return this.lastReadEvent;
    }

    public void setLastReadEvent(cudaEvent_t lastReadEvent) {
        this.lastReadEvent = lastReadEvent;
    }
}

