/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.jita.conf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.NonNull;
import org.nd4j.jita.allocator.enums.Aggressiveness;
import org.nd4j.jita.allocator.enums.AllocationStatus;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private ExecutionModel executionModel = ExecutionModel.SEQUENTIAL;
    private AllocationModel allocationModel = AllocationModel.CACHE_ALL;
    private AllocationStatus firstMemory = AllocationStatus.DEVICE;
    private MemoryModel memoryModel = MemoryModel.IMMEDIATE;
    private boolean debug = false;
    private boolean verbose = false;
    private boolean fillDashboard = false;
    private boolean forceSingleGPU = false;
    private long noGcWindowMs = 100L;
    private double maximumDeviceMemoryUsed = 0.85;
    private int minimumRelocationThreshold = 5;
    private long minimumTTLMilliseconds = 10000L;
    private int numberOfGcThreads = 6;
    @Deprecated
    private Aggressiveness hostDeallocAggressiveness = Aggressiveness.REASONABLE;
    @Deprecated
    private Aggressiveness gpuDeallocAggressiveness = Aggressiveness.REASONABLE;
    @Deprecated
    private Aggressiveness gpuAllocAggressiveness = Aggressiveness.REASONABLE;
    private long maximumDeviceAllocation = 0x100000000L;
    private long maximumZeroAllocation = Runtime.getRuntime().maxMemory() + 524288000L;
    private boolean crossDeviceAccessAllowed = true;
    private boolean zeroCopyFallbackAllowed = false;
    private long maximumSingleHostAllocation = Long.MAX_VALUE;
    private long maximumSingleDeviceAllocation = 0x40000000L;
    private List<Integer> availableDevices = new ArrayList<Integer>();
    private List<Integer> bannedDevices = new ArrayList<Integer>();
    private int maximumGridSize = 4096;
    private int maximumBlockSize = 256;
    private int minimumBlockSize = 32;
    private long maximumHostCache = 0xC0000000L;
    private long maximumDeviceCache = 0x20000000L;
    private boolean usePreallocation = false;
    private int preallocationCalls = 10;
    private long maximumHostCacheableLength = 0x6000000L;
    private long maximumDeviceCacheableLength = 0x1000000L;
    private int commandQueueLength = 3;
    private int commandLanesNumber = 4;
    private int debugTriggered = 0;
    private int poolSize = 32;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final String MAX_BLOCK_SIZE = "ND4J_CUDA_MAX_BLOCK_SIZE";
    private static final String MIN_BLOCK_SIZE = "ND4J_CUDA_MIN_BLOCK_SIZE";
    private static final String MAX_GRID_SIZE = "ND4J_CUDA_MAX_GRID_SIZE";
    private static final String DEBUG_ENABLED = "ND4J_DEBUG";
    private static final String VERBOSE = "ND4J_VERBOSE";
    private static final String USE_PREALLOCATION = "ND4J_CUDA_USE_PREALLOCATION";
    private static final String MAX_DEVICE_CACHE = "ND4J_CUDA_MAX_DEVICE_CACHE";
    private static final String MAX_HOST_CACHE = "ND4J_CUDA_MAX_HOST_CACHE";
    private static final String MAX_DEVICE_ALLOCATION = "ND4J_CUDA_MAX_DEVICE_ALLOCATION";
    private static final String FORCE_SINGLE_GPU = "ND4J_CUDA_FORCE_SINGLE_GPU";

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void setInitialized() {
        this.initialized.compareAndSet(false, true);
    }

    private void parseEnvironmentVariables() {
        int var;
        Map<String, String> env = System.getenv();
        if (env.containsKey(MAX_BLOCK_SIZE)) {
            try {
                var = Integer.parseInt(env.get(MAX_BLOCK_SIZE));
                this.setMaximumBlockSize(var);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)MAX_BLOCK_SIZE, (Object)env.get(MAX_BLOCK_SIZE));
            }
        }
        if (env.containsKey(MIN_BLOCK_SIZE)) {
            try {
                var = Integer.parseInt(env.get(MIN_BLOCK_SIZE));
                this.setMinimumBlockSize(var);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)MIN_BLOCK_SIZE, (Object)env.get(MIN_BLOCK_SIZE));
            }
        }
        if (env.containsKey(MAX_GRID_SIZE)) {
            try {
                int var2 = Integer.parseInt(env.get(MAX_GRID_SIZE));
                this.setMaximumGridSize(var2);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)MAX_GRID_SIZE, (Object)env.get(MAX_GRID_SIZE));
            }
        }
        if (env.containsKey(DEBUG_ENABLED)) {
            try {
                boolean var3 = Boolean.parseBoolean(env.get(DEBUG_ENABLED));
                this.enableDebug(var3);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)DEBUG_ENABLED, (Object)env.get(DEBUG_ENABLED));
            }
        }
        if (env.containsKey(FORCE_SINGLE_GPU)) {
            try {
                boolean var4 = Boolean.parseBoolean(env.get(FORCE_SINGLE_GPU));
                this.allowMultiGPU(!var4);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)FORCE_SINGLE_GPU, (Object)env.get(FORCE_SINGLE_GPU));
            }
        }
        if (env.containsKey(VERBOSE)) {
            try {
                boolean var5 = Boolean.parseBoolean(env.get(VERBOSE));
                this.setVerbose(var5);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)VERBOSE, (Object)env.get(VERBOSE));
            }
        }
        if (env.containsKey(USE_PREALLOCATION)) {
            try {
                boolean var6 = Boolean.parseBoolean(env.get(USE_PREALLOCATION));
                this.allowPreallocation(var6);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)USE_PREALLOCATION, (Object)env.get(USE_PREALLOCATION));
            }
        }
        if (env.containsKey(MAX_DEVICE_CACHE)) {
            try {
                long var7 = Long.parseLong(env.get(MAX_DEVICE_CACHE));
                this.setMaximumDeviceCache(var7);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)MAX_DEVICE_CACHE, (Object)env.get(MAX_DEVICE_CACHE));
            }
        }
        if (env.containsKey(MAX_HOST_CACHE)) {
            try {
                long var8 = Long.parseLong(env.get(MAX_HOST_CACHE));
                this.setMaximumHostCache(var8);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)MAX_HOST_CACHE, (Object)env.get(MAX_HOST_CACHE));
            }
        }
        if (env.containsKey(MAX_DEVICE_ALLOCATION)) {
            try {
                long var9 = Long.parseLong(env.get(MAX_DEVICE_ALLOCATION));
                this.setMaximumSingleDeviceAllocation(var9);
            }
            catch (Exception e) {
                log.error("Can't parse {}: [{}]", (Object)MAX_DEVICE_ALLOCATION, (Object)env.get(MAX_DEVICE_ALLOCATION));
            }
        }
    }

    public Configuration enableDashboard(boolean reallyEnable) {
        this.fillDashboard = reallyEnable;
        return this;
    }

    public Configuration setPoolSize(int poolSize) {
        if (poolSize < 8) {
            throw new IllegalStateException("poolSize can't be lower then 8");
        }
        this.poolSize = poolSize;
        return this;
    }

    public Configuration triggerDebug(int code) {
        this.debugTriggered = code;
        return this;
    }

    public Configuration setMinimumRelocationThreshold(int threshold) {
        this.maximumDeviceAllocation = Math.max(2, threshold);
        return this;
    }

    public Configuration setMaximumHostCache(long maxCache) {
        this.maximumHostCache = maxCache;
        return this;
    }

    public Configuration setMaximumDeviceCache(long maxCache) {
        this.maximumDeviceCache = maxCache;
        return this;
    }

    public Configuration setMaximumDeviceMemoryUsed(double percentage) {
        this.maximumDeviceMemoryUsed = percentage < 0.02 || percentage > 0.95 ? 0.85 : percentage;
        return this;
    }

    public Configuration() {
        this.parseEnvironmentVariables();
    }

    void updateDevice() {
        int cnt = Nd4j.getAffinityManager().getNumberOfDevices();
        if (cnt == 0) {
            throw new RuntimeException("No CUDA devices were found in system");
        }
        for (int i = 0; i < cnt; ++i) {
            this.availableDevices.add(i);
        }
    }

    public boolean isP2PSupported() {
        return NativeOpsHolder.getInstance().getDeviceNativeOps().isP2PAvailable();
    }

    public Configuration banDevice(@NonNull Integer deviceId) {
        if (deviceId == null) {
            throw new NullPointerException("deviceId");
        }
        if (!this.availableDevices.contains(deviceId)) {
            return this;
        }
        if (!this.bannedDevices.contains(deviceId)) {
            this.bannedDevices.add(deviceId);
        }
        this.availableDevices.remove(deviceId);
        return this;
    }

    public Configuration useDevice(@NonNull Integer deviceId) {
        if (deviceId == null) {
            throw new NullPointerException("deviceId");
        }
        return this.useDevices(deviceId);
    }

    public Configuration useDevices(int ... devices) {
        if (devices == null) {
            throw new NullPointerException("devices");
        }
        ArrayList<Integer> usableDevices = new ArrayList<Integer>();
        for (int device : devices) {
            if (!this.availableDevices.contains(device)) {
                log.warn("Non-existent device [{}] requested, ignoring...", (Object)device);
                continue;
            }
            if (usableDevices.contains(device)) continue;
            usableDevices.add(device);
        }
        if (usableDevices.size() > 0) {
            this.availableDevices.clear();
            this.availableDevices.addAll(usableDevices);
        }
        return this;
    }

    public Configuration setMaximumZeroAllocation(long max) {
        long xmx = Runtime.getRuntime().maxMemory();
        if (max < xmx) {
            log.warn("Setting maximum memory below -Xmx value can cause problems");
        }
        if (max <= 0L) {
            throw new IllegalStateException("You can't set maximum host memory <= 0");
        }
        this.maximumZeroAllocation = max;
        return this;
    }

    public Configuration setMaximumDeviceAllocation(long max) {
        if (max < 0L) {
            throw new IllegalStateException("You can't set maximum device memory < 0");
        }
        return this;
    }

    public Configuration setMaximumSingleHostAllocation(long max) {
        this.maximumSingleHostAllocation = max;
        return this;
    }

    public Configuration setMaximumSingleDeviceAllocation(long max) {
        this.maximumSingleDeviceAllocation = max;
        return this;
    }

    public Configuration setMaximumGridSize(int gridDim) {
        if (gridDim <= 7 || gridDim > 8192) {
            throw new IllegalStateException("Please keep gridDim in range [8...8192]");
        }
        this.maximumGridSize = gridDim;
        return this;
    }

    public Configuration setMaximumBlockSize(int blockDim) {
        if (blockDim < 32 || blockDim > 768) {
            throw new IllegalStateException("Please keep blockDim in range [32...768]");
        }
        this.maximumBlockSize = blockDim;
        return this;
    }

    public Configuration setMinimumBlockSize(int blockDim) {
        if (blockDim < 32 || blockDim > 768) {
            throw new IllegalStateException("Please keep blockDim in range [32...768]");
        }
        this.minimumBlockSize = blockDim;
        return this;
    }

    public Configuration enableDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public Configuration setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public Configuration allowCrossDeviceAccess(boolean reallyAllow) {
        this.crossDeviceAccessAllowed = reallyAllow;
        return this;
    }

    public Configuration setExecutionModel(@NonNull ExecutionModel executionModel) {
        if (executionModel == null) {
            throw new NullPointerException("executionModel");
        }
        this.executionModel = ExecutionModel.SEQUENTIAL;
        return this;
    }

    public Configuration setAllocationModel(@NonNull AllocationModel allocationModel) {
        if (allocationModel == null) {
            throw new NullPointerException("allocationModel");
        }
        this.allocationModel = allocationModel;
        return this;
    }

    public Configuration setFirstMemory(@NonNull AllocationStatus initialMemory) {
        if (initialMemory == null) {
            throw new NullPointerException("initialMemory");
        }
        if (initialMemory != AllocationStatus.DEVICE && initialMemory != AllocationStatus.HOST && initialMemory != AllocationStatus.DELAYED) {
            throw new IllegalStateException("First memory should be either [HOST], [DEVICE] or [DELAYED]");
        }
        this.firstMemory = initialMemory;
        return this;
    }

    public Configuration allowFallbackFromDevice(boolean reallyAllow) {
        this.zeroCopyFallbackAllowed = reallyAllow;
        return this;
    }

    public Configuration setNumberOfGcThreads(int numThreads) {
        if (numThreads <= 0 || numThreads > 20) {
            throw new IllegalStateException("Please, use something in range of [1..20] as number of GC threads");
        }
        if (!this.isInitialized()) {
            this.numberOfGcThreads = numThreads;
        }
        return this;
    }

    public Configuration setMaximumHostCacheableLength(long maxLen) {
        this.maximumHostCacheableLength = maxLen;
        return this;
    }

    public Configuration setMaximumDeviceCacheableLength(long maxLen) {
        this.maximumDeviceCacheableLength = maxLen;
        return this;
    }

    public Configuration allowPreallocation(boolean reallyAllow) {
        this.usePreallocation = reallyAllow;
        return this;
    }

    public Configuration setPreallocationCalls(int numCalls) {
        if (numCalls < 0 || numCalls > 100) {
            throw new IllegalStateException("Please use preallocation calls in range of [1..100]");
        }
        this.preallocationCalls = numCalls;
        return this;
    }

    public Configuration setCommandQueueLength(int length) {
        if (length <= 0) {
            throw new IllegalStateException("Command queue length can't be <= 0");
        }
        this.commandQueueLength = length;
        return this;
    }

    public Configuration setNoGcWindowMs(long windowMs) {
        if (windowMs < 1L) {
            throw new IllegalStateException("No-GC window should have positive value");
        }
        this.noGcWindowMs = windowMs;
        return this;
    }

    public Configuration setCommandLanesNumber(int length) {
        if (length < 1) {
            throw new IllegalStateException("Command Lanes number can't be < 1");
        }
        if (length > 8) {
            length = 8;
        }
        this.commandLanesNumber = length;
        return this;
    }

    public boolean isForcedSingleGPU() {
        return this.forceSingleGPU;
    }

    public Configuration allowMultiGPU(boolean reallyAllow) {
        this.forceSingleGPU = !reallyAllow;
        return this;
    }

    public Configuration setMemoryModel(@NonNull MemoryModel model) {
        if (model == null) {
            throw new NullPointerException("model");
        }
        this.memoryModel = model;
        return this;
    }

    public ExecutionModel getExecutionModel() {
        return this.executionModel;
    }

    public AllocationModel getAllocationModel() {
        return this.allocationModel;
    }

    public AllocationStatus getFirstMemory() {
        return this.firstMemory;
    }

    public MemoryModel getMemoryModel() {
        return this.memoryModel;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isFillDashboard() {
        return this.fillDashboard;
    }

    public long getNoGcWindowMs() {
        return this.noGcWindowMs;
    }

    public double getMaximumDeviceMemoryUsed() {
        return this.maximumDeviceMemoryUsed;
    }

    public int getMinimumRelocationThreshold() {
        return this.minimumRelocationThreshold;
    }

    public long getMinimumTTLMilliseconds() {
        return this.minimumTTLMilliseconds;
    }

    public int getNumberOfGcThreads() {
        return this.numberOfGcThreads;
    }

    @Deprecated
    public Aggressiveness getHostDeallocAggressiveness() {
        return this.hostDeallocAggressiveness;
    }

    @Deprecated
    public Aggressiveness getGpuDeallocAggressiveness() {
        return this.gpuDeallocAggressiveness;
    }

    @Deprecated
    public Aggressiveness getGpuAllocAggressiveness() {
        return this.gpuAllocAggressiveness;
    }

    public long getMaximumDeviceAllocation() {
        return this.maximumDeviceAllocation;
    }

    public long getMaximumZeroAllocation() {
        return this.maximumZeroAllocation;
    }

    public boolean isCrossDeviceAccessAllowed() {
        return this.crossDeviceAccessAllowed;
    }

    public boolean isZeroCopyFallbackAllowed() {
        return this.zeroCopyFallbackAllowed;
    }

    public long getMaximumSingleHostAllocation() {
        return this.maximumSingleHostAllocation;
    }

    public long getMaximumSingleDeviceAllocation() {
        return this.maximumSingleDeviceAllocation;
    }

    public List<Integer> getAvailableDevices() {
        return this.availableDevices;
    }

    public List<Integer> getBannedDevices() {
        return this.bannedDevices;
    }

    public int getMaximumGridSize() {
        return this.maximumGridSize;
    }

    public int getMaximumBlockSize() {
        return this.maximumBlockSize;
    }

    public int getMinimumBlockSize() {
        return this.minimumBlockSize;
    }

    public long getMaximumHostCache() {
        return this.maximumHostCache;
    }

    public long getMaximumDeviceCache() {
        return this.maximumDeviceCache;
    }

    public boolean isUsePreallocation() {
        return this.usePreallocation;
    }

    public int getPreallocationCalls() {
        return this.preallocationCalls;
    }

    public long getMaximumHostCacheableLength() {
        return this.maximumHostCacheableLength;
    }

    public long getMaximumDeviceCacheableLength() {
        return this.maximumDeviceCacheableLength;
    }

    public int getCommandQueueLength() {
        return this.commandQueueLength;
    }

    public int getCommandLanesNumber() {
        return this.commandLanesNumber;
    }

    public int getDebugTriggered() {
        return this.debugTriggered;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public static enum MemoryModel {
        IMMEDIATE,
        DELAYED;

    }

    public static enum AllocationModel {
        DIRECT,
        CACHE_HOST,
        CACHE_ALL;

    }

    public static enum ExecutionModel {
        SEQUENTIAL,
        ASYNCHRONOUS,
        OPTIMIZED;

    }
}

