/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.jcublas.blas;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.cuda;
import org.bytedeco.javacpp.cusolver;
import org.nd4j.jita.allocator.Allocator;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.allocator.pointers.CudaPointer;
import org.nd4j.jita.allocator.pointers.cuda.cusolverDnHandle_t;
import org.nd4j.linalg.api.blas.BlasException;
import org.nd4j.linalg.api.blas.impl.BaseLapack;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;
import org.nd4j.linalg.jcublas.CublasPointer;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcublasLapack
extends BaseLapack {
    private static final Logger log = LoggerFactory.getLogger(JcublasLapack.class);
    private NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
    private Allocator allocator = AtomicAllocator.getInstance();
    private Method cusolverDnSorgqr;
    private Method cusolverDnSorgqr_bufferSize;
    private Method cusolverDnDorgqr;
    private Method cusolverDnDorgqr_bufferSize;
    private Method cusolverDnSsyevd_bufferSize;
    private Method cusolverDnSsyevd;
    private Method cusolverDnDsyevd_bufferSize;
    private Method cusolverDnDsyevd;
    private int CUSOLVER_EIG_MODE_VECTOR;
    private int CUSOLVER_EIG_MODE_NOVECTOR;

    public JcublasLapack() {
        Class<cusolver> c = cusolver.class;
        try {
            this.cusolverDnSorgqr_bufferSize = c.getMethod("cusolverDnSorgqr_bufferSize", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, FloatPointer.class, Integer.TYPE, FloatPointer.class, IntPointer.class);
            this.cusolverDnSorgqr = c.getMethod("cusolverDnSorgqr", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, FloatPointer.class, Integer.TYPE, FloatPointer.class, FloatPointer.class, Integer.TYPE, IntPointer.class);
            this.cusolverDnDorgqr_bufferSize = c.getMethod("cusolverDnDorgqr_bufferSize", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, DoublePointer.class, Integer.TYPE, DoublePointer.class, IntPointer.class);
            this.cusolverDnDorgqr = c.getMethod("cusolverDnDorgqr", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, DoublePointer.class, Integer.TYPE, DoublePointer.class, DoublePointer.class, Integer.TYPE, IntPointer.class);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            log.warn("cusolverDnSorgqr() and cusolverDnDorgqr() are not available", (Throwable)ex);
        }
        try {
            this.cusolverDnSsyevd_bufferSize = c.getMethod("cusolverDnSsyevd_bufferSize", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, FloatPointer.class, Integer.TYPE, FloatPointer.class, IntPointer.class);
            this.cusolverDnSsyevd = c.getMethod("cusolverDnSsyevd", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, FloatPointer.class, Integer.TYPE, FloatPointer.class, FloatPointer.class, Integer.TYPE, IntPointer.class);
            this.cusolverDnDsyevd_bufferSize = c.getMethod("cusolverDnDsyevd_bufferSize", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, DoublePointer.class, Integer.TYPE, DoublePointer.class, IntPointer.class);
            this.cusolverDnDsyevd = c.getMethod("cusolverDnDsyevd", cusolver.cusolverDnContext.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, DoublePointer.class, Integer.TYPE, DoublePointer.class, DoublePointer.class, Integer.TYPE, IntPointer.class);
            this.CUSOLVER_EIG_MODE_VECTOR = (Integer)c.getDeclaredField("CUSOLVER_EIG_MODE_VECTOR").get(null);
            this.CUSOLVER_EIG_MODE_NOVECTOR = (Integer)c.getDeclaredField("CUSOLVER_EIG_MODE_NOVECTOR").get(null);
        }
        catch (Exception ex) {
            log.warn("cusolverDnSsyevd() and cusolverDnDsyevd() are not available", (Throwable)ex);
            this.cusolverDnSsyevd_bufferSize = null;
            this.cusolverDnSsyevd = null;
            this.cusolverDnDsyevd_bufferSize = null;
            this.cusolverDnDsyevd = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        INDArray a = A;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            log.warn("FLOAT getrf called in DOUBLE environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnSgetrf_bufferSize((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (FloatPointer)((FloatPointer)xAPointer.getDevicePointer()), (int)M, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnSgetrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnSgetrf((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (FloatPointer)((FloatPointer)xAPointer.getDevicePointer()), (int)M, (FloatPointer)new CudaPointer(workspace).asFloatPointer(), (IntPointer)new CudaPointer(this.allocator.getPointer(IPIV, ctx)).asIntPointer(), (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgetrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, IPIV, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        log.info("A: {}", (Object)A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dgetrf(int M, int N, INDArray A, INDArray IPIV, INDArray INFO) {
        INDArray a = A;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            log.warn("FLOAT getrf called in FLOAT environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnDgetrf_bufferSize((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (DoublePointer)((DoublePointer)xAPointer.getDevicePointer()), (int)M, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnDgetrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnDgetrf((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (DoublePointer)((DoublePointer)xAPointer.getDevicePointer()), (int)M, (DoublePointer)new CudaPointer(workspace).asDoublePointer(), (IntPointer)new CudaPointer(this.allocator.getPointer(IPIV, ctx)).asIntPointer(), (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgetrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, IPIV, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sgeqrf(int M, int N, INDArray A, INDArray R, INDArray INFO) {
        INDArray a = A;
        INDArray r = R;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            log.warn("FLOAT getrf called in DOUBLE environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (R != null && R.ordering() == 'c') {
            r = R.dup('f');
        }
        INDArray tau = Nd4j.createArrayFromShapeBuffer((DataBuffer)Nd4j.getDataBufferFactory().createFloat((long)N), (DataBuffer)((DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, N}).getFirst()));
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new IllegalStateException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            CublasPointer xTauPointer = new CublasPointer(tau, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnSgeqrf_bufferSize((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (FloatPointer)((FloatPointer)xAPointer.getDevicePointer()), (int)M, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnSgeqrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnSgeqrf((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (FloatPointer)((FloatPointer)xAPointer.getDevicePointer()), (int)M, (FloatPointer)((FloatPointer)xTauPointer.getDevicePointer()), (FloatPointer)new CudaPointer(workspace).asFloatPointer(), (int)worksize, (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgeqrf failed", stat);
            }
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            this.allocator.registerAction(ctx, INFO, new INDArray[0]);
            if (INFO.getInt(new int[]{0}) != 0) {
                throw new BlasException("cusolverDnSgeqrf failed on INFO", INFO.getInt(new int[]{0}));
            }
            if (r != null) {
                r.assign(a.get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)a.columns()), NDArrayIndex.all()}));
                INDArrayIndex[] ix = new INDArrayIndex[2];
                for (int i = 1; i < Math.min(a.rows(), a.columns()); ++i) {
                    ix[0] = NDArrayIndex.point((int)i);
                    ix[1] = NDArrayIndex.interval((int)0, (int)i);
                    r.put(ix, (Number)0);
                }
            }
            try {
                stat = (Integer)this.cusolverDnSorgqr_bufferSize.invoke(null, solverDn, M, N, N, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xTauPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
                worksize = worksizeBuffer.getInt(0L);
                workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
                stat = (Integer)this.cusolverDnSorgqr.invoke(null, solverDn, M, N, N, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xTauPointer.getDevicePointer(), new CudaPointer(workspace).asFloatPointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                throw new RuntimeException("cusolverDnSorgqr() is not available", e);
            }
            if (stat != 0) {
                throw new BlasException("cusolverDnSorgqr failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (r != null && r != R) {
            R.assign(r);
        }
        log.info("A: {}", (Object)A);
        if (R != null) {
            log.info("R: {}", (Object)R);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dgeqrf(int M, int N, INDArray A, INDArray R, INDArray INFO) {
        INDArray a = A;
        INDArray r = R;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            log.warn("DOUBLE getrf called in FLOAT environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (R != null && R.ordering() == 'c') {
            r = R.dup('f');
        }
        INDArray tau = Nd4j.createArrayFromShapeBuffer((DataBuffer)Nd4j.getDataBufferFactory().createDouble((long)N), (Pair)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, N}));
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            CublasPointer xTauPointer = new CublasPointer(tau, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnDgeqrf_bufferSize((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (DoublePointer)((DoublePointer)xAPointer.getDevicePointer()), (int)M, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnDgeqrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnDgeqrf((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (DoublePointer)((DoublePointer)xAPointer.getDevicePointer()), (int)M, (DoublePointer)((DoublePointer)xTauPointer.getDevicePointer()), (DoublePointer)new CudaPointer(workspace).asDoublePointer(), (int)worksize, (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDgeqrf failed", stat);
            }
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            this.allocator.registerAction(ctx, tau, new INDArray[0]);
            this.allocator.registerAction(ctx, INFO, new INDArray[0]);
            if (INFO.getInt(new int[]{0}) != 0) {
                throw new BlasException("cusolverDnDgeqrf failed with info", INFO.getInt(new int[]{0}));
            }
            if (r != null) {
                r.assign(a.get(new INDArrayIndex[]{NDArrayIndex.interval((int)0, (int)a.columns()), NDArrayIndex.all()}));
                INDArrayIndex[] ix = new INDArrayIndex[2];
                for (int i = 1; i < Math.min(a.rows(), a.columns()); ++i) {
                    ix[0] = NDArrayIndex.point((int)i);
                    ix[1] = NDArrayIndex.interval((int)0, (int)i);
                    r.put(ix, (Number)0);
                }
            }
            try {
                stat = (Integer)this.cusolverDnDorgqr_bufferSize.invoke(null, solverDn, M, N, N, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xTauPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
                worksize = worksizeBuffer.getInt(0L);
                workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
                stat = (Integer)this.cusolverDnDorgqr.invoke(null, solverDn, M, N, N, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xTauPointer.getDevicePointer(), new CudaPointer(workspace).asDoublePointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            }
            catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
                throw new RuntimeException("cusolverDnDorgqr() is not available", e);
            }
            if (stat != 0) {
                throw new BlasException("cusolverDnDorgqr failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (r != null && r != R) {
            R.assign(r);
        }
        log.info("A: {}", (Object)A);
        if (R != null) {
            log.info("R: {}", (Object)R);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spotrf(byte uplo, int N, INDArray A, INDArray INFO) {
        int i;
        INDArrayIndex[] ix;
        INDArray a = A;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            log.warn("DOUBLE potrf called in FLOAT environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnSpotrf_bufferSize((cusolver.cusolverDnContext)solverDn, (int)uplo, (int)N, (FloatPointer)((FloatPointer)xAPointer.getDevicePointer()), (int)N, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnSpotrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnSpotrf((cusolver.cusolverDnContext)solverDn, (int)uplo, (int)N, (FloatPointer)((FloatPointer)xAPointer.getDevicePointer()), (int)N, (FloatPointer)new CudaPointer(workspace).asFloatPointer(), (int)worksize, (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSpotrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (uplo == 85) {
            A.assign(A.transpose());
            ix = new INDArrayIndex[2];
            for (i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point((int)i);
                ix[1] = NDArrayIndex.interval((int)0, (int)i);
                A.put(ix, (Number)0);
            }
        } else {
            ix = new INDArrayIndex[2];
            for (i = 0; i < Math.min(A.rows(), A.columns() - 1); ++i) {
                ix[0] = NDArrayIndex.point((int)i);
                ix[1] = NDArrayIndex.interval((int)(i + 1), (int)A.columns());
                A.put(ix, (Number)0);
            }
        }
        log.info("A: {}", (Object)A);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dpotrf(byte uplo, int N, INDArray A, INDArray INFO) {
        int i;
        INDArrayIndex[] ix;
        INDArray a = A;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            log.warn("FLOAT potrf called in DOUBLE environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnDpotrf_bufferSize((cusolver.cusolverDnContext)solverDn, (int)uplo, (int)N, (DoublePointer)((DoublePointer)xAPointer.getDevicePointer()), (int)N, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnDpotrf_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            stat = cusolver.cusolverDnDpotrf((cusolver.cusolverDnContext)solverDn, (int)uplo, (int)N, (DoublePointer)((DoublePointer)xAPointer.getDevicePointer()), (int)N, (DoublePointer)new CudaPointer(workspace).asDoublePointer(), (int)worksize, (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDpotrf failed", stat);
            }
        }
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        if (a != A) {
            A.assign(a);
        }
        if (uplo == 85) {
            A.assign(A.transpose());
            ix = new INDArrayIndex[2];
            for (i = 1; i < Math.min(A.rows(), A.columns()); ++i) {
                ix[0] = NDArrayIndex.point((int)i);
                ix[1] = NDArrayIndex.interval((int)0, (int)i);
                A.put(ix, (Number)0);
            }
        } else {
            ix = new INDArrayIndex[2];
            for (i = 0; i < Math.min(A.rows(), A.columns() - 1); ++i) {
                ix[0] = NDArrayIndex.point((int)i);
                ix[1] = NDArrayIndex.interval((int)(i + 1), (int)A.columns());
                A.put(ix, (Number)0);
            }
        }
        log.info("A: {}", (Object)A);
    }

    public void getri(int N, INDArray A, int lda, int[] IPIV, INDArray WORK, int lwork, int INFO) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        INDArray a = A;
        INDArray u = U;
        INDArray vt = VT;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            log.warn("FLOAT gesvd called in DOUBLE environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (U != null && U.ordering() == 'c') {
            u = U.dup('f');
        }
        if (VT != null && VT.ordering() == 'c') {
            vt = VT.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnSgesvd_bufferSize((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnSgesvd_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            DataBuffer rwork = Nd4j.getDataBufferFactory().createFloat((long)((M < N ? M : N) - 1));
            stat = cusolver.cusolverDnSgesvd((cusolver.cusolverDnContext)solverDn, (byte)jobu, (byte)jobvt, (int)M, (int)N, (FloatPointer)((FloatPointer)xAPointer.getDevicePointer()), (int)M, (FloatPointer)new CudaPointer(this.allocator.getPointer(S, ctx)).asFloatPointer(), (FloatPointer)(U == null ? null : new CudaPointer(this.allocator.getPointer(u, ctx)).asFloatPointer()), (int)M, (FloatPointer)(VT == null ? null : new CudaPointer(this.allocator.getPointer(vt, ctx)).asFloatPointer()), (int)N, (FloatPointer)new CudaPointer(workspace).asFloatPointer(), (int)worksize, (FloatPointer)new CudaPointer(this.allocator.getPointer(rwork, ctx)).asFloatPointer(), (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnSgesvd failed", stat);
            }
        }
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, S, new INDArray[0]);
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        if (U != null) {
            this.allocator.registerAction(ctx, u, new INDArray[0]);
        }
        if (VT != null) {
            this.allocator.registerAction(ctx, vt, new INDArray[0]);
        }
        if (a != A) {
            A.assign(a);
        }
        if (u != U) {
            U.assign(u);
        }
        if (vt != VT) {
            VT.assign(vt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dgesvd(byte jobu, byte jobvt, int M, int N, INDArray A, INDArray S, INDArray U, INDArray VT, INDArray INFO) {
        INDArray a = A;
        INDArray u = U;
        INDArray vt = VT;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            log.warn("DOUBLE gesvd called in FLOAT environment");
        }
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        if (U != null && U.ordering() == 'c') {
            u = U.dup('f');
        }
        if (VT != null && VT.ordering() == 'c') {
            vt = VT.dup('f');
        }
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            int result = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (result != 0) {
                throw new BlasException("solverSetStream failed");
            }
            CublasPointer xAPointer = new CublasPointer(a, ctx);
            DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
            int stat = cusolver.cusolverDnSgesvd_bufferSize((cusolver.cusolverDnContext)solverDn, (int)M, (int)N, (IntPointer)((IntPointer)worksizeBuffer.addressPointer()));
            if (stat != 0) {
                throw new BlasException("cusolverDnSgesvd_bufferSize failed", stat);
            }
            int worksize = worksizeBuffer.getInt(0L);
            Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
            DataBuffer rwork = Nd4j.getDataBufferFactory().createDouble((long)((M < N ? M : N) - 1));
            stat = cusolver.cusolverDnDgesvd((cusolver.cusolverDnContext)solverDn, (byte)jobu, (byte)jobvt, (int)M, (int)N, (DoublePointer)((DoublePointer)xAPointer.getDevicePointer()), (int)M, (DoublePointer)new CudaPointer(this.allocator.getPointer(S, ctx)).asDoublePointer(), (DoublePointer)(U == null ? null : new CudaPointer(this.allocator.getPointer(u, ctx)).asDoublePointer()), (int)M, (DoublePointer)(VT == null ? null : new CudaPointer(this.allocator.getPointer(vt, ctx)).asDoublePointer()), (int)N, (DoublePointer)new CudaPointer(workspace).asDoublePointer(), (int)worksize, (DoublePointer)new CudaPointer(this.allocator.getPointer(rwork, ctx)).asDoublePointer(), (IntPointer)new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
            if (stat != 0) {
                throw new BlasException("cusolverDnDgesvd failed" + stat);
            }
        }
        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
        this.allocator.registerAction(ctx, S, new INDArray[0]);
        this.allocator.registerAction(ctx, a, new INDArray[0]);
        if (U != null) {
            this.allocator.registerAction(ctx, u, new INDArray[0]);
        }
        if (VT != null) {
            this.allocator.registerAction(ctx, vt, new INDArray[0]);
        }
        if (a != A) {
            A.assign(a);
        }
        if (u != U) {
            U.assign(u);
        }
        if (vt != VT) {
            VT.assign(vt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ssyev(char _jobz, char _uplo, int N, INDArray A, INDArray R) {
        int uplo;
        if (this.cusolverDnSsyevd_bufferSize == null || this.cusolverDnSsyevd == null) {
            throw new BlasException("Method not supported in cuda version < 8.0");
        }
        int status = -1;
        int jobz = _jobz == 'V' ? this.CUSOLVER_EIG_MODE_VECTOR : this.CUSOLVER_EIG_MODE_NOVECTOR;
        int n = uplo = _uplo == 'L' ? 0 : 1;
        if (Nd4j.dataType() != DataBuffer.Type.FLOAT) {
            log.warn("FLOAT ssyev called in DOUBLE environment");
        }
        INDArray a = A;
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        int M = A.rows();
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            status = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (status == 0) {
                CublasPointer xAPointer = new CublasPointer(a, ctx);
                CublasPointer xRPointer = new CublasPointer(R, ctx);
                DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
                try {
                    status = (Integer)this.cusolverDnSsyevd_bufferSize.invoke(null, solverDn, jobz, uplo, M, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xRPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
                    if (status == 0) {
                        int worksize = worksizeBuffer.getInt(0L);
                        Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
                        INDArray INFO = Nd4j.createArrayFromShapeBuffer((DataBuffer)Nd4j.getDataBufferFactory().createInt(1L), (Pair)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}));
                        status = (Integer)this.cusolverDnSsyevd.invoke(null, solverDn, jobz, uplo, M, (FloatPointer)xAPointer.getDevicePointer(), M, (FloatPointer)xRPointer.getDevicePointer(), new CudaPointer(workspace).asFloatPointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
                        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
                        if (status == 0) {
                            status = INFO.getInt(new int[]{0});
                        }
                    }
                }
                catch (IllegalAccessException | InvocationTargetException iae) {
                    throw new BlasException("Check the cuda libs - unexpected exception:" + iae.getMessage());
                }
            }
        }
        if (status == 0) {
            this.allocator.registerAction(ctx, R, new INDArray[0]);
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            if (a != A) {
                A.assign(a);
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dsyev(char _jobz, char _uplo, int N, INDArray A, INDArray R) {
        int uplo;
        if (this.cusolverDnDsyevd_bufferSize == null || this.cusolverDnDsyevd == null) {
            throw new BlasException("Method not supported in cuda version < 8.0");
        }
        int status = -1;
        int jobz = _jobz == 'V' ? this.CUSOLVER_EIG_MODE_VECTOR : this.CUSOLVER_EIG_MODE_NOVECTOR;
        int n = uplo = _uplo == 'L' ? 0 : 1;
        if (Nd4j.dataType() != DataBuffer.Type.DOUBLE) {
            log.warn("DOUBLE dsyev called in FLOAT environment");
        }
        INDArray a = A;
        if (A.ordering() == 'c') {
            a = A.dup('f');
        }
        int M = A.rows();
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudaContext ctx = (CudaContext)this.allocator.getDeviceContext().getContext();
        cusolverDnHandle_t handle = ctx.getSolverHandle();
        cusolver.cusolverDnContext solverDn = new cusolver.cusolverDnContext((Pointer)handle);
        cusolverDnHandle_t cusolverDnHandle_t2 = handle;
        synchronized (cusolverDnHandle_t2) {
            status = cusolver.cusolverDnSetStream((cusolver.cusolverDnContext)new cusolver.cusolverDnContext((Pointer)handle), (cuda.CUstream_st)new cuda.CUstream_st((Pointer)ctx.getOldStream()));
            if (status == 0) {
                CublasPointer xAPointer = new CublasPointer(a, ctx);
                CublasPointer xRPointer = new CublasPointer(R, ctx);
                DataBuffer worksizeBuffer = Nd4j.getDataBufferFactory().createInt(1L);
                try {
                    status = (Integer)this.cusolverDnDsyevd_bufferSize.invoke(null, solverDn, jobz, uplo, M, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xRPointer.getDevicePointer(), (IntPointer)worksizeBuffer.addressPointer());
                    if (status == 0) {
                        int worksize = worksizeBuffer.getInt(0L);
                        Workspace workspace = new Workspace(worksize * Nd4j.sizeOfDataType());
                        INDArray INFO = Nd4j.createArrayFromShapeBuffer((DataBuffer)Nd4j.getDataBufferFactory().createInt(1L), (Pair)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}));
                        status = (Integer)this.cusolverDnDsyevd.invoke(null, solverDn, jobz, uplo, M, (DoublePointer)xAPointer.getDevicePointer(), M, (DoublePointer)xRPointer.getDevicePointer(), new CudaPointer(workspace).asDoublePointer(), worksize, new CudaPointer(this.allocator.getPointer(INFO, ctx)).asIntPointer());
                        this.allocator.registerAction(ctx, INFO, new INDArray[0]);
                        if (status == 0) {
                            status = INFO.getInt(new int[]{0});
                        }
                    }
                }
                catch (IllegalAccessException | InvocationTargetException iae) {
                    throw new BlasException("Check the cuda libs - unexpected exception:" + iae.getMessage());
                }
            }
        }
        if (status == 0) {
            this.allocator.registerAction(ctx, R, new INDArray[0]);
            this.allocator.registerAction(ctx, a, new INDArray[0]);
            if (a != A) {
                A.assign(a);
            }
        }
        return status;
    }

    static class Workspace
    extends Pointer {
        public Workspace(long size) {
            super(NativeOpsHolder.getInstance().getDeviceNativeOps().mallocDevice(size, null, 0));
            this.deallocator(new Pointer.Deallocator(){

                public void deallocate() {
                    NativeOpsHolder.getInstance().getDeviceNativeOps().freeDevice((Pointer)Workspace.this, null);
                }
            });
        }
    }
}

